/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apollo {
    public static void main(String[] args) throws Throwable, NoSuchMethodException, IllegalAccessException {
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (argList.isEmpty()) {
            System.err.println("Usage " + Apollo.class.getName() + " <bootdir>(:<bootdir>)* <main-class> <arg>*");
            System.err.println();
            System.err.println("Mising <bootdir>");
            System.exit(2);
        }
        String[] bootdirs = argList.removeFirst().split(":");
        if (argList.isEmpty()) {
            System.err.println("Usage " + Apollo.class.getName() + " <bootdir>(:<bootdir>)* <main-class> <arg>*");
            System.err.println();
            System.err.println("Mising <main-class>");
            System.exit(2);
        }
        String mainClass = argList.removeFirst();
        String[] mainArgs = argList.toArray(new String[argList.size()]);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String dir : bootdirs) {
            if ((dir = dir.trim()).isEmpty()) continue;
            File bootdir = new File(dir);
            if (bootdir.isDirectory()) {
                ArrayList<File> files = new ArrayList<File>();
                for (File f : bootdir.listFiles()) {
                    if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".zip")) continue;
                    files.add(f);
                }
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File file, File file1) {
                        return file.getName().compareTo(file1.getName());
                    }
                });
                for (File f : files) {
                    Apollo.add(urls, f);
                }
                continue;
            }
            if (!bootdir.isFile()) continue;
            Apollo.add(urls, bootdir);
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        Class<?> clazz = loader.loadClass(mainClass);
        Method method = clazz.getMethod("main", args.getClass());
        try {
            method.invoke(null, new Object[]{mainArgs});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static void add(ArrayList<URL> urls, File file) {
        try {
            urls.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

