/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MemoryImageSource;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.igoweb.util.CacheMap;

public class BoardBackground {
    private static final int SIZE = 256;
    private static final byte[][] cloud = BoardBackground.drawCloud();
    private static final int[] colors = BoardBackground.mixColors();
    private static final Color monotoneBoardColor = new Color(251, 196, 103);
    private static final CacheMap<Object, BoardBackground> images = new CacheMap(true);
    public final int imageSize;
    private final int boardSize;
    private final boolean drawLabels;
    private final boolean isTextured;
    public final int gridOffset;
    public final int gridW;
    public final Image image;
    private static final int gapSize = 2;

    public static BoardBackground get(JComponent parent, int imageSize, int boardSize, boolean drawLabels, boolean textured) {
        Object key = BoardBackground.getKey(imageSize, boardSize, drawLabels, textured);
        BoardBackground result = images.get(key);
        if (result == null) {
            result = new BoardBackground(parent, imageSize, boardSize, drawLabels, textured);
            images.put(key, result);
        }
        return result;
    }

    private BoardBackground(JComponent parent, int imageSize, int boardSize, boolean drawLabels, boolean textured) {
        if (imageSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.imageSize = imageSize;
        this.boardSize = boardSize;
        this.drawLabels = drawLabels;
        this.isTextured = textured;
        this.image = parent.createImage(imageSize, imageSize);
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        if (this.isTextured) {
            Image tmpImg = BoardBackground.drawPic(parent, imageSize);
            g2d.drawImage(tmpImg, 0, 0, null);
            tmpImg.flush();
        } else {
            g2d.setColor(monotoneBoardColor);
            g2d.fillRect(0, 0, imageSize, imageSize);
        }
        if (drawLabels) {
            Font boldFont = UIManager.getFont("Label.font").deriveFont(1);
            g2d.setColor(Color.black);
            g2d.setFont(boldFont);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontRenderContext frc = g2d.getFontRenderContext();
            float maxAscend = 0.0f;
            float maxDescend = 0.0f;
            float maxWidth = 0.0f;
            StringTokenizer xLabels = new StringTokenizer("A B C D E F G H J K L M N O P Q R S T U V W X Y Z AA BB CC DD EE FF GG HH JJ KK LL MM NN");
            StringTokenizer yLabels = new StringTokenizer("1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38");
            for (int i = 0; i < boardSize; ++i) {
                Rectangle2D textBounds = boldFont.getStringBounds(xLabels.nextToken(), frc);
                float param = -((float)textBounds.getMinY());
                if (i == 0 || param > maxAscend) {
                    maxAscend = param;
                }
                param = (float)textBounds.getMaxY();
                if (i == 0 || param > maxDescend) {
                    maxDescend = param;
                }
                if (!((param = (float)((textBounds = boldFont.getStringBounds(yLabels.nextToken(), frc)).getMaxX() - textBounds.getMinX())) > maxWidth)) continue;
                maxWidth = param;
            }
            float labelOffset = maxWidth > maxAscend + maxDescend ? maxWidth : maxAscend + maxDescend;
            this.gridW = (imageSize - 2 * ((int)Math.ceil(labelOffset) + 2)) / boardSize;
            this.gridOffset = (imageSize - this.gridW * boardSize) / 2;
            labelOffset = ((float)this.gridOffset + maxAscend - maxDescend) * 0.5f;
            xLabels = new StringTokenizer("A B C D E F G H J K L M N O P Q R S T U V W X Y Z AA BB CC DD EE FF GG HH JJ KK LL MM NN");
            yLabels = new StringTokenizer("1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38");
            for (int i = 0; i < boardSize; ++i) {
                String label = xLabels.nextToken();
                Rectangle2D textBounds = boldFont.getStringBounds(label, frc);
                float xCenter = (float)this.gridOffset + ((float)i + 0.5f) * (float)this.gridW - 0.5f * (float)(textBounds.getMaxX() + textBounds.getMinX());
                g2d.drawString(label, xCenter, labelOffset);
                g2d.drawString(label, xCenter, (float)(imageSize - this.gridOffset) + labelOffset);
                label = yLabels.nextToken();
                textBounds = boldFont.getStringBounds(label, frc);
                float yCenter = (float)this.gridOffset + ((float)(boardSize - i) - 0.5f) * (float)this.gridW + 0.5f * (maxAscend - maxDescend);
                xCenter = 0.5f * ((float)this.gridOffset - (float)(textBounds.getMaxX() + textBounds.getMinX()));
                g2d.drawString(label, xCenter, yCenter);
                g2d.drawString(label, (float)(imageSize - this.gridOffset) + xCenter, yCenter);
            }
        } else {
            this.gridW = (imageSize - 4) / boardSize;
            this.gridOffset = (imageSize - this.gridW * boardSize) / 2;
        }
    }

    public int hashCode() {
        return this.imageSize << 8 ^ this.boardSize << 2 ^ (this.drawLabels ? 2 : 0) ^ (this.isTextured ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BoardBackground) {
            BoardBackground peer = (BoardBackground)obj;
            return this.boardSize == peer.boardSize && this.imageSize == peer.imageSize && this.drawLabels == peer.drawLabels && this.isTextured == peer.isTextured;
        }
        return false;
    }

    private static Image drawPic(JComponent parent, int size) {
        int[] pix = new int[size * size];
        int stripeSize = 4;
        int stripeShift = 2;
        while (stripeSize * 400 < size) {
            stripeSize += stripeSize;
            ++stripeShift;
        }
        int xAddMin = 256 / size;
        int addStd = 256 - xAddMin * size;
        int pixNum = 0;
        for (int y = 0; y < size; ++y) {
            int cmy = y * 256 / size;
            int cmx = 0;
            int current = 1 - size;
            for (int x = 0; x < size; ++x) {
                int nextCmx = cmx + xAddMin;
                if ((current += addStd) > 0) {
                    ++nextCmx;
                    current -= size;
                }
                int cmap1 = cloud[cmx][cmy] & 0xFF;
                int cmap2 = cloud[nextCmx & 0xFF][cmy] & 0xFF;
                int color1 = (x << 8) + (cmap1 << stripeShift + 2);
                int color2 = (x << 8) + 128 + (cmap1 << stripeShift + 1) + (cmap2 << stripeShift + 1);
                pix[pixNum++] = colors[(color1 >> stripeShift & 0xFF) + (color2 >> stripeShift & 0xFF) >> 1];
                cmx = nextCmx;
            }
        }
        return parent.createImage(new MemoryImageSource(size, size, pix, 0, size));
    }

    private static byte[][] drawCloud() {
        int step;
        int STRETCH = 3;
        double FACTOR = 0.7;
        int[][] map = new int[256][257];
        double fskew = 192000.0;
        Random rnd = new Random();
        map[0][0] = rnd.nextInt(0x2000001) - 0x1000000;
        for (step = 128; step > 0; step /= 2) {
            BoardBackground.diag(map, step, (int)fskew, rnd);
            fskew *= 0.7;
            if (fskew < 1.0) {
                fskew = 1.0;
            }
            BoardBackground.perp(map, step, (int)fskew, rnd);
            fskew *= 0.7;
            if (!(fskew < 1.0)) continue;
            fskew = 1.0;
        }
        for (int j = 32; j >= 0; --j) {
            for (int i = 0; i < 256; ++i) {
                map[i][j << 3] = map[i][j];
            }
        }
        for (step = 4; step > 0; step >>= 1) {
            fskew = 1.0;
            BoardBackground.vert(map, step, (int)fskew, rnd);
            fskew *= 0.48999999999999994;
            if (!(fskew < 1.0)) continue;
            fskew = 1.0;
        }
        byte[][] result = new byte[256][256];
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                int tmp = map[x][y] >> 8 & 0x1FF;
                if (tmp > 255) {
                    tmp = 511 - tmp;
                }
                result[x][y] = (byte)tmp;
            }
        }
        return result;
    }

    private static void diag(int[][] newCloud, int step, int skew, Random rnd) {
        for (int i = 0; i < 256; i += step) {
            for (int j = 0; j < 256; j += step) {
                if ((i & step) == 0 || (j & step) == 0) continue;
                newCloud[i][j] = (newCloud[i - step][j - step] + newCloud[i - step][j + step & 0xFF] + newCloud[i + step & 0xFF][j - step] + newCloud[i + step & 0xFF][j + step & 0xFF]) / 4 + rnd.nextInt(skew * 2 + 1) - skew;
            }
        }
    }

    private static void perp(int[][] newCloud, int step, int skew, Random rnd) {
        for (int i = 0; i < 256; i += step) {
            for (int j = 0; j < 256; j += step) {
                if ((i & step) == (j & step)) continue;
                newCloud[i][j] = (newCloud[i - step & 0xFF][j] + newCloud[i][j + step & 0xFF] + newCloud[i + step & 0xFF][j] + newCloud[i][j - step & 0xFF]) / 4 + rnd.nextInt(skew * 2 + 1) - skew;
            }
        }
    }

    private static void vert(int[][] newCloud, int step, int skew, Random rnd) {
        for (int i = 0; i < 256; ++i) {
            for (int j = step; j < 256; j += step << 1) {
                newCloud[i][j] = (newCloud[i - 1 & 0xFF][j - step] + newCloud[i][j - step] + newCloud[i + 1 & 0xFF][j - step] + newCloud[i - 1 & 0xFF][j + step] + newCloud[i][j + step] + newCloud[i + 1 & 0xFF][j + step]) / 6 + rnd.nextInt(skew * 2 + 1) - skew;
            }
        }
    }

    private static int[] mixColors() {
        int hiR = 234;
        int hiG = 190;
        int hiB = 96;
        int loR = 204;
        int loG = 165;
        int loB = 87;
        int[] result = new int[256];
        for (int i = 0; i < 256; ++i) {
            int mix2 = i * 255;
            int mix1 = 65025 - mix2;
            int red = (234 * mix1 + 204 * mix2 + 32512) / 65025;
            int grn = (190 * mix1 + 165 * mix2 + 32512) / 65025;
            int blu = (96 * mix1 + 87 * mix2 + 32512) / 65025;
            result[i] = 0xFF000000 | red << 16 | grn << 8 | blu;
        }
        return result;
    }

    public static int borderSize(int boardSize) {
        Font boldFont = UIManager.getFont("Label.font").deriveFont(1);
        StringTokenizer xLabels = new StringTokenizer("A B C D E F G H J K L M N O P Q R S T U V W X Y Z AA BB CC DD EE FF GG HH JJ KK LL MM NN");
        StringTokenizer yLabels = new StringTokenizer("1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38");
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        double max = 0.0;
        for (int i = 0; i < boardSize; ++i) {
            double size = boldFont.getStringBounds(xLabels.nextToken(), frc).getHeight();
            if (size > max) {
                max = size;
            }
            if (!((size = boldFont.getStringBounds(yLabels.nextToken(), frc).getWidth()) > max)) continue;
            max = size;
        }
        return (int)Math.ceil(max) + 2;
    }

    public static Object getKey(int imageSize, int boardSize, boolean drawLabels, boolean textured) {
        long keyVal = (long)imageSize | (long)boardSize << 32;
        if (drawLabels) {
            keyVal |= 0x80000000L;
        }
        if (textured) {
            keyVal |= Long.MIN_VALUE;
        }
        return new Long(keyVal);
    }
}

