/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.util.HashMap;
import java.util.Locale;

public enum InvoiceState {
    STARTED,
    SUCCESS,
    REVIEW,
    DENIED,
    ERROR,
    UNKNOWN,
    REFUNDED;

    public final String sqlName = this.name().toLowerCase(Locale.US);
    private static HashMap<String, InvoiceState> nameToState;

    public static InvoiceState get(String sqlName) {
        InvoiceState result;
        if (nameToState == null) {
            InvoiceState.initNameToState();
        }
        if ((result = nameToState.get(sqlName)) == null) {
            throw new IllegalArgumentException("Invalid state sql name: " + sqlName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNameToState() {
        Class<InvoiceState> clazz = InvoiceState.class;
        synchronized (InvoiceState.class) {
            if (nameToState == null) {
                HashMap<String, InvoiceState> map = new HashMap<String, InvoiceState>();
                for (InvoiceState state : InvoiceState.values()) {
                    map.put(state.sqlName, state);
                }
                nameToState = map;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public boolean isFunded() {
        return this == SUCCESS || this == REVIEW;
    }

    public boolean canBecome(InvoiceState newState) {
        switch (this) {
            case STARTED: {
                return newState != STARTED;
            }
            case SUCCESS: {
                return newState == REFUNDED;
            }
            case REVIEW: 
            case UNKNOWN: {
                return newState == SUCCESS || newState == DENIED || newState == REFUNDED;
            }
            case DENIED: 
            case REFUNDED: {
                return false;
            }
        }
        throw new RuntimeException();
    }
}

