/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.EncryptedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.SignedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.UsernameTokenProcessor;
import org.apache.ws.security.policy.parser.processors.X509TokenProcessor;

public class SignedEndorsingSupportingTokensProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedSignedEndorsingSupportingTokens = false;

    private void initializeSignedEndorsingSupportingTokens(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.usernameToken.copy();
        tmpSpt.setProcessTokenMethod(new UsernameTokenProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod(new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
        SignedPartsElementsProcessor spep = new SignedPartsElementsProcessor();
        tmpSpt = SecurityPolicy.signedParts.copy();
        tmpSpt.setProcessTokenMethod(spep);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedElements.copy();
        tmpSpt.setProcessTokenMethod(spep);
        spt.setChildToken(tmpSpt);
        EncryptedPartsElementsProcessor epep = new EncryptedPartsElementsProcessor();
        tmpSpt = SecurityPolicy.encryptedParts.copy();
        tmpSpt.setProcessTokenMethod(epep);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptedElements.copy();
        tmpSpt.setProcessTokenMethod(epep);
        spt.setChildToken(tmpSpt);
    }

    public Object doSignedEndorsingSupportingTokens(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedSignedEndorsingSupportingTokens) break;
                try {
                    this.initializeSignedEndorsingSupportingTokens(spt);
                    this.initializedSignedEndorsingSupportingTokens = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }
}

