/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class Join
extends BinaryPlan {
    private final JoinType type;
    private final Expression condition;

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinType type, Expression condition) {
        super(source, left, right);
        this.type = type;
        this.condition = condition;
    }

    @Override
    protected NodeInfo<Join> info() {
        return NodeInfo.create(this, Join::new, this.left(), this.right(), this.type, this.condition);
    }

    @Override
    public LogicalPlan replaceChildren(List<LogicalPlan> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new Join(this.source(), newChildren.get(0), newChildren.get(1), this.type, this.condition);
    }

    public JoinType type() {
        return this.type;
    }

    public Expression condition() {
        return this.condition;
    }

    @Override
    public List<Attribute> output() {
        switch (this.type) {
            case LEFT: {
                return CollectionUtils.combine(this.left().output(), Join.makeNullable(this.right().output()));
            }
            case RIGHT: {
                return CollectionUtils.combine(Join.makeNullable(this.left().output()), this.right().output());
            }
            case FULL: {
                return CollectionUtils.combine(Join.makeNullable(this.left().output()), Join.makeNullable(this.right().output()));
            }
        }
        return CollectionUtils.combine(this.left().output(), this.right().output());
    }

    private static List<Attribute> makeNullable(List<Attribute> output) {
        return output.stream().map(a -> a.withNullability(Nullability.TRUE)).collect(Collectors.toList());
    }

    @Override
    public boolean expressionsResolved() {
        return this.condition == null || this.condition.resolved();
    }

    public boolean duplicatesResolved() {
        return this.left().outputSet().intersect(this.right().outputSet()).isEmpty();
    }

    @Override
    public boolean resolved() {
        return this.childrenResolved() && this.duplicatesResolved() && this.expressionsResolved() && (this.condition == null || DataType.BOOLEAN == this.condition.dataType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.condition, this.left(), this.right()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.condition, other.condition) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public static enum JoinType {
        INNER,
        LEFT,
        RIGHT,
        FULL,
        IMPLICIT;

    }
}

