/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CRAMMD5BindRequest
extends SASLBindRequest
implements CallbackHandler {
    public static final String CRAMMD5_MECHANISM_NAME = "CRAM-MD5";
    private static final long serialVersionUID = -4556570436768136483L;
    private final ASN1OctetString password;
    private int messageID = -1;
    private final List<String> unhandledCallbackMessages;
    private final String authenticationID;

    public CRAMMD5BindRequest(String authenticationID, String password) {
        this(authenticationID, new ASN1OctetString(password), NO_CONTROLS);
        Validator.ensureNotNull(password);
    }

    public CRAMMD5BindRequest(String authenticationID, byte[] password) {
        this(authenticationID, new ASN1OctetString(password), NO_CONTROLS);
        Validator.ensureNotNull(password);
    }

    public CRAMMD5BindRequest(String authenticationID, ASN1OctetString password) {
        this(authenticationID, password, NO_CONTROLS);
    }

    public CRAMMD5BindRequest(String authenticationID, String password, Control ... controls) {
        this(authenticationID, new ASN1OctetString(password), controls);
        Validator.ensureNotNull(password);
    }

    public CRAMMD5BindRequest(String authenticationID, byte[] password, Control ... controls) {
        this(authenticationID, new ASN1OctetString(password), controls);
        Validator.ensureNotNull(password);
    }

    public CRAMMD5BindRequest(String authenticationID, ASN1OctetString password, Control ... controls) {
        super(controls);
        Validator.ensureNotNull(authenticationID, password);
        this.authenticationID = authenticationID;
        this.password = password;
        this.unhandledCallbackMessages = new ArrayList<String>(5);
    }

    @Override
    public String getSASLMechanismName() {
        return CRAMMD5_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getPasswordString() {
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        return this.password.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        SaslClient saslClient;
        this.unhandledCallbackMessages.clear();
        try {
            String[] mechanisms = new String[]{CRAMMD5_MECHANISM_NAME};
            saslClient = Sasl.createSaslClient(mechanisms, null, "ldap", connection.getConnectedAddress(), null, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CRAMMD5_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, CRAMMD5_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection), this.unhandledCallbackMessages);
        try {
            BindResult bindResult = helper.processSASLBind();
            return bindResult;
        }
        finally {
            this.messageID = helper.getMessageID();
        }
    }

    @Override
    public CRAMMD5BindRequest getRebindRequest(String host, int port) {
        return new CRAMMD5BindRequest(this.authenticationID, this.password, this.getControls());
    }

    @Override
    @InternalUseOnly
    public void handle(Callback[] callbacks) {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected CRAM-MD5 SASL callback of type " + callback.getClass().getName());
            }
            this.unhandledCallbackMessages.add(LDAPMessages.ERR_CRAMMD5_UNEXPECTED_CALLBACK.get(callback.getClass().getName()));
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public CRAMMD5BindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public CRAMMD5BindRequest duplicate(Control[] controls) {
        CRAMMD5BindRequest bindRequest = new CRAMMD5BindRequest(this.authenticationID, this.password, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("CRAMMD5BindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(3);
        constructorArgs.add(ToCodeArgHelper.createString(this.authenticationID, "Authentication ID"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-password---", "Bind Password"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "CRAMMD5BindRequest", requestID + "Request", "new CRAMMD5BindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

