/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncWaitStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.RolloverAction;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class WaitForRolloverReadyStep
extends AsyncWaitStep {
    private static final Logger logger = LogManager.getLogger(WaitForRolloverReadyStep.class);
    public static final String NAME = "check-rollover-ready";
    private final ByteSizeValue maxSize;
    private final TimeValue maxAge;
    private final Long maxDocs;

    public WaitForRolloverReadyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, ByteSizeValue maxSize, TimeValue maxAge, Long maxDocs) {
        super(key, nextStepKey, client);
        this.maxSize = maxSize;
        this.maxAge = maxAge;
        this.maxDocs = maxDocs;
    }

    @Override
    public void evaluateCondition(IndexMetaData indexMetaData, AsyncWaitStep.Listener listener) {
        boolean indexingComplete;
        String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetaData.getSettings());
        if (Strings.isNullOrEmpty((String)rolloverAlias)) {
            listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "setting [%s] for index [%s] is empty or not defined", "index.lifecycle.rollover_alias", indexMetaData.getIndex().getName())));
            return;
        }
        boolean aliasPointsToThisIndex = indexMetaData.getAliases().containsKey((Object)rolloverAlias);
        Boolean isWriteIndex = null;
        if (aliasPointsToThisIndex) {
            isWriteIndex = ((AliasMetaData)indexMetaData.getAliases().get((Object)rolloverAlias)).writeIndex();
        }
        if (indexingComplete = ((Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetaData.getSettings())).booleanValue()) {
            logger.trace(indexMetaData.getIndex() + " has lifecycle complete set, skipping " + NAME);
            if (aliasPointsToThisIndex && Boolean.TRUE.equals(isWriteIndex)) {
                listener.onFailure(new IllegalStateException(String.format(Locale.ROOT, "index [%s] has [%s] set to [true], but is still the write index for alias [%s]", indexMetaData.getIndex().getName(), "index.lifecycle.indexing_complete", rolloverAlias)));
                return;
            }
            listener.onResponse(true, new EmptyInfo());
            return;
        }
        if (!aliasPointsToThisIndex) {
            listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] does not point to index [%s]", "index.lifecycle.rollover_alias", rolloverAlias, indexMetaData.getIndex().getName())));
            return;
        }
        if (Boolean.FALSE.equals(isWriteIndex)) {
            listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not the write index for alias [%s]", indexMetaData.getIndex().getName(), rolloverAlias)));
        }
        RolloverRequest rolloverRequest = new RolloverRequest(rolloverAlias, null);
        rolloverRequest.dryRun(true);
        if (this.maxAge != null) {
            rolloverRequest.addMaxIndexAgeCondition(this.maxAge);
        }
        if (this.maxSize != null) {
            rolloverRequest.addMaxIndexSizeCondition(this.maxSize);
        }
        if (this.maxDocs != null) {
            rolloverRequest.addMaxIndexDocsCondition(this.maxDocs.longValue());
        }
        this.getClient().admin().indices().rolloverIndex(rolloverRequest, ActionListener.wrap(response -> listener.onResponse(response.getConditionStatus().values().stream().anyMatch(i -> i), new EmptyInfo()), listener::onFailure));
    }

    ByteSizeValue getMaxSize() {
        return this.maxSize;
    }

    TimeValue getMaxAge() {
        return this.maxAge;
    }

    Long getMaxDocs() {
        return this.maxDocs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxSize, this.maxAge, this.maxDocs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaitForRolloverReadyStep other = (WaitForRolloverReadyStep)obj;
        return super.equals(obj) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.maxDocs, other.maxDocs);
    }

    private class EmptyInfo
    implements ToXContentObject {
        private EmptyInfo() {
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

