/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;

public abstract class ClusterPermission {
    private final ClusterPrivilege privilege;

    ClusterPermission(ClusterPrivilege privilege) {
        this.privilege = privilege;
    }

    public ClusterPrivilege privilege() {
        return this.privilege;
    }

    public abstract boolean check(String var1, TransportRequest var2);

    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return Operations.subsetOf((Automaton)clusterPrivilege.getAutomaton(), (Automaton)this.privilege().getAutomaton());
    }

    public abstract List<Tuple<ClusterPrivilege, ConditionalClusterPrivilege>> privileges();

    public static class CompositeClusterPermission
    extends ClusterPermission {
        private final Collection<ClusterPermission> children;

        public CompositeClusterPermission(Collection<ClusterPermission> children) {
            super(CompositeClusterPermission.buildPrivilege(children));
            this.children = children;
        }

        private static ClusterPrivilege buildPrivilege(Collection<ClusterPermission> children) {
            Set<String> names = children.stream().map(ClusterPermission::privilege).map(Privilege::name).flatMap(Collection::stream).collect(Collectors.toSet());
            return ClusterPrivilege.get(names);
        }

        @Override
        public List<Tuple<ClusterPrivilege, ConditionalClusterPrivilege>> privileges() {
            return this.children.stream().map(ClusterPermission::privileges).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return this.children.stream().anyMatch(p -> p.check(action, request));
        }

        @Override
        public boolean grants(ClusterPrivilege clusterPrivilege) {
            return this.children.stream().anyMatch(p -> p.grants(clusterPrivilege));
        }
    }

    public static class ConditionalClusterPermission
    extends ClusterPermission {
        private final ConditionalClusterPrivilege conditionalPrivilege;

        public ConditionalClusterPermission(ConditionalClusterPrivilege conditionalPrivilege) {
            super(conditionalPrivilege.getPrivilege());
            this.conditionalPrivilege = conditionalPrivilege;
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return ((ClusterPermission)this).privilege.predicate().test(action) && this.conditionalPrivilege.getRequestPredicate().test(request);
        }

        @Override
        public List<Tuple<ClusterPrivilege, ConditionalClusterPrivilege>> privileges() {
            return Collections.singletonList(new Tuple((Object)((ClusterPermission)this).privilege, (Object)this.conditionalPrivilege));
        }
    }

    public static class SimpleClusterPermission
    extends ClusterPermission {
        public static final SimpleClusterPermission NONE = new SimpleClusterPermission(ClusterPrivilege.NONE);
        private final Predicate<String> predicate;

        SimpleClusterPermission(ClusterPrivilege privilege) {
            super(privilege);
            this.predicate = privilege.predicate();
        }

        @Override
        public boolean check(String action, TransportRequest request) {
            return this.predicate.test(action);
        }

        @Override
        public List<Tuple<ClusterPrivilege, ConditionalClusterPrivilege>> privileges() {
            return Collections.singletonList(new Tuple((Object)((ClusterPermission)this).privilege, null));
        }
    }
}

