/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.watch;

import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherXContentParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WatchStatus
implements ToXContentObject,
Streamable {
    public static final String INCLUDE_STATE = "include_state";
    private State state;
    @Nullable
    private ExecutionState executionState;
    @Nullable
    private DateTime lastChecked;
    @Nullable
    private DateTime lastMetCondition;
    @Nullable
    private long version;
    @Nullable
    private Map<String, String> headers;
    private Map<String, ActionStatus> actions;

    private WatchStatus() {
    }

    public WatchStatus(DateTime now, Map<String, ActionStatus> actions) {
        this(-1L, new State(true, now), null, null, null, actions, Collections.emptyMap());
    }

    public WatchStatus(long version, State state, ExecutionState executionState, DateTime lastChecked, DateTime lastMetCondition, Map<String, ActionStatus> actions, Map<String, String> headers) {
        this.version = version;
        this.lastChecked = lastChecked;
        this.lastMetCondition = lastMetCondition;
        this.actions = actions;
        this.state = state;
        this.executionState = executionState;
        this.headers = headers;
    }

    public State state() {
        return this.state;
    }

    public boolean checked() {
        return this.lastChecked != null;
    }

    public DateTime lastChecked() {
        return this.lastChecked;
    }

    public ActionStatus actionStatus(String actionId) {
        return this.actions.get(actionId);
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchStatus that = (WatchStatus)o;
        return Objects.equals(this.lastChecked, that.lastChecked) && Objects.equals(this.lastMetCondition, that.lastMetCondition) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.executionState, (Object)that.executionState) && Objects.equals(this.actions, that.actions) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastChecked, this.lastMetCondition, this.actions, this.version, this.executionState, this.headers});
    }

    public void onCheck(boolean metCondition, DateTime timestamp) {
        this.lastChecked = timestamp;
        if (metCondition) {
            this.lastMetCondition = timestamp;
        } else {
            for (ActionStatus status : this.actions.values()) {
                status.resetAckStatus(timestamp);
            }
        }
    }

    public void onActionResult(String actionId, DateTime timestamp, Action.Result result) {
        ActionStatus status = this.actions.get(actionId);
        status.update(timestamp, result);
    }

    boolean onAck(DateTime timestamp, String ... actionIds) {
        boolean changed = false;
        boolean containsAll = false;
        for (String string : actionIds) {
            if (!string.equals("_all")) continue;
            containsAll = true;
            break;
        }
        if (containsAll) {
            for (ActionStatus status : this.actions.values()) {
                changed |= status.onAck(timestamp);
            }
            return changed;
        }
        for (String string : actionIds) {
            ActionStatus status = this.actions.get(string);
            if (status == null) continue;
            changed |= status.onAck(timestamp);
        }
        return changed;
    }

    boolean setActive(boolean active, DateTime now) {
        boolean change;
        boolean bl = change = this.state.active != active;
        if (change) {
            this.state = new State(active, now);
        }
        return change;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastChecked);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastMetCondition);
        out.writeInt(this.actions.size());
        for (Map.Entry<String, ActionStatus> entry : this.actions.entrySet()) {
            out.writeString(entry.getKey());
            ActionStatus.writeTo(entry.getValue(), out);
        }
        out.writeBoolean(this.state.active);
        WatcherDateTimeUtils.writeDate(out, this.state.timestamp);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.executionState != null);
            if (this.executionState != null) {
                out.writeString(this.executionState.id());
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            boolean statusHasHeaders = this.headers != null && !this.headers.isEmpty();
            out.writeBoolean(statusHasHeaders);
            if (statusHasHeaders) {
                out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
            }
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        boolean executionStateExists;
        this.version = in.readLong();
        this.lastChecked = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        this.lastMetCondition = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        int count = in.readInt();
        HashMap<String, ActionStatus> actions = new HashMap<String, ActionStatus>(count);
        for (int i = 0; i < count; ++i) {
            actions.put(in.readString(), ActionStatus.readFrom(in));
        }
        this.actions = Collections.unmodifiableMap(actions);
        this.state = new State(in.readBoolean(), WatcherDateTimeUtils.readDate(in, DateTimeZone.UTC));
        if (in.getVersion().onOrAfter(Version.V_6_1_0) && (executionStateExists = in.readBoolean())) {
            this.executionState = ExecutionState.resolve(in.readString());
        }
        this.headers = in.getVersion().onOrAfter(Version.V_6_1_0) && in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
    }

    public static WatchStatus read(StreamInput in) throws IOException {
        WatchStatus status = new WatchStatus();
        status.readFrom(in);
        return status;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(INCLUDE_STATE, true)) {
            builder.field(Field.STATE.getPreferredName(), (ToXContent)this.state, params);
        }
        if (this.lastChecked != null) {
            builder.timeField(Field.LAST_CHECKED.getPreferredName(), (Object)this.lastChecked);
        }
        if (this.lastMetCondition != null) {
            builder.timeField(Field.LAST_MET_CONDITION.getPreferredName(), (Object)this.lastMetCondition);
        }
        if (this.actions != null) {
            builder.startObject(Field.ACTIONS.getPreferredName());
            for (Map.Entry<String, ActionStatus> entry : this.actions.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue(), params);
            }
            builder.endObject();
        }
        if (this.executionState != null) {
            builder.field(Field.EXECUTION_STATE.getPreferredName(), this.executionState.id());
        }
        if (this.headers != null && !this.headers.isEmpty() && !WatcherParams.hideHeaders(params)) {
            builder.field(Field.HEADERS.getPreferredName(), this.headers);
        }
        builder.field(Field.VERSION.getPreferredName(), this.version);
        return builder.endObject();
    }

    public static WatchStatus parse(String watchId, XContentParser parser, Clock clock) throws IOException {
        XContentParser.Token token;
        State state = null;
        ExecutionState executionState = null;
        DateTime lastChecked = null;
        DateTime lastMetCondition = null;
        Map<String, ActionStatus> actions = null;
        long version = -1L;
        Map headers = Collections.emptyMap();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    state = State.parse(parser, clock);
                    continue;
                }
                catch (ElasticsearchParseException e) {
                    throw new ElasticsearchParseException("could not parse watch status for [{}]. failed to parse field [{}]", (Throwable)e, new Object[]{watchId, currentFieldName});
                }
            }
            if (Field.VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    version = parser.longValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a long value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.LAST_CHECKED.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    lastChecked = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.LAST_MET_CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    lastMetCondition = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.EXECUTION_STATE.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    executionState = ExecutionState.resolve(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a string value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.ACTIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                actions = new HashMap<String, ActionStatus>();
                if (token == XContentParser.Token.START_OBJECT) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        ActionStatus actionStatus = ActionStatus.parse(watchId, currentFieldName, parser);
                        actions.put(currentFieldName, actionStatus);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to be an object, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (Field.HEADERS.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token != XContentParser.Token.START_OBJECT) continue;
                headers = parser.mapStrings();
                continue;
            }
            parser.skipChildren();
        }
        if (state == null) {
            state = new State(true, new DateTime(WatcherXContentParser.clock(parser).millis(), DateTimeZone.UTC));
        }
        actions = actions == null ? Collections.emptyMap() : Collections.unmodifiableMap(actions);
        return new WatchStatus(version, state, executionState, lastChecked, lastMetCondition, actions, headers);
    }

    public static interface Field {
        public static final ParseField STATE = new ParseField("state", new String[0]);
        public static final ParseField ACTIVE = new ParseField("active", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField LAST_CHECKED = new ParseField("last_checked", new String[0]);
        public static final ParseField LAST_MET_CONDITION = new ParseField("last_met_condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField VERSION = new ParseField("version", new String[0]);
        public static final ParseField EXECUTION_STATE = new ParseField("execution_state", new String[0]);
        public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    }

    public static class State
    implements ToXContentObject {
        final boolean active;
        final DateTime timestamp;

        public State(boolean active, DateTime timestamp) {
            this.active = active;
            this.timestamp = timestamp;
        }

        public boolean isActive() {
            return this.active;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.ACTIVE.getPreferredName(), this.active);
            WatcherDateTimeUtils.writeDate(Field.TIMESTAMP.getPreferredName(), builder, this.timestamp);
            return builder.endObject();
        }

        public static State parse(XContentParser parser, Clock clock) throws IOException {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("expected an object but found [{}] instead", new Object[]{parser.currentToken()});
            }
            boolean active = true;
            DateTime timestamp = new DateTime(clock.millis(), DateTimeZone.UTC);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.ACTIVE.match(currentFieldName, parser.getDeprecationHandler())) {
                    active = parser.booleanValue();
                    continue;
                }
                if (Field.TIMESTAMP.match(currentFieldName, parser.getDeprecationHandler())) {
                    timestamp = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                parser.skipChildren();
            }
            return new State(active, timestamp);
        }
    }
}

