/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BigRangeIterator;
import net.sf.saxon.expr.DescendingRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.RangeIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

public class AscendingRangeIterator
extends RangeIterator
implements AtomicIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    long start;
    long step;
    long currentValue;
    long limit;

    public static AtomicIterator makeRangeIterator(IntegerValue start, IntegerValue step, IntegerValue end) throws XPathException {
        if (start == null || step == null || end == null) {
            return EmptyIterator.ofAtomic();
        }
        int direction = step.compareTo(Int64Value.ZERO);
        if (direction == 0 || start.compareTo(end) > 0) {
            return EmptyIterator.ofAtomic();
        }
        if (start instanceof BigIntegerValue || step instanceof BigIntegerValue || end instanceof BigIntegerValue) {
            if (direction < 0) {
                return new BigRangeIterator(end.asBigInteger(), step.asBigInteger(), start.asBigInteger());
            }
            return new BigRangeIterator(start.asBigInteger(), step.asBigInteger(), end.asBigInteger());
        }
        long startVal = start.longValue();
        long stepVal = step.longValue();
        long endVal = end.longValue();
        if ((endVal - startVal) / stepVal > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        if (stepVal > 0L) {
            return new AscendingRangeIterator(startVal, stepVal, endVal);
        }
        return new DescendingRangeIterator(endVal, -stepVal, startVal);
    }

    public static AtomicIterator makeLongRangeIterator(long start, long step, long end) throws XPathException {
        int direction = Long.compare(step, 0L);
        if (direction == 0 || direction > 0 && start > end || direction < 0 && start < end) {
            return EmptyIterator.ofAtomic();
        }
        if ((end - start) / step > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        if (step > 0L) {
            return new AscendingRangeIterator(start, step, end);
        }
        return new DescendingRangeIterator(start, -step, end);
    }

    public AscendingRangeIterator(long start, long step, long end) {
        this.start = start;
        this.step = step;
        this.currentValue = start - step;
        this.limit = end;
        if (step != 1L) {
            this.limit = start + (end - start) / step * step;
        }
    }

    @Override
    public IntegerValue getFirst() {
        return new Int64Value(this.start);
    }

    @Override
    public IntegerValue getLast() {
        return new Int64Value(this.limit);
    }

    @Override
    public IntegerValue getMin() {
        return new Int64Value(this.start);
    }

    @Override
    public IntegerValue getMax() {
        return new Int64Value(this.limit);
    }

    @Override
    public IntegerValue getStep() {
        return new Int64Value(this.step);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue + this.step <= this.limit;
    }

    @Override
    public IntegerValue next() {
        this.currentValue += this.step;
        if (this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return (int)(this.limit - this.start + 1L);
    }

    @Override
    public AtomicIterator getReverseIterator() {
        return new DescendingRangeIterator(this.limit, this.step, this.start);
    }

    @Override
    public GroundedValue materialize() {
        return new IntegerRange(this.start, this.step, this.limit);
    }

    @Override
    public GroundedValue getResidue() {
        return new IntegerRange(this.currentValue, this.step, this.limit);
    }
}

