/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tex;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;

public class TexWriter {
    private final boolean m_usePass;
    private final PrintStream m_out;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TexWriter(String string, OutputStream outputStream, Board board, boolean bl, String[][] stringArray, boolean[][] blArray, boolean[][] blArray2) {
        this.m_out = new PrintStream(outputStream);
        this.m_usePass = bl;
        this.printBeginDocument();
        if (string != null && !string.trim().equals("")) {
            this.m_out.println("\\section*{" + this.escape(string) + "}");
        }
        this.printBeginPSGo(board.getSize());
        this.printPosition(board, stringArray, blArray, blArray2);
        this.printEndPSGo();
        this.m_out.println("\\\\");
        String string2 = board.getToMove() == GoColor.BLACK ? "Black" : "White";
        this.m_out.println(string2 + " to play");
        this.printEndDocument();
        this.m_out.close();
    }

    public TexWriter(String string, OutputStream outputStream, GameTree gameTree, boolean bl) {
        this.m_out = new PrintStream(outputStream);
        this.m_usePass = bl;
        this.printBeginDocument();
        if (string != null && !string.trim().equals("")) {
            this.m_out.println("\\section*{" + this.escape(string) + "}");
        }
        this.printBeginPSGo(gameTree.getGameInformation().m_boardSize);
        String string2 = this.printTree(gameTree);
        this.printEndPSGo();
        if (!string2.equals("")) {
            this.m_out.println("\\\\");
            this.m_out.println(string2);
        }
        this.printEndDocument();
        this.m_out.close();
    }

    private String escape(String string) {
        string = string.replaceAll("\\#", "\\\\#");
        string = string.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("%", "\\\\%");
        string = string.replaceAll("\\&", "\\\\&");
        string = string.replaceAll("~", "\\\\~{}");
        string = string.replaceAll("_", "\\\\_");
        string = string.replaceAll("\\^", "\\\\^{}");
        string = string.replaceAll("\\\\", "\\$\\\\backslash\\$");
        string = string.replaceAll("\\{", "\\\\{");
        string = string.replaceAll("\\}", "\\\\}");
        return string;
    }

    private String getMarkers(String string, boolean bl, boolean bl2) {
        if (!(string != null && !string.equals("") || bl || bl2)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && !string.equals("")) {
            stringBuffer.append("\\marklb{" + string + "}");
        }
        if (bl) {
            stringBuffer.append("\\marksq");
        }
        if (bl2) {
            stringBuffer.append("\\markdd");
        }
        return stringBuffer.toString();
    }

    private String getStoneInTextString(int n, GoColor goColor) {
        return "\\stone[" + n + "]{" + (goColor == GoColor.BLACK ? "black" : "white") + "}";
    }

    private void printBeginDocument() {
        String string = "0.12";
        if (this.m_usePass) {
            string = "0.14";
        }
        this.m_out.println("\\documentclass{article}");
        this.m_out.println("\\usepackage{psgo} % version " + string + " or newer");
        this.m_out.println("\\pagestyle{empty}");
        this.m_out.println("\\begin{document}");
        this.m_out.println();
    }

    private void printBeginPSGo(int n) {
        this.m_out.println("\\begin{psgoboard}[" + n + "]");
    }

    private void printColor(GoColor goColor) {
        if (goColor == GoColor.BLACK) {
            this.m_out.print("{black}");
        } else {
            if (!$assertionsDisabled && goColor != GoColor.WHITE) {
                throw new AssertionError();
            }
            this.m_out.print("{white}");
        }
    }

    private void printCoordinates(GoPoint goPoint) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        String string = goPoint.toString();
        this.m_out.print("{" + string.substring(0, 1).toLowerCase() + "}{" + string.substring(1) + "}");
    }

    private void printEndDocument() {
        this.m_out.println();
        this.m_out.println("\\end{document}");
    }

    private void printEndPSGo() {
        this.m_out.println("\\end{psgoboard}");
    }

    private String printTree(GameTree gameTree) {
        int n;
        int n2;
        Object object;
        Object object2;
        GameInformation gameInformation = gameTree.getGameInformation();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = gameInformation.m_boardSize;
        Node[][] nodeArray = new Node[n3][n3];
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = true;
        this.m_out.println("\\setcounter{gomove}{0}");
        Node node = gameTree.getRoot();
        while (node != null) {
            int n4;
            for (n4 = 0; n4 < node.getNumberAddBlack(); ++n4) {
                this.printStone(GoColor.BLACK, node.getAddBlack(n4), null, false, false);
            }
            for (n4 = 0; n4 < node.getNumberAddWhite(); ++n4) {
                this.printStone(GoColor.WHITE, node.getAddWhite(n4), null, false, false);
            }
            Move move = node.getMove();
            if (move == null) {
                node = node.getChild();
                continue;
            }
            object2 = move.getPoint();
            object = move.getColor();
            int n5 = NodeUtils.getMoveNumber(node);
            n2 = bl && object != GoColor.BLACK || !bl && object != GoColor.WHITE ? 1 : 0;
            int n6 = n = object2 == null ? 1 : 0;
            if (n != 0 || nodeArray[((GoPoint)object2).getX()][((GoPoint)object2).getY()] != null) {
                arrayList.add(node);
                if (this.m_usePass) {
                    this.m_out.print("\\pass");
                } else {
                    this.m_out.print("\\refstepcounter{gomove} \\toggleblackmove");
                }
                if (n != 0) {
                    if (!this.m_usePass) {
                        this.m_out.print(" % \\pass");
                    }
                } else {
                    this.m_out.print(" % \\move");
                    this.printCoordinates((GoPoint)object2);
                }
                this.m_out.println(" % " + (bl ? "B " : "W ") + n5);
            } else {
                if (n2 != 0) {
                    this.m_out.println("\\toggleblackmove");
                    bl = !bl;
                }
                this.m_out.print("\\move");
                this.printCoordinates((GoPoint)object2);
                this.m_out.println(" % " + (bl ? "B " : "W ") + n5);
                nodeArray[((GoPoint)object2).getX()][((GoPoint)object2).getY()] = node;
            }
            bl = !bl;
            node = node.getChild();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            node = (Node)arrayList.get(i);
            object2 = node.getMove();
            object = ((Move)object2).getPoint();
            GoColor goColor = ((Move)object2).getColor();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" \\enspace\n");
            }
            stringBuffer.append(this.getStoneInTextString(i + 1, goColor));
            if (object == null) {
                stringBuffer.append("~pass");
                continue;
            }
            n2 = ((GoPoint)object).getX();
            n = ((GoPoint)object).getY();
            stringBuffer.append("~at~");
            Node node2 = nodeArray[n2][n];
            GoColor goColor2 = node2.getMove().getColor();
            int n7 = NodeUtils.getMoveNumber(node2);
            stringBuffer.append(this.getStoneInTextString(n7, goColor2));
        }
        return stringBuffer.toString();
    }

    private void printPosition(Board board, String[][] stringArray, boolean[][] blArray, boolean[][] blArray2) {
        int n = board.getNumberPoints();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            GoPoint goPoint = board.getPoint(i);
            GoColor goColor = board.getColor(goPoint);
            int n2 = goPoint.getX();
            int n3 = goPoint.getY();
            String string = null;
            if (stringArray != null) {
                string = stringArray[n2][n3];
            }
            boolean bl2 = blArray != null && blArray[n2][n3];
            boolean bl3 = bl = blArray2 != null && blArray2[n2][n3];
            if (goColor == GoColor.EMPTY) {
                String string2 = this.getMarkers(string, bl2, bl);
                if (string2 == null) continue;
                this.m_out.print("\\markpos{" + string2 + "}");
                this.printCoordinates(goPoint);
                this.m_out.print("\n");
                continue;
            }
            this.printStone(goColor, goPoint, string, bl2, bl);
        }
    }

    private void printStone(GoColor goColor, GoPoint goPoint, String string, boolean bl, boolean bl2) {
        this.m_out.print("\\stone");
        String string2 = this.getMarkers(string, bl, bl2);
        if (string2 != null) {
            this.m_out.print("[" + string2 + "]");
        }
        this.printColor(goColor);
        this.printCoordinates(goPoint);
        this.m_out.print("\n");
    }

    static {
        $assertionsDisabled = !TexWriter.class.desiredAssertionStatus();
    }
}

