/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.AbstractVisualStudioVersionLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadataBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.gradle.util.internal.VersionNumber;

public class WindowsRegistryVersionLocator
extends AbstractVisualStudioVersionLocator
implements VisualStudioVersionLocator {
    static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    static final String REGISTRY_ROOTPATH_VC = "Microsoft\\VisualStudio\\SxS\\VC7";
    private final WindowsRegistry windowsRegistry;

    public WindowsRegistryVersionLocator(WindowsRegistry windowsRegistry) {
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    protected List<VisualStudioInstallCandidate> locateInstalls() {
        ArrayList<VisualStudioInstallCandidate> installs = new ArrayList<VisualStudioInstallCandidate>();
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateInstallsInRegistry(installs, baseKey);
        }
        return installs;
    }

    @Override
    public String getSource() {
        return "windows registry";
    }

    private void locateInstallsInRegistry(List<VisualStudioInstallCandidate> installs, String baseKey) {
        List visualCppVersions;
        try {
            visualCppVersions = this.windowsRegistry.getValueNames(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC);
        }
        catch (MissingRegistryEntryException e) {
            return;
        }
        for (String versionString : visualCppVersions) {
            if (!versionString.matches("\\d+\\.\\d+")) continue;
            File visualCppDir = new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_VC, versionString));
            visualCppDir = FileUtils.canonicalize((File)visualCppDir);
            File visualStudioDir = visualCppDir.getParentFile();
            VersionNumber version = VersionNumber.parse((String)versionString);
            installs.add(new VisualStudioMetadataBuilder().installDir(visualStudioDir).visualCppDir(visualCppDir).version(version).visualCppVersion(version).build());
        }
    }
}

