/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.HasScrollHandlers;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractNativeScrollbar
extends Widget
implements HasScrollHandlers {
    private static int nativeHeight = -1;
    private static int nativeWidth = -1;
    private static boolean nativeRtl = false;

    public static int getNativeScrollbarHeight() {
        AbstractNativeScrollbar.maybeRecalculateNativeScrollbarSize();
        return nativeHeight;
    }

    public static int getNativeScrollbarWidth() {
        AbstractNativeScrollbar.maybeRecalculateNativeScrollbarSize();
        return nativeWidth;
    }

    public static boolean isScrollbarLeftAlignedInRtl() {
        AbstractNativeScrollbar.maybeRecalculateNativeScrollbarSize();
        return nativeRtl;
    }

    private static void maybeRecalculateNativeScrollbarSize() {
        if (nativeHeight > -1) {
            return;
        }
        DivElement scrollable = Document.get().createDivElement();
        scrollable.getStyle().setPosition(Style.Position.ABSOLUTE);
        scrollable.getStyle().setTop(-1000.0, Style.Unit.PX);
        scrollable.getStyle().setLeft(-1000.0, Style.Unit.PX);
        scrollable.getStyle().setHeight(100.0, Style.Unit.PX);
        scrollable.getStyle().setWidth(100.0, Style.Unit.PX);
        scrollable.getStyle().setOverflow(Style.Overflow.SCROLL);
        scrollable.getStyle().setProperty("direction", "rtl");
        Document.get().getBody().appendChild(scrollable);
        DivElement content = Document.get().createDivElement();
        content.setInnerText("content");
        scrollable.appendChild(content);
        nativeHeight = scrollable.getOffsetHeight() - scrollable.getClientHeight();
        nativeWidth = scrollable.getOffsetWidth() - scrollable.getClientWidth();
        nativeRtl = content.getAbsoluteLeft() > scrollable.getAbsoluteLeft();
        scrollable.removeFromParent();
    }

    @Override
    public HandlerRegistration addScrollHandler(ScrollHandler handler) {
        Event.sinkEvents(this.getScrollableElement(), 16384);
        return this.addHandler(handler, ScrollEvent.getType());
    }

    protected abstract Element getScrollableElement();

    @Override
    protected void onAttach() {
        super.onAttach();
        Event.setEventListener(this.getScrollableElement(), this);
    }

    @Override
    protected void onDetach() {
        Event.setEventListener(this.getScrollableElement(), null);
        super.onDetach();
    }
}

