/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 22:16:49 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9791 $
//  type=se

/**
 * Localized names for the "se" locale.
 */
public class LocalizedNamesImpl_se extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "US",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "VI",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "VG",
        "BN",
        "BG",
        "BF",
        "MM",
        "BI",
        "KY",
        "CZ",
        "EA",
        "CL",
        "CP",
        "CC",
        "CK",
        "CR",
        "CW",
        "DK",
        "KP",
        "MP",
        "SD",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DE",
        "TR",
        "EC",
        "EG",
        "GQ",
        "CI",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "PH",
        "FR",
        "GF",
        "PF",
        "MF",
        "GA",
        "GM",
        "CF",
        "GE",
        "GH",
        "GI",
        "GR",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "IN",
        "ID",
        "IO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "CX",
        "GL",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "GS",
        "LU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "ZA",
        "KR",
        "SS",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "NO",
        "AT",
        "TL",
        "EH",
        "OM",
        "AE",
        "NC",
        "NZ",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "RE",
        "RO",
        "RU",
        "SE",
        "RW",
        "BL",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SB",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "GB",
        "FI",
        "SR",
        "SJ",
        "SZ",
        "CH",
        "SY",
        "TW",
        "TZ",
        "TJ",
        "TD",
        "TF",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "UM",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "BY",
        "NL",
        "SX",
        "WF",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "máilbmi");
    namesMap.put("002", "Afrihkká");
    namesMap.put("003", "dávvi-Amerihkká ja gaska-Amerihkká");
    namesMap.put("005", "mátta-Amerihkká");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "oarji-Afrihkká");
    namesMap.put("013", "gaska-Amerihkká");
    namesMap.put("014", "nuorta-Afrihkká");
    namesMap.put("015", "davvi-Afrihkká");
    namesMap.put("017", "gaska-Afrihkká");
    namesMap.put("018", "mátta-Afrihkká");
    namesMap.put("019", "Amerihkká");
    namesMap.put("021", "dávvi-Amerihkká");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "nuorta-Ásia");
    namesMap.put("034", "mátta-Ásia");
    namesMap.put("035", "mátta-nuorta-Ásia");
    namesMap.put("039", "mátta-Eurohpá");
    namesMap.put("053", "Austrália ja Ođđa-Selánda");
    namesMap.put("057", "Mikronesia guovllus");
    namesMap.put("142", "Ásia");
    namesMap.put("143", "gaska-Ásia");
    namesMap.put("145", "oarji-Ásia");
    namesMap.put("150", "Eurohpá");
    namesMap.put("151", "nuorta-Eurohpá");
    namesMap.put("154", "davvi-Eurohpá");
    namesMap.put("155", "oarji-Eurohpá");
    namesMap.put("419", "lulli-Amerihkká");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Ovttastuvvan Arábaemiráhtat");
    namesMap.put("AG", "Antigua ja Barbuda");
    namesMap.put("AL", "Albánia");
    namesMap.put("AQ", "Antárktis");
    namesMap.put("AS", "Amerihká Samoa");
    namesMap.put("AT", "Nuortariika");
    namesMap.put("AU", "Austrália");
    namesMap.put("AX", "Ålánda");
    namesMap.put("AZ", "Aserbaižan");
    namesMap.put("BA", "Bosnia-Hercegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BG", "Bulgária");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Bouvet-sullot");
    namesMap.put("BY", "Vilges-Ruošša");
    namesMap.put("CA", "Kanáda");
    namesMap.put("CC", "Cocos-sullot");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Gaska-Afrihká dásseváldi");
    namesMap.put("CG", "Kongo-Brazzaville");
    namesMap.put("CH", "Šveica");
    namesMap.put("CI", "Elfenbenariddu");
    namesMap.put("CK", "Cook-sullot");
    namesMap.put("CL", "Čiile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kiinná");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Clipperton-sullot");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Juovllat-sullot");
    namesMap.put("CY", "Kypros");
    namesMap.put("CZ", "Čeahkka");
    namesMap.put("DE", "Duiska");
    namesMap.put("DK", "Dánmárku");
    namesMap.put("DO", "Dominikána dásseváldi");
    namesMap.put("EA", "Ceuta ja Melilla");
    namesMap.put("EE", "Estlánda");
    namesMap.put("EG", "Egypta");
    namesMap.put("EH", "Oarje-Sahára");
    namesMap.put("ES", "Spánia");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Eurohpa Uniovdna");
    namesMap.put("FI", "Suopma");
    namesMap.put("FJ", "Fijisullot");
    namesMap.put("FK", "Falklandsullot");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Fearsullot");
    namesMap.put("FR", "Frankriika");
    namesMap.put("GB", "Stuorra-Británnia");
    namesMap.put("GF", "Frankriikka Guayana");
    namesMap.put("GL", "Kalaallit Nunaat");
    namesMap.put("GM", "Gámbia");
    namesMap.put("GQ", "Ekvatoriála Guinea");
    namesMap.put("GR", "Greika");
    namesMap.put("GS", "Lulli Georgia ja Lulli Sandwich-sullot");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard- ja McDonald-sullot");
    namesMap.put("HR", "Kroátia");
    namesMap.put("HU", "Ungár");
    namesMap.put("IC", "Kanáriasullot");
    namesMap.put("IE", "Irlánda");
    namesMap.put("IM", "Mann-sullot");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islánda");
    namesMap.put("IT", "Itália");
    namesMap.put("JO", "Jordánia");
    namesMap.put("JP", "Japána");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komoros");
    namesMap.put("KN", "Saint Kitts ja Nevis");
    namesMap.put("KP", "Davvi-Korea");
    namesMap.put("KR", "Mátta-Korea");
    namesMap.put("KY", "Cayman-sullot");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LT", "Lietuva");
    namesMap.put("LV", "Látvia");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Moldávia");
    namesMap.put("MF", "Frankriikka Saint Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshallsullot");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Burma");
    namesMap.put("MO", "Makáo");
    namesMap.put("MP", "Davvi-Mariánat");
    namesMap.put("MR", "Mauretánia");
    namesMap.put("MT", "Málta");
    namesMap.put("MV", "Malediivvat");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Ođđa-Kaledonia");
    namesMap.put("NF", "Norfolksullot");
    namesMap.put("NL", "Vuolleeatnamat");
    namesMap.put("NO", "Norga");
    namesMap.put("NZ", "Ođđa-Selánda");
    namesMap.put("PF", "Frankriikka Polynesia");
    namesMap.put("PG", "Papua-Ođđa-Guinea");
    namesMap.put("PH", "Filippiinnat");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "Saint Pierre ja Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestina");
    namesMap.put("PT", "Portugála");
    namesMap.put("RO", "Románia");
    namesMap.put("RU", "Ruošša");
    namesMap.put("SA", "Saudi-Arábia");
    namesMap.put("SB", "Salomon-sullot");
    namesMap.put("SC", "Seychellsullot");
    namesMap.put("SD", "Davvisudan");
    namesMap.put("SE", "Ruoŧŧa");
    namesMap.put("SJ", "Svalbárda ja Jan Mayen");
    namesMap.put("SK", "Slovákia");
    namesMap.put("SO", "Somália");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Máttasudan");
    namesMap.put("ST", "São Tomé ja Príncipe");
    namesMap.put("SX", "Vuolleeatnamat Saint Martin");
    namesMap.put("SZ", "Svazieana");
    namesMap.put("TC", "Turks ja Caicos-sullot");
    namesMap.put("TD", "Tčad");
    namesMap.put("TH", "Thaieana");
    namesMap.put("TJ", "Tažikistan");
    namesMap.put("TL", "Nuorta-Timor");
    namesMap.put("TR", "Durka");
    namesMap.put("TT", "Trinidad ja Tobago");
    namesMap.put("TZ", "Tanzánia");
    namesMap.put("UA", "Ukraina");
    namesMap.put("US", "Amerihká ovttastuvvan stáhtat");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikána");
    namesMap.put("VC", "Saint Vincent ja Grenadine");
    namesMap.put("VG", "Brittania Virgin-sullot");
    namesMap.put("VI", "AOS Virgin-sullot");
    namesMap.put("WF", "Wallis ja Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Mátta-Afrihká");
    namesMap.put("ZZ", "dovdameahttun guovlu");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "máilbmi",
        "002": "Afrihkká",
        "003": "dávvi-Amerihkká ja gaska-Amerihkká",
        "005": "mátta-Amerihkká",
        "009": "Oseania",
        "011": "oarji-Afrihkká",
        "013": "gaska-Amerihkká",
        "014": "nuorta-Afrihkká",
        "015": "davvi-Afrihkká",
        "017": "gaska-Afrihkká",
        "018": "mátta-Afrihkká",
        "019": "Amerihkká",
        "021": "dávvi-Amerihkká",
        "029": "Karibia",
        "030": "nuorta-Ásia",
        "034": "mátta-Ásia",
        "035": "mátta-nuorta-Ásia",
        "039": "mátta-Eurohpá",
        "053": "Austrália ja Ođđa-Selánda",
        "057": "Mikronesia guovllus",
        "142": "Ásia",
        "143": "gaska-Ásia",
        "145": "oarji-Ásia",
        "150": "Eurohpá",
        "151": "nuorta-Eurohpá",
        "154": "davvi-Eurohpá",
        "155": "oarji-Eurohpá",
        "419": "lulli-Amerihkká",
        "AC": "Ascension",
        "AE": "Ovttastuvvan Arábaemiráhtat",
        "AG": "Antigua ja Barbuda",
        "AL": "Albánia",
        "AQ": "Antárktis",
        "AS": "Amerihká Samoa",
        "AT": "Nuortariika",
        "AU": "Austrália",
        "AX": "Ålánda",
        "AZ": "Aserbaižan",
        "BA": "Bosnia-Hercegovina",
        "BE": "Belgia",
        "BG": "Bulgária",
        "BR": "Brasil",
        "BV": "Bouvet-sullot",
        "BY": "Vilges-Ruošša",
        "CA": "Kanáda",
        "CC": "Cocos-sullot",
        "CD": "Kongo-Kinshasa",
        "CF": "Gaska-Afrihká dásseváldi",
        "CG": "Kongo-Brazzaville",
        "CH": "Šveica",
        "CI": "Elfenbenariddu",
        "CK": "Cook-sullot",
        "CL": "Čiile",
        "CM": "Kamerun",
        "CN": "Kiinná",
        "CO": "Kolombia",
        "CP": "Clipperton-sullot",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Juovllat-sullot",
        "CY": "Kypros",
        "CZ": "Čeahkka",
        "DE": "Duiska",
        "DK": "Dánmárku",
        "DO": "Dominikána dásseváldi",
        "EA": "Ceuta ja Melilla",
        "EE": "Estlánda",
        "EG": "Egypta",
        "EH": "Oarje-Sahára",
        "ES": "Spánia",
        "ET": "Etiopia",
        "EU": "Eurohpa Uniovdna",
        "FI": "Suopma",
        "FJ": "Fijisullot",
        "FK": "Falklandsullot",
        "FM": "Mikronesia",
        "FO": "Fearsullot",
        "FR": "Frankriika",
        "GB": "Stuorra-Británnia",
        "GF": "Frankriikka Guayana",
        "GL": "Kalaallit Nunaat",
        "GM": "Gámbia",
        "GQ": "Ekvatoriála Guinea",
        "GR": "Greika",
        "GS": "Lulli Georgia ja Lulli Sandwich-sullot",
        "HK": "Hongkong",
        "HM": "Heard- ja McDonald-sullot",
        "HR": "Kroátia",
        "HU": "Ungár",
        "IC": "Kanáriasullot",
        "IE": "Irlánda",
        "IM": "Mann-sullot",
        "IQ": "Irak",
        "IS": "Islánda",
        "IT": "Itália",
        "JO": "Jordánia",
        "JP": "Japána",
        "KE": "Kenia",
        "KG": "Kirgisistan",
        "KH": "Kambodža",
        "KM": "Komoros",
        "KN": "Saint Kitts ja Nevis",
        "KP": "Davvi-Korea",
        "KR": "Mátta-Korea",
        "KY": "Cayman-sullot",
        "KZ": "Kasakstan",
        "LB": "Libanon",
        "LT": "Lietuva",
        "LV": "Látvia",
        "MA": "Marokko",
        "MD": "Moldávia",
        "MF": "Frankriikka Saint Martin",
        "MG": "Madagaskar",
        "MH": "Marshallsullot",
        "MK": "Makedonia",
        "MM": "Burma",
        "MO": "Makáo",
        "MP": "Davvi-Mariánat",
        "MR": "Mauretánia",
        "MT": "Málta",
        "MV": "Malediivvat",
        "MX": "Meksiko",
        "MY": "Malesia",
        "MZ": "Mosambik",
        "NC": "Ođđa-Kaledonia",
        "NF": "Norfolksullot",
        "NL": "Vuolleeatnamat",
        "NO": "Norga",
        "NZ": "Ođđa-Selánda",
        "PF": "Frankriikka Polynesia",
        "PG": "Papua-Ođđa-Guinea",
        "PH": "Filippiinnat",
        "PL": "Polen",
        "PM": "Saint Pierre ja Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestina",
        "PT": "Portugála",
        "RO": "Románia",
        "RU": "Ruošša",
        "SA": "Saudi-Arábia",
        "SB": "Salomon-sullot",
        "SC": "Seychellsullot",
        "SD": "Davvisudan",
        "SE": "Ruoŧŧa",
        "SJ": "Svalbárda ja Jan Mayen",
        "SK": "Slovákia",
        "SO": "Somália",
        "SR": "Surinam",
        "SS": "Máttasudan",
        "ST": "São Tomé ja Príncipe",
        "SX": "Vuolleeatnamat Saint Martin",
        "SZ": "Svazieana",
        "TC": "Turks ja Caicos-sullot",
        "TD": "Tčad",
        "TH": "Thaieana",
        "TJ": "Tažikistan",
        "TL": "Nuorta-Timor",
        "TR": "Durka",
        "TT": "Trinidad ja Tobago",
        "TZ": "Tanzánia",
        "UA": "Ukraina",
        "US": "Amerihká ovttastuvvan stáhtat",
        "UZ": "Usbekistan",
        "VA": "Vatikána",
        "VC": "Saint Vincent ja Grenadine",
        "VG": "Brittania Virgin-sullot",
        "VI": "AOS Virgin-sullot",
        "WF": "Wallis ja Futuna",
        "YE": "Jemen",
        "ZA": "Mátta-Afrihká",
        "ZZ": "dovdameahttun guovlu"
    };
  }-*/;
}
