/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        super(address, secure);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        String scheme = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin(scheme, this.getAddress()).asString());
    }

    public static class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private static final Logger LOG = Log.getLogger(HttpProxyClientConnectionFactory.class);
        private final ClientConnectionFactory connectionFactory;

        public HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            Promise promise = (Promise)context.get("http.connection.promise");
            ProxyPromise proxyPromise = new ProxyPromise(endPoint, promise, context);
            context.put("http.connection.promise", proxyPromise);
            return this.connectionFactory.newConnection(endPoint, context);
        }

        private class ProxyPromise
        implements Promise<Connection> {
            private final EndPoint endPoint;
            private final Promise<Connection> promise;
            private final Map<String, Object> context;

            private ProxyPromise(EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
                this.endPoint = endPoint;
                this.promise = promise;
                this.context = context;
            }

            public void succeeded(Connection connection) {
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                if (HttpScheme.HTTPS.is(destination.getScheme())) {
                    SslContextFactory sslContextFactory = destination.getHttpClient().getSslContextFactory();
                    if (sslContextFactory != null) {
                        this.tunnel(destination, connection);
                    } else {
                        String message = String.format("Cannot perform requests over SSL, no %s in %s", SslContextFactory.class.getSimpleName(), HttpClient.class.getSimpleName());
                        this.promise.failed((Throwable)new IllegalStateException(message));
                    }
                } else {
                    this.promise.succeeded((Object)connection);
                }
            }

            public void failed(Throwable x) {
                this.promise.failed(x);
            }

            private void tunnel(HttpDestination destination, Connection connection) {
                String target = destination.getOrigin().getAddress().asString();
                Origin.Address proxyAddress = destination.getConnectAddress();
                HttpClient httpClient = destination.getHttpClient();
                Request connect = httpClient.newRequest(proxyAddress.getHost(), proxyAddress.getPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).timeout(httpClient.getConnectTimeout(), TimeUnit.MILLISECONDS);
                connection.send(connect, new Response.CompleteListener(){

                    @Override
                    public void onComplete(Result result) {
                        if (result.isFailed()) {
                            ProxyPromise.this.tunnelFailed(result.getFailure());
                        } else {
                            Response response = result.getResponse();
                            if (response.getStatus() == 200) {
                                ProxyPromise.this.tunnelSucceeded();
                            } else {
                                ProxyPromise.this.tunnelFailed(new HttpResponseException("Received " + response + " for " + result.getRequest(), response));
                            }
                        }
                    }
                });
            }

            private void tunnelSucceeded() {
                try {
                    this.context.put("http.connection.promise", this.promise);
                    HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                    HttpClient client = destination.getHttpClient();
                    SslClientConnectionFactory sslConnectionFactory = new SslClientConnectionFactory(client.getSslContextFactory(), client.getByteBufferPool(), client.getExecutor(), HttpProxyClientConnectionFactory.this.connectionFactory);
                    HttpConnectionOverHTTP oldConnection = (HttpConnectionOverHTTP)this.endPoint.getConnection();
                    org.eclipse.jetty.io.Connection newConnection = sslConnectionFactory.newConnection(this.endPoint, this.context);
                    ClientConnectionFactory.Helper.replaceConnection((org.eclipse.jetty.io.Connection)oldConnection, (org.eclipse.jetty.io.Connection)newConnection);
                    oldConnection.softClose();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP tunnel established: {} over {}", new Object[]{oldConnection, newConnection});
                    }
                }
                catch (Throwable x) {
                    this.tunnelFailed(x);
                }
            }

            private void tunnelFailed(Throwable failure) {
                this.endPoint.close();
                this.failed(failure);
            }
        }
    }
}

