/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jwt;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.time.Clock;
import java.time.Duration;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jwt.JwtInfo;
import org.jitsi.jwt.RefreshingProperty;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/jwt/RefreshingJwt;", "Lorg/jitsi/jwt/RefreshingProperty;", "", "jwtInfo", "Lorg/jitsi/jwt/JwtInfo;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/jwt/JwtInfo;Ljava/time/Clock;)V", "jicoco-jwt"})
public final class RefreshingJwt
extends RefreshingProperty<String> {
    @Nullable
    private final JwtInfo jwtInfo;
    @NotNull
    private final Clock clock;

    public RefreshingJwt(final @Nullable JwtInfo jwtInfo, final @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Object object = jwtInfo;
        if (object == null || (object = ((JwtInfo)object).getTtl()) == null || (object = ((Duration)object).minus(Duration.ofMinutes(5L))) == null) {
            object = Duration.ofSeconds(Long.MAX_VALUE);
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        super((Duration)object2, clock, (Function0)new Function0<String>(){

            @Nullable
            public final String invoke() {
                String string;
                JwtInfo jwtInfo3 = jwtInfo;
                if (jwtInfo3 != null) {
                    JwtBuilder jwtBuilder;
                    JwtInfo jwtInfo2 = jwtInfo3;
                    Clock clock2 = clock;
                    JwtInfo it = jwtInfo2;
                    boolean bl = false;
                    JwtBuilder $this$invoke_u24lambda_u241_u24lambda_u240 = jwtBuilder = Jwts.builder();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241_u24lambda_u240.header().add((Object)"kid", (Object)it.getKid());
                    $this$invoke_u24lambda_u241_u24lambda_u240.issuer(it.getIssuer());
                    $this$invoke_u24lambda_u241_u24lambda_u240.audience().add((Object)it.getAudience());
                    $this$invoke_u24lambda_u241_u24lambda_u240.expiration(Date.from(clock2.instant().plus(it.getTtl())));
                    $this$invoke_u24lambda_u241_u24lambda_u240.signWith((Key)it.getPrivateKey(), (SecureDigestAlgorithm)Jwts.SIG.RS256);
                    string = jwtBuilder.compact();
                } else {
                    string = null;
                }
                return string;
            }
        });
        this.jwtInfo = jwtInfo;
        this.clock = clock;
    }

    public /* synthetic */ RefreshingJwt(JwtInfo jwtInfo, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(jwtInfo, clock);
    }
}

