/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;
import net.sourceforge.mlf.metouia.util.FastGradientPaintContext;

public class MetouiaGradients
implements Paint {
    private static final Color reflection = MetouiaLookAndFeel.getGradientReflection();
    private static final Color reflectionFaded = MetouiaLookAndFeel.getGradientTranslucentReflection();
    private static final Color shadow = MetouiaLookAndFeel.getGradientShadow();
    private static final Color shadowFaded = MetouiaLookAndFeel.getGradientTranslucentShadow();
    private int startColor;
    private int endColor;
    private boolean isVertical;
    private boolean isAscending;

    public synchronized PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new FastGradientPaintContext(colorModel, rectangle, this.startColor, this.endColor, this.isVertical, this.isAscending);
    }

    public int getTransparency() {
        return ((this.startColor & this.endColor) >> 24 & 0xFF) == 255 ? 1 : 3;
    }

    public static final void drawGradient(Graphics graphics, Color color, Color color2, Rectangle rectangle, boolean bl, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        MetouiaGradients metouiaGradients = new MetouiaGradients(color, color2, bl, bl2);
        graphics2D.setPaint(metouiaGradients);
        graphics2D.fill(rectangle);
    }

    public static final void drawHighlight(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new MetouiaGradients(reflection, reflectionFaded, bl, bl2));
        graphics2D.fill(rectangle);
    }

    public static final void drawShadow(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new MetouiaGradients(shadowFaded, shadow, bl, bl2));
        graphics2D.fill(rectangle);
    }

    public static final void drawHorizontalHighlight(Graphics graphics, Component component) {
        MetouiaGradients.drawHighlight(graphics, new Rectangle(0, 0, component.getWidth(), component.getHeight() / 2), true, true);
    }

    public static final void drawHorizontalShadow(Graphics graphics, Component component) {
        MetouiaGradients.drawShadow(graphics, new Rectangle(0, component.getHeight() / 2, component.getWidth(), component.getHeight() / 2), true, false);
    }

    public static final void drawVerticalHighlight(Graphics graphics, Component component) {
        MetouiaGradients.drawHighlight(graphics, new Rectangle(0, 0, component.getWidth() / 2, component.getHeight()), false, true);
    }

    public static final void drawVerticalShadow(Graphics graphics, Component component) {
        MetouiaGradients.drawShadow(graphics, new Rectangle(component.getWidth() / 2, 0, component.getWidth() / 2, component.getHeight()), false, false);
    }

    public MetouiaGradients(Color color, Color color2, boolean bl, boolean bl2) {
        this.startColor = color.getRGB();
        this.endColor = color2.getRGB();
        this.isVertical = bl;
        this.isAscending = bl2;
    }
}

