/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class ConferenceIqProvider
extends SafeParseIqProvider<ConferenceIq> {
    public ConferenceIqProvider() {
        ProviderManager.addIQProvider("conference", "http://jitsi.org/protocol/focus", this);
    }

    @Override
    protected ConferenceIq doParse(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        ConferenceIq iq;
        String namespace = parser2.getNamespace();
        if (!"http://jitsi.org/protocol/focus".equals(namespace)) {
            return null;
        }
        String rootElement = parser2.getName();
        if ("conference".equals(rootElement)) {
            String identity;
            String machineUID;
            String sessionId;
            String focusJid;
            String ready;
            String token;
            iq = new ConferenceIq();
            EntityBareJid room = ConferenceIqProvider.getRoomJid(parser2.getAttributeValue("", "room"));
            iq.setRoom(room);
            String vnode = parser2.getAttributeValue("", "vnode");
            if (StringUtils.isNotEmpty(vnode)) {
                iq.setVnode(vnode);
            }
            if (StringUtils.isNotEmpty(token = parser2.getAttributeValue("", "token"))) {
                iq.setToken(token);
            }
            if (StringUtils.isNotEmpty(ready = parser2.getAttributeValue("", "ready"))) {
                iq.setReady(Boolean.valueOf(ready));
            }
            if (StringUtils.isNotEmpty(focusJid = parser2.getAttributeValue("", "focusjid"))) {
                iq.setFocusJid(focusJid);
            }
            if (StringUtils.isNotEmpty(sessionId = parser2.getAttributeValue("", "session-id"))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty(machineUID = parser2.getAttributeValue("", "machine-uid"))) {
                iq.setMachineUID(machineUID);
            }
            if (StringUtils.isNotEmpty(identity = parser2.getAttributeValue("", "identity"))) {
                iq.setIdentity(identity);
            }
        } else {
            return null;
        }
        ConferenceIq.Property property = null;
        boolean done = false;
        while (!done) {
            switch (parser2.next()) {
                case END_ELEMENT: {
                    String name = parser2.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"property".equals(name) || property == null) break;
                    iq.addProperty(property);
                    property = null;
                    break;
                }
                case START_ELEMENT: {
                    String propValue;
                    String name = parser2.getName();
                    if (!"property".equals(name)) break;
                    property = new ConferenceIq.Property();
                    String propName = parser2.getAttributeValue("", "name");
                    if (StringUtils.isNotEmpty(propName)) {
                        property.setName(propName);
                    }
                    if (!StringUtils.isNotEmpty(propValue = parser2.getAttributeValue("", "value"))) break;
                    property.setValue(propValue);
                }
            }
        }
        return iq;
    }

    public static EntityBareJid getRoomJid(String unescapedValue) throws XmppStringprepException {
        int ix;
        int n = ix = unescapedValue == null ? -1 : unescapedValue.lastIndexOf("@");
        if (ix == -1) {
            throw new XmppStringprepException(unescapedValue, "wrong room name jid format");
        }
        String domainPart = unescapedValue.substring(ix + 1);
        String localPart = unescapedValue.substring(0, ix);
        if (localPart.contains("@")) {
            throw new XmppStringprepException(unescapedValue, "Localpart must not contain '@'");
        }
        return JidCreate.entityBareFrom(Localpart.from(localPart), Domainpart.from(domainPart));
    }
}

