/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CleaningWeakReferenceMap<K, V>
extends HashMap<K, WeakReference<V>> {
    private static final long serialVersionUID = 0L;
    private final int cleanInterval;
    private int numberOfInsertsSinceLastClean = 0;

    public CleaningWeakReferenceMap() {
        this(50);
    }

    public CleaningWeakReferenceMap(int cleanInterval) {
        this.cleanInterval = cleanInterval;
    }

    @Override
    public WeakReference<V> put(K key, WeakReference<V> value2) {
        WeakReference<V> ret = super.put(key, value2);
        if (this.numberOfInsertsSinceLastClean++ > this.cleanInterval) {
            this.numberOfInsertsSinceLastClean = 0;
            this.clean();
        }
        return ret;
    }

    private void clean() {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if (e == null || e.getValue() == null || ((WeakReference)e.getValue()).get() != null) continue;
            iter.remove();
        }
    }
}

