/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.KafkaException;
import kafka.common.MessageSizeTooLargeException;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Logging;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t/\u0011\u001a2\u0001A\u0005'!\rQQbD\u0007\u0002\u0017)\u0011A\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001d-\u0011\u0001#\u0013;fe\u0006$xN\u001d+f[Bd\u0017\r^3\u0011\tA\u0019RcI\u0007\u0002#)\u0011!\u0003B\u0001\b[\u0016\u001c8/Y4f\u0013\t!\u0012C\u0001\nNKN\u001c\u0018mZ3B]\u0012lU\r^1eCR\f\u0007C\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011aS\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\f%\t\u0015)\u0003A1\u0001\u001a\u0005\u00051\u0006C\u0001\u0006(\u0013\tA3BA\u0004M_\u001e<\u0017N\\4\t\u0011)\u0002!Q1A\u0005\n-\nqa\u00195b]:,G.F\u0001-!\riCGN\u0007\u0002])\u0011q\u0006M\u0001\u000bG>t7-\u001e:sK:$(BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!\u0001\u0005$fi\u000eDW\r\u001a#bi\u0006\u001c\u0005.\u001e8l\u0011!Y\u0004A!A!\u0002\u0013a\u0013\u0001C2iC:tW\r\u001c\u0011\t\u0011u\u0002!\u0011!Q\u0001\ny\n\u0011cY8ogVlWM\u001d+j[\u0016|W\u000f^'t!\tYr(\u0003\u0002A9\t\u0019\u0011J\u001c;\t\u0011\t\u0003!Q1A\u0005\n\r\u000b!b[3z\t\u0016\u001cw\u000eZ3s+\u0005!\u0005cA#I+5\taI\u0003\u0002H\t\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005%3%a\u0002#fG>$WM\u001d\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\t\u0006Y1.Z=EK\u000e|G-\u001a:!\u0011!i\u0005A!b\u0001\n\u0013q\u0015\u0001\u0004<bYV,G)Z2pI\u0016\u0014X#A(\u0011\u0007\u0015C5\u0005\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003P\u000351\u0018\r\\;f\t\u0016\u001cw\u000eZ3sA!A1\u000b\u0001BC\u0002\u0013\u0005A+\u0001\u0005dY&,g\u000e^%e+\u0005)\u0006C\u0001,^\u001d\t96\f\u0005\u0002Y95\t\u0011L\u0003\u0002[\r\u00051AH]8pizJ!\u0001\u0018\u000f\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039rA\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006I!V\u0001\nG2LWM\u001c;JI\u0002BQa\u0019\u0001\u0005\u0002\u0011\fa\u0001P5oSRtDCB3gO\"L'\u000e\u0005\u00038\u0001U\u0019\u0003\"\u0002\u0016c\u0001\u0004a\u0003\"B\u001fc\u0001\u0004q\u0004\"\u0002\"c\u0001\u0004!\u0005\"B'c\u0001\u0004y\u0005\"B*c\u0001\u0004)\u0006b\u00027\u0001\u0005\u0004%I!\\\u0001\bGV\u0014(/\u001a8u+\u0005q\u0007cA8si6\t\u0001O\u0003\u0002r]\u00051\u0011\r^8nS\u000eL!a\u001d9\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!\u001e>~\u001d\t1\bP\u0004\u0002Yo&\tQ$\u0003\u0002z9\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005!IE/\u001a:bi>\u0014(BA=\u001d!\t\u0001b0\u0003\u0002\u0000#\t\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003o\u0003!\u0019WO\u001d:f]R\u0004\u0003\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0003A\u0019WO\u001d:f]R$v\u000e]5d\u0013:4w.\u0006\u0002\u0002\fA\u0019q'!\u0004\n\u0007\u0005=!A\u0001\nQCJ$\u0018\u000e^5p]R{\u0007/[2J]\u001a|\u0007\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0003Q\u0019WO\u001d:f]R$v\u000e]5d\u0013:4wn\u0018\u0013fcR!\u0011qCA\u000f!\rY\u0012\u0011D\u0005\u0004\u00037a\"\u0001B+oSRD!\"a\b\u0002\u0012\u0005\u0005\t\u0019AA\u0006\u0003\rAH%\r\u0005\t\u0003G\u0001\u0001\u0015)\u0003\u0002\f\u0005\t2-\u001e:sK:$Hk\u001c9jG&sgm\u001c\u0011\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0012AD2p]N,X.\u001a3PM\u001a\u001cX\r^\u000b\u0003\u0003W\u00012aGA\u0017\u0013\r\ty\u0003\b\u0002\u0005\u0019>tw\rC\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026\u0005\u00112m\u001c8tk6,Gm\u00144gg\u0016$x\fJ3r)\u0011\t9\"a\u000e\t\u0015\u0005}\u0011\u0011GA\u0001\u0002\u0004\tY\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0015BA\u0016\u0003=\u0019wN\\:v[\u0016$wJ\u001a4tKR\u0004\u0003\"CA \u0001\t\u0007I\u0011BA!\u0003I\u0019wN\\:v[\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0005\u0005\r\u0003cA\u001c\u0002F%\u0019\u0011q\t\u0002\u0003%\r{gn];nKJ$v\u000e]5d'R\fGo\u001d\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002D\u0005\u00192m\u001c8tk6,'\u000fV8qS\u000e\u001cF/\u0019;tA!9\u0011q\n\u0001\u0005B\u0005E\u0013\u0001\u00028fqR$\u0012a\u0004\u0005\b\u0003+\u0002A\u0011CA)\u0003!i\u0017m[3OKb$\bbBA-\u0001\u0011\u0005\u00111L\u0001\u0012G2,\u0017M]\"veJ,g\u000e^\"ik:\\GCAA\fQ\u001d\u0001\u0011qLA3\u0003S\u00022aGA1\u0013\r\t\u0019\u0007\b\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA4\u0003\u001d#\u0006.[:!G2\f7o\u001d\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0013EAA6\u0003!\u0001d&M\u0019/a9\u0002\u0004")
public class ConsumerIterator<K, V>
extends IteratorTemplate<MessageAndMetadata<K, V>>
implements Logging {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final String clientId;
    private final AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo currentTopicInfo;
    private long consumedOffset;
    private final ConsumerTopicStats consumerTopicStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    private Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public String clientId() {
        return this.clientId;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private PartitionTopicInfo currentTopicInfo() {
        return this.currentTopicInfo;
    }

    private void currentTopicInfo_$eq(PartitionTopicInfo x$1) {
        this.currentTopicInfo = x$1;
    }

    private long consumedOffset() {
        return this.consumedOffset;
    }

    private void consumedOffset_$eq(long x$1) {
        this.consumedOffset = x$1;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<K, V> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.consumedOffset() < 0L) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.consumedOffset())})));
        }
        this.currentTopicInfo().resetConsumeOffset(this.consumedOffset());
        String topic = this.currentTopicInfo().topic();
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Setting %s consumed offset to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToLong((long)this.consumedOffset())})));
        this.consumerTopicStats().getConsumerTopicStats(topic).messageRate().mark();
        this.consumerTopicStats().getConsumerAllTopicStats().messageRate().mark();
        return var1_1;
    }

    @Override
    public MessageAndMetadata<K, V> makeNext() {
        FetchedDataChunk currentDataChunk = null;
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk = this.channel().take();
            } else {
                currentDataChunk = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if (currentDataChunk == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if (currentDataChunk == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received the shutdown command");
                return (MessageAndMetadata)this.allDone();
            }
            this.currentTopicInfo_$eq(currentDataChunk.topicInfo());
            long cdcFetchOffset = currentDataChunk.fetchOffset();
            long ctiConsumeOffset = this.currentTopicInfo().getConsumeOffset();
            if (ctiConsumeOffset < cdcFetchOffset) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)ctiConsumeOffset), BoxesRunTime.boxToLong((long)cdcFetchOffset), this.currentTopicInfo()})));
                this.currentTopicInfo().resetConsumeOffset(cdcFetchOffset);
            }
            localCurrent = currentDataChunk.messages().iterator();
            this.current().set(localCurrent);
            if (currentDataChunk.messages().validBytes() == 0) {
                throw new MessageSizeTooLargeException("Found a message larger than the maximum fetch size of this consumer on topic " + new StringOps(Predef$.MODULE$.augmentString("%s partition %d at fetch offset %d. Increase the fetch size, or decrease the maximum message size the broker will allow.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentDataChunk.topicInfo().topic(), BoxesRunTime.boxToInteger((int)currentDataChunk.topicInfo().partitionId()), BoxesRunTime.boxToLong((long)currentDataChunk.fetchOffset())})));
            }
        }
        MessageAndOffset item = (MessageAndOffset)localCurrent.next();
        while (item.offset() < this.currentTopicInfo().getConsumeOffset() && localCurrent.hasNext()) {
            item = (MessageAndOffset)localCurrent.next();
        }
        this.consumedOffset_$eq(item.nextOffset());
        item.message().ensureValid();
        return new MessageAndMetadata<K, V>(this.currentTopicInfo().topic(), this.currentTopicInfo().partitionId(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder(), item.message().timestamp(), item.message().timestampType());
    }

    public void clearCurrentChunk() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Clearing the current data chunk for this consumer iterator");
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<K> keyDecoder, Decoder<V> valueDecoder, String clientId) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.clientId = clientId;
        Logging.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.currentTopicInfo = null;
        this.consumedOffset = -1L;
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

