/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH$J@\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/runner/AbstractRunner;", "Lorg/jetbrains/kotlin/runner/Runner;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "createClassLoader", "Ljava/lang/ClassLoader;", "classpath", "", "Ljava/net/URL;", "run", "", "compilerArguments", "arguments", "compilerClasspath", "kotlin-runner"})
@SourceDebugExtension(value={"SMAP\nrunners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 runners.kt\norg/jetbrains/kotlin/runner/AbstractRunner\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n37#2:181\n36#2,3:182\n*S KotlinDebug\n*F\n+ 1 runners.kt\norg/jetbrains/kotlin/runner/AbstractRunner\n*L\n70#1:181\n70#1:182,3\n*E\n"})
public abstract class AbstractRunner
implements Runner {
    @NotNull
    protected abstract String getClassName();

    @NotNull
    protected abstract ClassLoader createClassLoader(@NotNull List<URL> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(@NotNull List<URL> classpath, @NotNull List<String> compilerArguments, @NotNull List<String> arguments, @NotNull List<URL> compilerClasspath) {
        String string;
        String savedClasspathProperty;
        block12: {
            Object e3222222;
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(classpath, "classpath");
            Intrinsics.checkNotNullParameter(compilerArguments, "compilerArguments");
            Intrinsics.checkNotNullParameter(arguments, "arguments");
            Intrinsics.checkNotNullParameter(compilerClasspath, "compilerClasspath");
            ClassLoader classLoader = this.createClassLoader(classpath);
            try {
                clazz = classLoader.loadClass(this.getClassName());
            }
            catch (ClassNotFoundException e2) {
                throw new RunnerException("could not find or load main class " + this.getClassName(), null, 2, null);
            }
            catch (NoClassDefFoundError e3222222) {
                String message = StringsKt.trimIndent("\n                could not find or load main class " + this.getClassName() + "\n                Caused by: " + e3222222 + "\n            ");
                throw new RunnerException(message, null, 2, null);
            }
            Class<?> mainClass = clazz;
            try {
                e3222222 = new Class[]{String[].class};
                e3222222 = mainClass.getDeclaredMethod("main", (Class<?>)e3222222);
            }
            catch (NoSuchMethodException e4) {
                throw new RunnerException("'main' method not found in class " + this.getClassName(), null, 2, null);
            }
            Object main2 = e3222222;
            if (!Modifier.isStatic(((Method)main2).getModifiers())) {
                throw new RunnerException("'main' method of class " + this.getClassName() + " is not static. Please ensure that 'main' is either a top level Kotlin function, a member function annotated with @JvmStatic, or a static Java method", null, 2, null);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            Iterable iterable = classpath;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(string2, "pathSeparator");
            savedClasspathProperty = System.setProperty("java.class.path", CollectionsKt.joinToString$default(iterable, string2, null, null, 0, null, null, 62, null));
            try {
                Object[] objectArray = new Object[1];
                Collection $this$toTypedArray$iv = arguments;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray[0] = thisCollection$iv.toArray(new String[0]);
                ((Method)main2).invoke(null, objectArray);
                if (savedClasspathProperty != null) break block12;
            }
            catch (IllegalAccessException e5) {
                try {
                    throw new RunnerException("'main' method of class " + this.getClassName() + " is not public", null, 2, null);
                    catch (InvocationTargetException e6) {
                        throw e6.getTargetException();
                    }
                }
                catch (Throwable throwable) {
                    String string3;
                    if (savedClasspathProperty == null) {
                        string3 = System.clearProperty("java.class.path");
                        throw throwable;
                    }
                    string3 = System.setProperty("java.class.path", savedClasspathProperty);
                    throw throwable;
                }
            }
            string = System.clearProperty("java.class.path");
            return;
        }
        string = System.setProperty("java.class.path", savedClasspathProperty);
    }
}

