/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.util.Date;
import org.opensolaris.opengrok.history.HistoryEntry;

public abstract class TagEntry
implements Comparable {
    protected int revision;
    protected Date date;
    protected String tags;
    protected static final int NOREV = -1;

    public TagEntry(int revision, String tags) {
        this.revision = revision;
        this.date = null;
        this.tags = tags;
    }

    public TagEntry(Date date, String tags) {
        if (date == null) {
            throw new NullPointerException("Can't create TagEntry using date==null");
        }
        this.revision = -1;
        this.date = date;
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tag) {
        this.tags = tag;
    }

    public Date getDate() {
        return this.date;
    }

    public int compareTo(Object aThat) {
        if (this == aThat) {
            return 0;
        }
        TagEntry that = (TagEntry)aThat;
        if (this.revision != -1) {
            return Integer.valueOf(this.revision).compareTo(that.revision);
        }
        assert (this.date != null) : "date == null";
        return this.date.compareTo(that.date);
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof TagEntry)) {
            return false;
        }
        TagEntry that = (TagEntry)aThat;
        if (this.revision != -1) {
            return this.revision == that.revision;
        }
        assert (this.date != null) : "date == null";
        return this.date.equals(that.date);
    }

    public int hashCode() {
        if (this.revision != -1) {
            return this.revision;
        }
        assert (this.date != null) : "date == null";
        return this.date.hashCode();
    }

    public abstract int compareTo(HistoryEntry var1);
}

