/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.opensolaris.opengrok.search.Summary;

public class Summarizer {
    private static final int SUM_CONTEXT = 10;
    private static final int SUM_LENGTH = 20;
    private final Analyzer analyzer;
    private final Set<String> highlight = new HashSet<String>();

    public Summarizer(Query query, Analyzer a) {
        this.analyzer = a;
        this.getTerms(query);
    }

    public Summary getSummary(String text) throws IOException {
        if (text == null) {
            return null;
        }
        Token[] tokens = this.getTokens(text);
        if (tokens.length == 0) {
            return new Summary();
        }
        TreeSet<Excerpt> excerptSet = new TreeSet<Excerpt>(new Comparator<Excerpt>(){

            @Override
            public int compare(Excerpt excerpt1, Excerpt excerpt2) {
                int numToks2;
                if (excerpt1 == null) {
                    return excerpt2 == null ? 0 : -1;
                }
                if (excerpt2 == null) {
                    return 1;
                }
                int numToks1 = excerpt1.numUniqueTokens();
                if (numToks1 < (numToks2 = excerpt2.numUniqueTokens())) {
                    return -1;
                }
                if (numToks1 == numToks2) {
                    return excerpt1.numFragments() - excerpt2.numFragments();
                }
                return 1;
            }
        });
        int lastExcerptPos = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (!this.highlight.contains(tokens[i].toString())) continue;
            int startToken = i > 10 ? i - 10 : 0;
            int endToken = Math.min(i + 10, tokens.length);
            int offset = tokens[startToken].startOffset();
            int j = startToken;
            Excerpt excerpt = new Excerpt();
            if (i != 0) {
                excerpt.add(new Summary.Ellipsis());
            }
            while (j < endToken && j - startToken < 20) {
                Token t = tokens[j];
                if (this.highlight.contains(t.toString())) {
                    excerpt.addToken(t.toString());
                    excerpt.add(new Summary.Fragment(text.substring(offset, t.startOffset())));
                    excerpt.add(new Summary.Highlight(text.substring(t.startOffset(), t.endOffset())));
                    offset = t.endOffset();
                    endToken = Math.min(j + 10, tokens.length);
                }
                ++j;
            }
            lastExcerptPos = endToken;
            if (j < tokens.length) {
                excerpt.add(new Summary.Fragment(text.substring(offset, tokens[j].endOffset())));
            }
            excerpt.setNumTerms(j - startToken);
            excerptSet.add(excerpt);
            i = j + 10;
        }
        if (excerptSet.size() == 0) {
            int excerptLen;
            Excerpt excerpt = new Excerpt();
            lastExcerptPos = excerptLen = Math.min(20, tokens.length);
            excerpt.add(new Summary.Fragment(text.substring(tokens[0].startOffset(), tokens[excerptLen - 1].startOffset())));
            excerpt.setNumTerms(excerptLen);
            excerptSet.add(excerpt);
        }
        double tokenCount = 0.0;
        Summary s = new Summary();
        while (tokenCount <= 20.0 && excerptSet.size() > 0) {
            Excerpt excerpt = (Excerpt)excerptSet.last();
            excerptSet.remove(excerpt);
            double tokenFraction = 1.0 * (double)excerpt.getNumTerms() / (double)excerpt.numFragments();
            for (Summary.Fragment f : excerpt.elements()) {
                if (tokenCount + tokenFraction <= 20.0) {
                    s.add(f);
                }
                tokenCount += tokenFraction;
            }
        }
        if (tokenCount > 0.0 && lastExcerptPos < tokens.length) {
            s.add(new Summary.Ellipsis());
        }
        return s;
    }

    private Token[] getTokens(String text) throws IOException {
        ArrayList<Token> result = new ArrayList<Token>();
        TokenStream ts = this.analyzer.tokenStream("full", text);
        CharTermAttribute term = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        OffsetAttribute offset = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            Token t = new Token(term.buffer(), 0, term.length(), offset.startOffset(), offset.endOffset());
            result.add(t);
        }
        ts.end();
        ts.close();
        return result.toArray(new Token[result.size()]);
    }

    private void getTerms(Query query) {
        if (query instanceof BooleanQuery) {
            this.getBooleans((BooleanQuery)query);
        } else if (query instanceof PhraseQuery) {
            this.getPhrases((PhraseQuery)query);
        } else if (query instanceof WildcardQuery) {
            this.getWildTerm((WildcardQuery)query);
        } else if (query instanceof TermQuery) {
            this.getTerm((TermQuery)query);
        } else if (query instanceof PrefixQuery) {
            this.getPrefix((PrefixQuery)query);
        }
    }

    private void getBooleans(BooleanQuery query) {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (queryClauses[i].isProhibited()) continue;
            this.getTerms(queryClauses[i].getQuery());
        }
    }

    private void getPhrases(PhraseQuery query) {
        Term[] queryTerms = query.getTerms();
        for (int i = 0; i < queryTerms.length; ++i) {
            this.highlight.add(queryTerms[i].text());
        }
    }

    private void getTerm(TermQuery query) {
        this.highlight.add(query.getTerm().text());
    }

    private void getWildTerm(WildcardQuery query) {
        this.highlight.add(query.getTerm().text());
    }

    private void getPrefix(PrefixQuery query) {
        this.highlight.add(query.getPrefix().text());
    }

    static class Excerpt {
        List<Summary.Fragment> passages = new ArrayList<Summary.Fragment>();
        Set<String> tokenSet = new TreeSet<String>();
        int numTerms = 0;

        Excerpt() {
        }

        public void addToken(String token) {
            this.tokenSet.add(token);
        }

        public int numUniqueTokens() {
            return this.tokenSet.size();
        }

        public int numFragments() {
            return this.passages.size();
        }

        public void setNumTerms(int numTerms) {
            this.numTerms = numTerms;
        }

        public int getNumTerms() {
            return this.numTerms;
        }

        public void add(Summary.Fragment fragment) {
            this.passages.add(fragment);
        }

        public List<Summary.Fragment> elements() {
            return this.passages;
        }
    }
}

