/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;

public class ReportLastScan {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAlertXML(Database database, RecordScan recordScan) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            connection = database.getDatabaseServer().getNewConnection();
            connection.setReadOnly(true);
            preparedStatement = connection.prepareStatement("SELECT ALERT.ALERTID FROM ALERT JOIN SCAN ON ALERT.SCANID = SCAN.SCANID WHERE SCAN.SCANID = ? ORDER BY PLUGINID");
            preparedStatement.setInt(1, recordScan.getScanId());
            preparedStatement.executeQuery();
            ResultSet resultSet = preparedStatement.getResultSet();
            RecordAlert recordAlert = null;
            Alert alert = null;
            Alert alert2 = null;
            StringBuffer stringBuffer2 = new StringBuffer(100);
            String string = null;
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                recordAlert = database.getTableAlert().read(n);
                alert = new Alert(recordAlert);
                if (alert2 != null && alert.getPluginId() != alert2.getPluginId()) {
                    string = alert2.toPluginXML(stringBuffer2.toString());
                    stringBuffer.append(string);
                    stringBuffer2.setLength(0);
                }
                string = alert.getUrlParamXML();
                stringBuffer2.append(string);
                alert2 = alert;
            }
            if (alert2 != null) {
                stringBuffer.append(alert2.toPluginXML(stringBuffer2.toString()));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return stringBuffer.toString();
    }

    public File generate(String string, Model model) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(500);
        RecordScan recordScan = null;
        recordScan = model.getDb().getTableScan().getLatestScan();
        if (recordScan == null) {
            return null;
        }
        stringBuffer.append("<?xml version=\"1.0\"?>");
        stringBuffer.append("<report>\r\n");
        stringBuffer.append("Report generated at " + ReportGenerator.getCurrentDateTimeString() + ".\r\n");
        stringBuffer.append(this.getAlertXML(model.getDb(), recordScan));
        stringBuffer.append("</report>");
        if (!string.endsWith(".htm")) {
            string = string + ".htm";
        }
        File file = ReportGenerator.stringToHtml(stringBuffer.toString(), "xml" + File.separator + "reportLatestScan.xsl", string);
        return file;
    }

    public void generate(ViewDelegate viewDelegate, Model model) {
        Object var3_3 = null;
        try {
            String string = model.getSession().getSessionFolder() + File.separator + "LatestScannedReport.htm";
            File file = this.generate(string, model);
            if (file == null) {
                return;
            }
            viewDelegate.showMessageDialog("Scanning report generated.  If it does not show up after clicking OK,\r\nplease browse the file at " + file.getAbsolutePath());
            ReportGenerator.openBrowser(file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            viewDelegate.showWarningDialog("File creation error.");
        }
    }
}

