/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import br.arca.morcego.structure.link.SolidLink;
import java.util.Hashtable;

public class GraphElementFactory {
    private static Hashtable types = new Hashtable();

    public static void defineType(String type, Hashtable properties) {
        types.put(type, properties);
    }

    public static Link createLink(Node node, Node neighbour, String type) {
        if (node.isLinkedTo(neighbour)) {
            return node.getLinkTo(neighbour);
        }
        if (type == null) {
            type = Config.getString("morcego.linkDefaultType");
        }
        Class linkClass = null;
        Link link = null;
        try {
            linkClass = Config.getLinkClass(type);
            link = (Link)linkClass.newInstance();
            link.setup(node, neighbour);
        }
        catch (Exception e) {
            e.printStackTrace();
            link = new SolidLink(node, neighbour);
        }
        return link;
    }

    public static Node createNode(String nodeId, Graph graph, String type) {
        Node node;
        Class nodeClass = null;
        if (type == null) {
            type = Config.getString("morcego.nodeDefaultType");
        }
        try {
            nodeClass = Config.getNodeClass(type);
            Node existingNode = graph.getNodeById(nodeId);
            if (existingNode != null && existingNode.getClass() == nodeClass) {
                return existingNode;
            }
            node = (Node)nodeClass.newInstance();
            node.setup(nodeId, graph);
        }
        catch (Exception e) {
            e.printStackTrace();
            node = !type.equals("Round") ? GraphElementFactory.createNode(nodeId, graph, "Round") : new Node(nodeId, graph);
        }
        return node;
    }
}

