<?php

###############################################################################
# french_france.php
#
# This is a french language version for Geeklog!
# Updated by ::Ben http::geeklog.fr 2010 05 10 
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'iso-8859-1';

$LANG_ISO639_1 = 'fr';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Par',
    2 => 'Lire la suite...',
    3 => 'commentaires',
    4 => 'Modifier',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => 'Fonctions Admin:',
    10 => 'Propositions',
    11 => 'Articles',
    12 => 'Blocks',
    13 => 'Cat�gories',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => 'Membres',
    18 => 'Requ�te SQL',
    19 => 'Se d�connecter',
    20 => 'Infos personnelles:',
    21 => 'Nom d\'utilisateur',
    22 => 'ID d\'utilisateur',
    23 => 'Niveau de s�curit�',
    24 => 'Anonyme',
    25 => 'R�pondre',
    26 => 'Les commentaires permettent � chacun d\'enrichir le web.',
    27 => 'Commentaire le plus r�cent',
    28 => 'Effacer',
    29 => 'Aucun commentaire.',
    30 => 'Anciens articles',
    31 => 'Balises HTML autoris�es :',
    32 => 'Erreur: Nom d\'utilisateur erron�',
    33 => 'Erreur: Impossibilit� d\'enregistrer dans le fichier log',
    34 => 'Erreur',
    35 => 'Se d�connecter',
    36 => 'Le',
    37 => 'Aucun article d\'utilisateur',
    38 => 'Syndication',
    39 => 'Rafra�chir',
    40 => 'Error in password request, invalid username',
    41 => 'Visiteurs',
    42 => 'par',
    43 => 'R�pondre',
    44 => 'Parent',
    45 => 'Num�ro d\'erreur MySQL',
    46 => 'Message d\'erreur MySQL',
    47 => 'Espace Membre',
    48 => 'Mon compte',
    49 => 'Pr�f�rences d\'affichage',
    50 => 'Erreur dans la requ�te SQL',
    51 => 'aide',
    52 => 'Nouveau',
    53 => 'Centre administratif',
    54 => 'Fichier impossible � ouvrir.',
    55 => 'Erreur �',
    56 => 'Voter',
    57 => 'Mot de passe',
    58 => 'Connexion',
    59 => "Devenir membre<br" . XHTML . "> <a href=\"{$_CONF['site_url']}/users.php?mode=new\">Enregistrez-vous</a>",
    60 => 'Ajouter votre commentaire',
    61 => 'Cr�er un nouveau compte',
    62 => 'mots suppl�mentaires',
    63 => 'Commentaires pr�f�r�s',
    64 => 'Envoyer cet article � un ami',
    65 => 'Version imprimable',
    66 => '',
    67 => 'Bienvenue sur',
    68 => 'Accueil',
    69 => 'Contact',
    70 => 'Chercher',
    71 => 'Contribuer',
    72 => 'Web Resources',
    73 => '',
    74 => '',
    75 => 'Recherche',
    76 => 'Statistiques',
    77 => 'Plugins',
    78 => '',
    79 => 'Quoi de neuf ?',
    80 => 'derniers articles',
    81 => 'dernier article',
    82 => 'heures',
    83 => 'COMMENTAIRES',
    84 => '',
    85 => 'derni�res 48 heures',
    86 => 'Aucun',
    87 => '2 derni�res semaines',
    88 => '',
    89 => '',
    90 => 'Accueil',
    91 => 'Page g�n�r�e en',
    92 => 'secondes',
    93 => 'Tous droits r�serv�s',
    94 => 'Toutes les marques cit�es appartiennent � leurs propri�taires respectifs.',
    95 => 'Propuls� par',
    96 => 'Groupes',
    97 => 'Liste de mots',
    98 => 'Plugins',
    99 => 'ARTICLES',
    100 => 'Pas de nouvel article',
    101 => 'There are no older articles',
    102 => '',
    103 => 'Sauvegarde de la BDD',
    104 => 'par',
    105 => 'Email aux membres',
    106 => 'Lu',
    107 => 'Version GL',
    108 => 'Vider le cache',
    109 => 'Signaler un abus',
    110 => 'Signaler ce message � l\'administrateur',
    111 => '',
    112 => 'Membres',
    113 => 'Documentation',
    114 => 'Trackbacks',
    115 => 'Pas de nouveau Trackback',
    116 => 'Trackback',
    117 => 'Archives',
    118 => 'Please continue reading on the next page:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\">Mot de passe oubli�</a> ?",
    120 => 'Lien permanent vers ce commentaire',
    121 => 'Commentaires (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'Tout code HTML accept�',
    124 => 'Cliquez pour effacer tous les articles s�lectionn�s',
    125 => 'Etes-vous certain de vouloir effacer tous les articles s�lectionn�s ?',
    126 => 'S�lectionnez ou d�s�lectionnez tous les articles',
    127 => 'Permalink',
    128 => 'Login avec OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    141 => 'An Error Occurred',
    142 => 'Unfortunately, an error has occurred rendering this page. Please try again later.',
    143 => 'Commentaire (%d)',
    144 => 'Parse Error.  An error occurred while parsing PHP code.',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">Login Here</a>",
    'remoteloginoptions' => 'Remote Login Options',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'github' => 'Login with GitHub',
    'ctl' => 'Clear Cache',
    'ok' => 'OK',
    'filemanager' => 'File Manager',
    'error_invalid_password' => 'Error, invalid password for username',
    'error_filemanager_disabled' => 'Filemanager is disabled',
    'terms_of_use' => 'Terms of Use',
    'terms_of_service' => 'Terms of Service',
    'privacy_policy' => 'Privacy Policy',
    'about_cookies' => 'About Cookies',
    'parse_php_error' => 'There was an error parsing your PHP code: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Ajoutez un commentaire',
    2 => 'Format',
    3 => 'Se d�connecter',
    4 => 'Cr�ez un compte',
    5 => 'Nom',
    6 => 'This site requires you to be logged in to post a comment. If you have an account already (or need to create one), please <a href="%s">login here</a>.',
    7 => 'Votre dernier commentaire �tait il y a ',
    8 => " secondes. Vous devez attendre {$_CONF['commentspeedlimit']} secondes entre chaque commentaire.",
    9 => 'Commentaire',
    10 => 'Envoyer un rapport',
    11 => 'Envoyer le commentaire',
    12 => 'Vous devez compl�ter les champs Titre et Commentaire.',
    13 => 'Vos infos',
    14 => 'Aper�u',
    15 => 'Rapportez ce commentaire',
    16 => 'Titre',
    17 => 'Erreur',
    18 => 'Remarques',
    19 => 'Vous pouvez choisir le titre de votre commentaire.',
    20 => 'Si besoin vous pouvez utiliser les [tags]. N\'h�sitez pas � contacter l\'admin pour plus de d�tails.',
    21 => 'Pensez � v�rifier l\'orthographe, votre contribution sera publique pour longtemps.',
    22 => 'N\'h�sitez pas � r�pondre aux commentaires des autres, ou � lancer de nouveaux d�bats.',
    23 => 'Votre adresse email ne sera jamais rendue publique sauf si vous l\'ins�rez dans le corps du commentaire.',
    'instr_line6' => 'When logged in as a user your comments will be linked to your account and you can specify if you would like notifications of any replies.',
    24 => 'Utilisateur anonyme',
    25 => 'Etes-vous certain de vouloir signaler cet abus � l\'administrateur du site ?',
    26 => '%s � rapport� ce message abusif :',
    27 => 'Signaler un abus',
    28 => 'Previsualiser les changements',
    29 => 'Soumettre les changements',
    30 => 'Edit� le',
    31 => 'par',
    32 => 'Editer un commentaire',
    33 => 'Editer un commentaire soumis',
    34 => 'Previsualiser les changement de la soumission',
    35 => 'Souvegarder les changements dans la file d\'attente',
    36 => 'Signalez moi les nouvelles r�ponses',
    37 => 'Nouvelle commentaire en r�ponse',
    38 => 'Une r�ponse � �t� faite � votre commentaire \'%s\'.',
    39 => 'Vous pouvez voir le commentaire � l\'adresse  suivante :',
    40 => 'Si vous ne souhaitez plus recevoir de notifications de r�ponse, cliquez sur le lien suivant :',
    41 => 'Hello %s,',
    42 => 'Se d�sabonner',
    43 => 'Se d�sabonner des notifications',
    44 => 'Votre nom',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment.",
    100 => 'Comment Manager',
    101 => 'Existing Comments',
    102 => 'Bulk Action',
    103 => 'Ban this user',
    104 => 'Ban this IP address with the Spamx plugin',
    105 => 'IP Address',
    106 => 'Perform bulk action on comments and comment submissions including approval, deleting, and banning of user or IP address.',
    'record_edit' => 'Record user and time of edit?',
    'ban_plugin_ban_ip' => 'Ban this IP address with the Ban plugin',
    'num_comments' => '%s Comment(s)',
    'anon_user_name' => '%s (Anonymous User)',
    'comments_closed_msg' => 'Comments are closed and no new posts are allowed.',
    'read_comment' => 'Read the full comment at',
    'comment_for' => 'The above comment is for the following item',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'Profil de',
    2 => 'Nom d\'utilisateur',
    3 => 'Nom complet (facultatif)',
    4 => 'Mot de passe',
    5 => 'Email',
    6 => 'Site Internet',
    7 => 'Biographie',
    8 => 'Cl� PGP',
    9 => 'Mettre � jour',
    10 => 'Les 10 derniers commentaires de ',
    11 => 'Aucun commentaire',
    12 => 'Pr�f�rences d\'utilisation de',
    13 => 'email temporis� la nuit',
    14 => 'Ce mot de passe a ete genere automatiquement. Il est recommende que vous le changiez immediatement. Pour ce faire, connectez-vous et cliquez sur Mon compte dans le menu membre.',
    15 => "Votre compte, sur le site {$_CONF['site_name']}, a ete cree avec succes. Vous devez utiliser les informations ci-dessous pour vous connecter. Veuillez sauvegarder ce message pour vous y referer.",
    'email_convert_remote' => "Your {$_CONF['site_name']} remote account has been converted to a local account. To continue to use your account, you must login using the information below. Please save this mail for further reference.",
    16 => 'Informations sur votre compte',
    17 => 'Ce compte n\'existe pas',
    18 => 'L\'adresse email semble ne pas tre valide.',
    19 => 'Le nom d\'utilisateur ou l\'adresse email fournie est d�j� utilis�e par un autre membre.',
    20 => 'L\'adresse email fournie ne semble pas tre valide.',
    21 => 'Erreur',
    22 => 'Devenir membre du site',
    23 => 'Apr�s avoir cr�� votre compte vous pourrez utilisez toutes les fonctions r�serv�es aux membres. Votre adresse email ne sera jamais publi�e sur ce site ni c�d�e � un tiers.',
    24 => 'Un mot de passe vous permettant de vous identifer vous sera envoy� par email � l\'adresse saisie ci-dessus.<br/> Par la suite, vous pourrez si besoin modifier ce mot de passe ainsi que votre adresse email.',
    25 => 'Avez-vous oubli� votre mot de passe?',
    26 => 'Saisissez <em>soit</em> votre nom d\'utilisateur <em>soit</em> l\'adresse email enregistr�e � ce compte, et cliquez &laquo;Envoi du mot de passe&raquo;. Des instructions � suivre concernant l\'enregistrement d\'un nouveau mot de passe vous seront adress�es par email.',
    27 => 'Enregistrez-vous maintenant!',
    28 => 'Envoi du mot de passe',
    29 => 'd�connect� de',
    30 => 'connect� �',
    31 => 'Vous devez tre connect� pour ex�cuter cette fonction',
    32 => 'Signature',
    33 => 'Jamais affich�e publiquement',
    34 => 'Votre nom v�ritable',
    35 => 'Entrez votre mot de passe afin de le changer',
    36 => 'Commence par http://',
    37 => 'Appliquer � vos commentaires',
    38 => 'Tout sur vous! Accessible par tous',
    39 => 'Votre cl� puplique PGP � partager',
    42 => 'Format de date',
    43 => 'Nombre maximum d\'articles',
    48 => 'Cat�gories',
    52 => 'Par d�faut',
    53 => 'Recevoir les articles du jour chaque nuit',
    56 => 'Auteur',
    57 => 'Format',
    58 => 'Ordre de tri',
    59 => 'Nombre maximum de commentaires',
    60 => 'Comment souhaitez vous que vos commentaires appara�ssent?',
    61 => 'Les plus r�cents ou les plus anciens en premier?',
    62 => '100 par d�faut',
    63 => "Votre mot de passe vous a �t� envoy� par email et ne devrait pas tarder. Merci de suivre les instructions du message pour vous connecter & agrave; l'espace membre de {$_CONF['site_name']}",
    64 => 'Pr�f�rences des commentaires pour',
    65 => 'Essayez de vous connecter',
    66 => 'Veuillez saisir votre nom d\'utilisateur et votre mot de passe correspondant dans le formulaire ci-dessous.',
    67 => 'Membre depuis',
    68 => 'Auto login',
    69 => 'Combien de temps devrions-nous garder votre connexion active?',
    'cookietimeout_tooltip' => 'This site will remember you are logged in from the device you are currently using regardless of if your account has been logged out automatically due to no activity. Accounts are logged out after being inactive for %s seconds (this is called the "User Session Timeout"). When "Remember Me For" is set for your account it will include the time you select here PLUS the "User Session timeout".',
    70 => "Personnaliser l'aspect et le contenu de {$_CONF['site_name']}",
    71 => "Une fonctionnalit� int�ressante du site {$_CONF['site_name']} est que vous pouvez en personnaliser l'aspect et le contenu. Afin de pouvoir utiliser ces fonctionnalit�s vous devez vous <a href=\"{$_CONF['site_url']}/users.php?mode=new\">enregistrer</a> au pr�s du site {$_CONF['site_name']}.  Vous �tes d�j� membre?  Alors utilisez la passerelle de connexion dans la barre lat�rale pour vous connecter!",
    72 => 'Th�me',
    73 => 'Langue',
    74 => 'Changez l\'aspect de ce site!',
    75 => 'Envoyez des email � ces sujets',
    76 => 'Si vous s�lectionnez une ou plusieurs cat�gories parmi celles ci-dessous, vous recevrez par email un avis de publication des nouveaux articles publi�s dans cette cat�gorie.',
    77 => 'Photo',
    78 => 'Ajouter votre propre photo!',
    79 => 'Cochez ici pour effacer cette photo',
    80 => 'Connexion',
    81 => 'Envoyer un email',
    82 => 'Les 10 derniers articles de',
    83 => 'Statistiques concernant',
    84 => 'Nombre total d\'articles:',
    85 => 'Nombre total de commentaires:',
    86 => 'Chercher tous les articles de',
    87 => 'Votre nom de membre',
    88 => "Quelqu'un a demand� un nouveau mot de passe pour le compte '%s' sur le site {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nSi vous d�sirez r�ellement que cette action soit entreprise, cliquez sur ce lien:\n\n",
    'user_password_action_msg' => 'If you really want this action to be taken, please click on the following link:',
    89 => "Pour refuser d\'entreprendre cette action, vous n\'avez simplement qu\'a ignorer ce message, ainsi votre mot de passe demeurera inchange.\n\n",
    90 => 'Vous pouvez choisir un nouveau mot de passe pour le compte ci-dessous. Pri�re de noter que l\'ancien mot de passe demeurera actif jusqu\'� ce que vous soumettiez ce formulaire.',
    91 => 'R�glez le nouveau mot de passe',
    92 => 'Entrez le nouveau mot de passe',
    93 => 'Votre derni�re requte pour l\'obtention d\'un nouveau mot de passe �tait il y a %d secondes de cela. Ce site requiers que s\'�coule au moins %d secondes entre les requtes de nouveaux mots de passe.',
    94 => 'Effacer le compte "%s"',
    96 => 'Effacer le compte',
    97 => 'Confirmez l\'effacement de votre compte',
    98 => 'Etes-vous certain de vouloir effacer ce compte? Car ce faisant, vous ne pourrez alors plus acc�der aux fonctions de ce site (sauf en cr�ant un nouveau compte). Si vous en tes certain, cliquez alors sur "effacer le compte" une derni�re fois ci-dessous.',
    99 => 'Options de s�curit� pour',
    100 => 'Emails de l\'administrateur du site',
    101 => 'Autorisez les emails provenant de l\'administrateur du site',
    102 => 'Emails des membres',
    103 => 'Allouez la r�ception de emails provenant d\'autre membres',
    104 => 'Affichez votre pr�sence en ligne',
    105 => 'Affichez ma pr�sence dans le block &laquo;En ligne&raquo;',
    106 => 'Localisation',
    107 => 'Affich� dans votre profil',
    108 => 'Confirmez le nouveau mot de passe',
    109 => 'R�-inscrivez votre nouveau mot de passe',
    110 => 'Mot de passe actuel',
    111 => 'R�-inscrivez votre nouveau mot de passe actuel',
    112 => 'Vous ne semblez pas �tre celui ou celle que vous pr�tendez �tre. Merci de cr�er un nouveau compte ou de r�-essayer plus tard.',
    113 => 'Tentative avort�e',
    114 => 'Compte d�sactiv�',
    115 => 'Votre compte � �t� d�sactiv�, il vous est donc impossible de vous connecter. Merci de contacter un des administrateurs du site.',
    116 => 'Votre compte est en attente d\'activation',
    117 => 'Votre compte est en attente d\'activation, il doit �tre approuv� par un admistrateur. Vous ne pourrez y acc�der avant son activation.',
    118 => '',
    119 => '',
    120 => 'Compte activ�',
    121 => 'Service',
    122 => 'D�sol�, mais nous n\'acceptons pas de nouveaux membres en ce moment.',
    123 => "Vous pouvez aussi <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">cr�er un nouveau compte</a>.",
    124 => 'Confirmez votre email',
    125 => 'Vous avez inscrit la m�me adresse couriel dans les deux champs !',
    126 => 'Pri�re de r�p�ter pour confirmer',
    127 => 'Mot de passe requis pour effectuer des changements.',
    128 => 'Votre nom',
    129 => 'Mot de passe et email',
    130 => 'A propos de vous',
    131 => 'Options du r�sum� quotidien',
    132 => 'Fonction de r�sum� quotidien',
    133 => 'Affichage des commentaires',
    134 => 'Options des commentaires',
    135 => '<li>Mode d\'affichage des commentaires par d�faut</li><li>Ordre d\'affichage des commentaires par d�faut</li><li>R�glage du maximum de commentaires � afficher - 100 par d�faut</li>',
    138 => 'Autres r�glages',
    139 => 'Th�mes et langues',
    140 => '<li>N\'affiche pas les icons des cat�gories si coch�</li><li>N\'affiche pas les blocks si coch� - seulement le menu admin, le menu utilisateur et les cat�gories<li>S�lectionnez le nombre maximum d\'articles � afficher</li><li>S�lectionnez votre th�me et l\'affichage de la date pr�f�r�s.</li>',
    141 => 'Vie priv�e',
    142 => 'Par d�faut, les utilisateurs et les administrateurs peuvent vous envoyer des emails et voir si vous �tes en ligne. D�selectionnez ces options si vous pr�f�rez.',
    145 => 'Votre profil public',
    146 => 'Mot de passe et email',
    147 => 'Editez votre mot de passe, votre email ou la fonction auto login. Vous devrez inscrire votre mot de passe ou votre email deux fois pour le confirmer.',
    148 => 'Informations d\'utilisateur',
    149 => 'Modifiez les informations personnelles que les autres pourront voir.<li>La signature sera ajout�e � toutes vos interventions sur ce site.</li><li>La BIO est une courte description de vous-m�me que vous d�sirez partager avec les autres.</li><li>Partage de votre cl� PGP</li>',
    150 => '',
    156 => 'Effacer mon compte',
    157 => 'Suppression du compte (Attention fonction irr�versible)',
    158 => 'Time Zone',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'sera r�duite',
    162 => 'ne sera pas r�duite',
    163 => 'La r�authentification a �chou�e',
    164 => 'Vous avez d�pass� le nombre maximum de r�authentification. D�sol�, l\'op�ration a �t� annul�e et votre modifications ont �t� perdues.',
    165 => 'Utiliser l\�diteur avanc�',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    169 => 'User has updated his/her profile',
    170 => "Admin at {$_CONF['site_name']} changed the password of your account as follows.  Please save this mail for further reference.",
    171 => 'Post mode for "Signature" and "Bio".',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_remote_login_desc_long' => 'Click on one of the button(s) below to login and/or register via an account you have on another supported remote service. Please note, you must have an account on the remote service. If you are creating a new account on this website, then the remote service may ask you to give this website permissions to access information like your name, email address, and profile photo.',
    'remote_register_instructions' => "<strong>Please note:</strong> To register and create an account via Remote Login, please visit the <a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">User Login</a>.",
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?",
    'user_max_login_attempts' => 'Max Login Attempts and Speed Limit Reached',
    'tfa_two_factor_auth' => 'Two Factor Authentication',
    'tfa_help1' => 'Make sure to install "Google Authenticator" application on your mobile device before you enable Two Factor Authentication.',
    'tfa_help2' => 'Enable Two Factor Authentication.',
    'tfa_help3' => 'Run "Google Authenticator", tap on the plus icon and scan the QR code.',
    'tfa_help4' => 'Print or download the backup codes below in case you cannot use your mobile device you installed the Google Authenticator.  Each backup code is valid only one-time.  If you generate a new set of backup codes, then the current set will be invalid.',
    'tfa_help5' => 'Hit the "Save" button at the bottom of the screen.',
    'tfa_enter_code' => 'Enter the %d-digit code your Google Authenticator app is showing or one of the backup code you have got in your preference page.',
    'tfa_backup_code_desc' => 'Note: You can only use a backup code once, then it becomes invalid. Remember to generate more backup codes from the user preference page if you are getting low.',
    'tfa_code' => 'Google Authenticator Code',
    'tfa_authenticate' => 'Authenticate',
    'tfa_qrcode' => 'QR Code',
    'tfa_show_hide' => 'Show/Hide',
    'tfa_backup_code' => 'Backup Codes',
    'tfa_download' => 'Download Backup Codes',
    'tfa_new_backup_code' => 'Generate a new set of backup codes',
    'tfa_generate_confirm' => 'Go ahead?',
    'lang_tfa_user_edit_desc' => 'You are only allowed to disable Two Factor Authentication (2FA) from this form if needed (like the user does not have their backup codes). It should not be enabled by Admins as the user themselves are required to enable and setup 2FA from their Account, including the Google Authenticator App for their phone and coping the backup codes.',
    'desc_new_pwd_status' => 'You are required to enter a new password for your account. You can enter a new password for your account below. <em>Please note you will not be able to do anything with your account until your password is updated.</em>',
    'new_email' => 'New Email',
    'set_new_email' => 'Set New Email',
    'confirm_new_email' => 'Confirm new email',
    'enter_new_email' => 'Enter New Email',
    'desc_new_email_status' => 'You are required to enter a new email address for your account. You can enter a new email for your account below. <em>Please note you will not be able to do anything with your account until your email is updated and verified.</em>',
    'email_msg_email_status_1' => "You have updated your email address for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nPlease click on the following link to verify this email address:\n\n",
    'email_msg_verify' => 'Please click on the following link to verify this email address:',
    'email_msg_email_status_2' => "If you do not verify this email address and you log into your account you will be required to enter a new email address and go through this email verification process again.\n\n",
    'email_verify' => 'New Email to be Verified',
    'email_verify_delete' => 'Delete email to be verified',
    'email_verify_msg' => "You have previously updated your email address for your account but it still needs to be verified. Please check your email account for an email from {$_CONF['site_name']} that contains a verification link. Once you click on that link your new email address will be verified and your account will be updated to use it.<br" . XHTML . "><br" . XHTML . ">If you wish you may update the new email to be verified with the email fields above or you can delete it.",
    'remove_account_msg' => 'To remove your account from our database, enter your current password into the above "Current Password", check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'remove_remote_account_msg' => 'To remove your remote account from our database, check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'theme_info' => '%1$s %2$s (requires Geeklog %3$s)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Aper�u',
    'pe_namepass' => 'Nom &amp; mot de passe',
    'pe_userinfo' => 'Bio',
    'pe_layout' => 'Th�me &amp; Langue',
    'pe_content' => 'Contenu',
    'pe_privacy' => 'Vie priv�e'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Aucun article � afficher',
    2 => 'Il n\'y a pas de nouveaux articles � afficher. Il n\'y a peut-�tre pas de nouveaut�s pour cette cat�gorie ou alors vos pr�f�rences sont trop restrictives.',
    3 => '',
    4 => 'Article du jour',
    5 => 'Suivant',
    6 => 'Pr�c�dent',
    7 => 'Premier',
    8 => 'Dernier',
    9 => 'Page navigation'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Une erreur s\'est produite lors de l\'envoi de votre message. Veuillez r�essayer.',
    2 => 'Message a �t� envoy� avec succ�s.',
    3 => 'V�rifiez que l\'adresse du champ &laquo;r�pondre �&raquo; est valide.',
    4 => 'Veuillez compl�ter les champs: &laquo;Votre nom&raquo;, &laquo;r�ponse �&raquo;, &laquo;sujet&raquo; et &laquo;message&raquo;',
    5 => 'Erreur: membre inconnu.',
    6 => 'Il y a eu une erreur.',
    7 => 'Profil membre de ',
    8 => 'Nom de connexion',
    9 => 'URL membre',
    10 => 'Envoyer un email �',
    11 => 'Votre nom :',
    12 => 'Votre email :',
    13 => 'Sujet :',
    14 => 'Message :',
    15 => 'Les balises HTML ne seront pas traduites.',
    16 => 'Envoyer Message',
    17 => 'Envoyer cet article � un ami',
    18 => 'Pour',
    19 => 'Adresse email',
    20 => 'De',
    21 => 'Adresse email',
    22 => 'Tous les champs sont obligatoires',
    23 => "Ce email vous a �t� envoy� de la part de %s at %s car il pensait que vous pourriez tre int�ress� par {$_CONF['site_url']}. Ce n'est pas un SPAM et l'adresse email utilis�e n'est pas stok�e dans une liste d'envoi.",
    24 => 'Commentaire sur cet article �',
    25 => 'Vous devez tre connect� pour utiliser cette fonction. Votre identification permettra de contr�ler tout abus du syst�me',
    26 => 'Ce formulaire vous permet d\'envoyer un email. Tous les champs sont obligatoires.',
    27 => 'Message court',
    28 => '%s a �crit: ',
    29 => "Bonjour. Voici le(s) dernier(s) article(s) publi�(s) sur {$_CONF['site_name']} le ",
    30 => ' Lettre d\'information du ',
    31 => 'Titre',
    32 => 'Date',
    33 => 'Lire l\'article complet : ',
    34 => 'Fin du message',
    35 => 'D�sol�, ce membre ne d�sire pas recevoir de messages.',
    36 => 'Copie :',
    37 => 'Envoyez moi un double de cet email',
    38 => "Ceci est une copie du message que vous avez envoy� � %s du site <{$_CONF['site_url']}> :",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages",
    41 => 'This user doesn\'t exist.',
    42 => 'This users email address doesn\'t exist. This most likely means is is an OAuth user account.',
    43 => 'This users email address is invalid.',
    44 => 'This users status is set to something other than Active or New Password therefore the email address is assumed bad.',
    45 => "This is a message sent from {$_CONF['site_name']} by %s. Any replies will need to be sent to the email address: %s",
    46 => "To unsubscribe from the Daily Digest, login to {$_CONF['site_name']} at {$_CONF['site_url']}. Then visit the user settings page at {$_CONF['site_url']}/usersettings.php and view the Content Tab. You can then unsubscribe to the Daily Digest by deselecting all topics and saving your profile."
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Recherche avanc�e',
    2 => 'Mots cl�s',
    3 => 'Sujet',
    4 => 'Tous',
    5 => 'Type',
    6 => 'Articles',
    7 => 'Commentaires',
    8 => 'Auteurs',
    9 => 'Tous',
    10 => 'Recherche',
    11 => 'R�sultats de recherche',
    12 => 's�lections',
    13 => 'Aucun r�sultats n\'a �t� trouv�',
    14 => 'Aucun r�sultat ne correspond � vos crit�res',
    15 => 'Veuillez r�essayer.',
    16 => 'Titre',
    17 => 'Date',
    18 => 'Auteur',
    19 => "Chercher dans toute la base de donn�es de {$_CONF['site_name']}.",
    20 => 'Date',
    21 => '�',
    22 => '(Format des dates AAAA-MM-JJ)',
    23 => 'Actions',
    24 => 'Trouv� %d items',
    25 => 'R�sultats pour',
    26 => 'Items',
    27 => 'secondes',
    28 => 'Il n\'y a pas d\'articles ou de commentaires correspondant � vos crit�res',
    29 => 'Articles et commentaires trouv�s',
    30 => '',
    31 => 'Aucun lien trouv� pour ce plugin',
    32 => '',
    33 => 'URL',
    34 => 'Localisation',
    35 => 'Tous les jours',
    36 => 'Key Word Type',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Votre sujet de recherche devrait comporter au moins 3 caract�res.',
    42 => 'Pri�re d\'utiliser une date exprim�e comme suit: AAAA-MM-JJ (ann�e-mois-jour).',
    43 => 'Phrase exacte',
    44 => 'Tous ces mots',
    45 => 'N\'importe quel mot',
    46 => 'Suivant',
    47 => 'Pr�c�dant',
    48 => 'Auteur',
    49 => 'Date',
    50 => 'Clics',
    51 => '',
    52 => 'Localisation',
    53 => 'R�sultats d\'articles',
    54 => 'R�sultats de commentaires',
    55 => 'la phrase',
    56 => 'ET',
    57 => 'OU',
    58 => 'Plus de r�sultats &gt;&gt;',
    59 => 'R�sultats',
    60 => 'par page',
    61 => 'Recherche �tendue',
    62 => '#',
    63 => 'Description',
    64 => 'Liste %1$d - %2$d de %3$d r�sultats',
    65 => 'Article',
    66 => 'Commentaire',
    67 => 'Montrez %d r�sultats',
    68 => 'Ordonn�s par',
    69 => 'Titres uniquement',
    70 => 'Information non disponible...',
    71 => 'asc',
    72 => 'desc',
    73 => 'Submit',
    74 => 'Limit Results'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistiques du site',
    2 => 'Nombre de hits sur le site',
    3 => 'Nombre d\'articles (et commentaires)',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => 'Top-10 des articles les plus regard�s',
    8 => 'Titre d\'article',
    9 => 'Pages regard�es',
    10 => 'Soit il n\'y a pas d\'article sur ce site, soit ils n\'ont pas �t� regard�s',
    11 => 'Top-10 des articles les plus comment�s',
    12 => 'Commentaires',
    13 => 'Soit il n\'y a pas d\'article sur ce site, soit aucun commentaires n\'a encore �t� fait.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top-10 des articles les plus envoy�s par email',
    23 => 'emails',
    24 => 'Personne n\'a encore envoy� d\'article par email',
    25 => 'Top-10 des meilleurs Trackbacks comment�s',
    26 => 'Personne n\'a encore comment� un Trackback',
    27 => 'Nombre d\'utilisateurs actifs',
    28 => '',
    29 => '',
    30 => 'Clics',
    31 => '',
    32 => 'Top Ten Liked Articles',
    33 => 'No liked articles found.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Ressources',
    2 => 'Envoyer cet article � un ami',
    3 => 'Version imprimable',
    4 => 'Options',
    5 => '',
    6 => 'Souscrire � \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Pour envoyer un %s vous devez vous identifier comme membre.',
    2 => 'Vous connectez',
    3 => 'Nouveau membre',
    4 => '',
    5 => '',
    6 => 'Soumettre un article',
    7 => 'Identification requise',
    8 => 'Envoyer',
    9 => 'Merci de compl�ter tous les champs et de v�rifier votre saisie avant d\'envoyer votre proposition.',
    10 => 'Titre',
    11 => '',
    12 => 'D�but',
    13 => 'Fin',
    14 => 'Localisation',
    15 => 'Description',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Note d\'information',
    20 => '',
    21 => '',
    22 => 'Erreur: champs manquants',
    23 => 'Veuillez compl�ter tous les champs du formulaire. Ils sont tous obligatoires.',
    24 => 'Proposition enregistr�e',
    25 => 'Vos propositions %s ont �t� sauvegard�es avec succ�s.',
    26 => 'Limitation',
    27 => 'Membre',
    28 => 'Sujet',
    29 => 'Article',
    30 => 'Votre derni�re proposition �tait il y a',
    31 => " secondes. Vous devez attendre au moins {$_CONF['speedlimit']} secondes entre chaque propositions",
    32 => 'Aper�u',
    33 => 'Aper�u de l\'article',
    34 => 'Se d�connecter',
    35 => 'Les balises HTML ne sont pas accept�es',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresse (ligne 1)',
    45 => 'Adresse (ligne 2)',
    46 => 'Ville',
    47 => 'R�gion',
    48 => 'Code postal',
    49 => '',
    50 => '',
    51 => 'Localisation',
    52 => 'Supprimer',
    53 => 'Cr�er un compte',
    54 => 'Introduction',
    55 => 'Corps'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => 'Like',
    'unlike' => 'Unlike',
    'dislike' => 'Dislike',
    'undislike' => 'Undislike',
    'likes' => 'Likes',
    'unlikes' => 'Unlikes',
    'dislikes' => 'Dislikes',
    'undislikes' => 'Undislikes',
    'i_like_this' => 'I like this',
    'i_dislike_this' => 'I dislike this',
    'thanks_for_action' => 'Thanks for voting!',
    'likes_speedlimit' => 'You last used the Likes system on an item %s seconds ago. This site requires at least %s seconds between using the Likes system',
    'likes_ip_error' => 'Your IP address has already performed this Likes action.',
    'likes_uid_error' => 'Your User account has already performed this Likes action.',
    'own_item_error' => 'Either you own the item or do not have permission to Like/Dislike it.',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s Anonymous Users',
    'one_anon_users' => '<br' . XHTML . '>1 Anonymous User',
    'num_more_users' => '<br' . XHTML . '>+%s more Users',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Displays the Likes block. No attributes are required. If attribute not specified then default in configuration used. 
\n	- action = 1 (likes only), 2 (dislikes only), or 3 (both) 
\n	- wrapper = 0 (no wrapper), 1 (block wrapper with title), div wrapper with css class), or both
\n	- class = Specifies the css class used by the div wrapper if enabled else default likes-autotag will be used 
\n	- type = Either empty (for all types) or include 1 supported like type. For example 'article' or 'comment'
\n	- subtype = Specify a sub type of type if needed
\n	- time = Display items that are this many seconds old. 0 will display all items
\n	- max = Maximum number of items to display
\n	- cache = Cached for no longer than this many seconds. If 0 caching is disabled
\n	- line = Display likes icons on new line
\n	- length = Trim item title length to this many characters",
    'num_likes_in_time_limit' => 'The last number of Likes this item received within the time specified.',
    'num_dislikes_in_time_limit' => 'The last number of Dislikes this item received within the time specified.',
    'num_likes_total' => 'The total number of Likes this item has received.',
    'num_dislikes_total' => 'The total number of Dislikes this item has received.',
    'likes_time_span' => 'Most Likes in the last %t %s',
    'dislikes_time_span' => 'Most Dislikes in the last %t %s',
    'all_time_span' => 'Most engaging in the last %t %s',
    'whats_liked' => 'Whats Liked',
    'whats_recently_liked' => 'Whats Recently Liked',
    'whats_disliked' => 'Whats Disliked',
    'whats_recently_disliked' => 'Whats Recently Disliked',
    'whats_popular' => 'Whats Popular',
    'whats_recently_popular' => 'Whats Recently Popular',
    'whats_liked_type' => 'Liked %s',
    'whats_recently_liked_type' => 'Recently Liked %s',
    'whats_disliked_type' => 'Disliked %s',
    'whats_recently_disliked_type' => 'Recently Disliked %s',
    'whats_popular_type' => 'Popular %s',
    'whats_recently_popular_type' => 'Recently Popular %s',
    'no_liked_items_in_time_limit' => 'There have been no Likes during the time specified.',
    'no_disliked_items_in_time_limit' => 'There have been no Dislikes during the time specified.',
    'no_action_items_in_time_limit' => 'There have been no Likes or Dislikes during the time specified.',
    'no_liked_items' => 'There are no Liked items.',
    'no_disliked_items' => 'There are no Disliked items.',
    'no_action_items' => 'There are no Liked or Disliked items.',
    'last_num_likes_by' => 'Last %s Likes and Dislikes by %s',
    'msg_no_likes' => 'No likes or dislikes found by user.',
    'total_num_likes' => 'Total number of likes and dislikes:',
    'title_liked' => '%s Liked on ',
    'title_disliked' => '%s Disliked on ',
    'articles' => 'Articles',
    'comments' => 'Comments'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'fileinfo_library' => 'Fileinfo Library',
    'fileinfo_ok' => 'The Fileinfo library is loaded. This library is required when uploading images for articles. It is used to get the mime type of the file being uploaded when creating a thumbnail of the image.',
    'fileinfo_not_found' => 'The Fileinfo library is not loaded. This is required <strong>only</strong> when uploading images in the article editor.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'database_settings' => 'Database Settings',
    'database_mysql_version' => 'MySQL Version',
    'database_mysql_req_version' => 'Geeklog requires MySQL version 4.1.2 or newer (MySQL 5 recommended).',
    'database_pgsql_version' => 'Postgresql Version',
    'database_pgsql_req_version' => 'Geeklog requires Postgresql version 9.1.7 or newer.',
    'database_dms' => 'Database Management System',
    'database_dms_notes' => 'Failed to determine Database Management System. Geeklog requires either MySQL or Postgresql',
    'php_req_version' => 'Geeklog requires PHP version 5.6.4 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.',
    'phpinfo_disabled' => 'In order to view the current php settings, you will have to contact your host and enable access to the phpinfo() function.'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'Header',
    'subject' => 'Subject:',
    'to' => 'To:',
    'from' => 'From:',
    'priority' => 'Priority:',
    'body' => 'Body',
    'notice' => 'Notice',
    'emails_disabled_msg' => 'Please note sending emails is disabled in Demo mode. An email which would have been sent was:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Identification requise',
    2 => 'Utilisateur ou mot de passe incorrect',
    3 => 'Mot de passe incorrect',
    4 => 'Nom de membre:',
    5 => 'Mot de passe:',
    6 => 'Cette page est r�serv�e aux membres du site. Merci de vous identifier pour continuer.',
    7 => 'Connexion',
    8 => 'Login',
    9 => 'This page is for the use of authorized personnel only. Please note all access to administrative portions of this web site are logged and reviewed.'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Droits insuffisants',
    2 => 'Vous n\'avez pas les droits n�cessaires pour modifier ce block',
    3 => 'Editeur de block',
    4 => 'Un probl�me est survenu � la lecture de cet envoi. Voir error.log.',
    5 => 'Yes',
    6 => 'No',
    7 => 'Tous',
    8 => 'niveau de s�curit� du block',
    9 => 'Ordre du block',
    10 => '',
    11 => 'Block Portail',
    12 => 'Block Normal',
    13 => 'Block portail d\'option',
    14 => 'URL RDF',
    15 => 'Derni�re MAJ RDF',
    16 => 'Block normal d\'option',
    17 => 'Contenu du block',
    18 => 'Veuillez remplir les champs: titre, niveau de s�curit� et contenu du block',
    19 => 'Contr�leur de block',
    20 => 'Regular Blocks',
    21 => 'Block niv. sec.',
    22 => 'Dynamic Blocks',
    23 => 'Block ordre',
    24 => 'Dynamic',
    25 => 'Cliquez sur le lien ci-dessous pour modifier ou supprimer un block.  Cliquez sur le lien "Ajouter" pour cr�er un nouveau block.',
    26 => 'Block d\'affichage',
    27 => 'Block PHP',
    28 => 'Option du block PHP',
    29 => 'Block fonction',
    30 => 'Si vous voulez que l\'un de vos blocks utilise du PHP, saisissez le nom de la fonction � utiliser.  Le nom de la fonction doit commencer par \'phpblock_\' (ex: phpblock_getweather).  Si ce n\'est pas le cas, votre fonction NE SERA PAS appell�e, ceci pour des raisons de s�curit�.  Ne mettez pas de parenth�ses vides \'()\' apr�s le nom de votre fonction.  Enfin, nous vous recommandons de mettre tout le code des block PHP dans /path/to/geeklog/system/lib-custom.php.  Cela permettera de garder votre code m�me apr�s une mise � jour du syst�me.',
    31 => 'Erreur dans le block PHP.  La fonction, %s, n\'existe pas.',
    32 => 'Erreur: champs manquant',
    33 => 'Vous devez mettre l\'URL dans le fichier .rdf pour le block portail.',
    34 => 'Vous devez renseigner le titre et la fonction du block PHP.',
    35 => 'Vous devez entrer le titre et le contenu du block normal.',
    36 => 'Vous devez entrer le contenu pour le block d\'affichage.',
    37 => 'Nom erron� dans la fonction du block PHP',
    38 => 'Les fonctions des blocks PHP doivent commencer par "phpblock_" (ex: phpblock_getweather).  Le pr�fixe "phpblock_" est n�cessaire pour des raisons de s�curit� qui empche l\'ex�cution de code arbitraire.',
    39 => 'C�t�',
    40 => 'Gauche',
    41 => 'Droit',
    42 => 'Vous devez saisir l\'ordre et le niveau de s�curit� pour les blocks par d�faut du syst�me',
    43 => 'Accueil seulement',
    44 => 'Multiple',
    45 => "Vous essayez d'acc�der � un block auquel vous n'avez pas droit.  Cette tentative est enregistr�e. Veuillez <a href=\'{$_CONF['site_admin_url']}/block.php\'>retourner � la page de contr�le des blocks</a>.",
    46 => 'Position',
    47 => 'None',
    48 => 'Nom du block',
    49 => ' (Pas d\'espace et doit �tre unique)',
    50 => 'The Block Name can not be empty',
    51 => 'inclure http:// ',
    52 => 'Laisser vide pour ne pas afficher l\'icone d\'aide',
    53 => 'Activ�',
    54 => 'enregistrer',
    55 => 'annuler',
    56 => 'supprimer',
    57 => 'Bougez le block vers le bas',
    58 => 'Bougez le block vers le haut',
    59 => 'Bougez le block vers la droite',
    60 => 'Bougez le block vers la gauche',
    61 => 'Sans titre',
    62 => 'Article limit� �',
    63 => 'Nom de block non-valide',
    64 => 'Il doit y avoir un titre. Le code HTML est interdit!',
    65 => 'Ordre',
    66 => 'Autotags',
    67 => 'V�rifiez si vous acceptez les autotags',
    68 => 'Le flux de ce site est trop long. Merci de pr�ciser un nombre d\'articles maximum � importer (r�glage du block ou configuration principale).',
    69 => 'Plugin Name',
    70 => 'CSS ID',
    71 => 'This field is optional',
    72 => 'CSS Classes',
    73 => 'This field is optional.  You can specify multiple classes separated by space',
    'autotag_desc_block' => '[block:name class:block-autotag] - Displays a block. Class not required. Class specifies the css class and will wrap the block in a div. The class block-autotag will always be included with the div.',
    'newlines' => 'Newlines',
    'convert_newlines' => 'Check to convert newlines (EOL) into line break HTML element',
    'position' => 'Position',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)',
    'block_type_gldefault' => 'System',
    'block_type_normal' => 'Normal',
    'block_type_phpblock' => 'PHP',
    'block_type_portal' => 'Portal',
    'block_type_dynamic' => 'Dynamic'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => 'Article Footer',
    'blocks_article_footer_desc' => 'Display Blocks in article Footer',
    'blocks_article_topic_list_name' => 'Article Topic List',
    'blocks_article_topic_list_desc' => 'Displays Blocks right after every X number of articles in topics.'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => 'Articles pr�c�dents',
    2 => 'Articles suivants',
    3 => 'Mode',
    4 => 'Format',
    5 => 'Editeur d\'articles',
    6 => 'Il n\'y a pas d\'articles dans le syst�me',
    7 => 'Auteur',
    8 => 'Enregistrer',
    9 => 'Pr�-visualisation',
    10 => 'Annuler',
    11 => 'Supprimer',
    12 => 'Num�ro',
    13 => '',
    14 => '',
    15 => 'Date',
    16 => 'Texte d\'intro',
    17 => 'Corps',
    18 => 'Clics',
    19 => 'Commentaires',
    20 => 'Ping',
    21 => 'Envoyez un ping',
    22 => 'Liste des articles',
    23 => 'Pour modifier ou supprimer un article, cliquez sur son num�ro. Pour visionner un article, cliquez sur le titre de l\'article. Pour cr�er un nouvel article, cliquez sur le bouton "Ajouter".',
    24 => 'Le num�ro choisi pour cet article est d�j� utilis�. Merci d\'en choisir un autre.',
    25 => 'Une erreur s\'est produite lors de la sauvegarde',
    26 => 'Aper�u de l\'article',
    27 => 'Si vous utilisez [unscaledX] au lieu de [imageX], votre image appara�tra dans ses dimensions originales.',
    28 => '<p><b>Pr�-visualisation</b>: La pr�-visualisation d\'un article pourvu d\'images est possible si on le sauvegarde comme brouillon AU LIEU DE le pr�-visualiser. Ne pr�-visualisez qu\'en absence d\'image.',
    29 => 'Trackback',
    30 => 'Erreur de sauvegarde',
    31 => 'Veuillez inscrire le titre et le texte d\'introduction.',
    32 => 'En vedette',
    33 => 'Il ne peut y avoir qu\'un seul article mis en vedette',
    34 => 'Brouillon',
    35 => 'Oui',
    36 => 'Non',
    37 => 'Autres articles de',
    38 => 'Autres articles sur',
    39 => 'emails',
    40 => '',
    41 => "Vous essayez d'acc�der � un article auqule vous n'avez pas droit.  Cette tentative est enregistr�e.  Vous pouvez voir cet article en lecture seule uniquement. Veuillez <a href=\'{$_CONF['site_admin_url']}/article.php\'>retourner sur la page de contr�le des article</a> lorsque vous aurez fini.",
    42 => "Vous essayez d'acc�der � un article auquel vous n'avez pas droit.  Cette tentative est enregistr�e.  Veuillez <a href=\'{$_CONF['site_admin_url']}/article.php\'>retourner � la page de contr�le des articles</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>REMARQUE:</b> si vous indiquez une date future, cet article n\'appara�tra qu\'� partir de cette date. Cela signifie aussi que l\'article sera ignor� des recherches et des statistiques.',
    47 => 'Images',
    48 => 'image',
    49 => 'droite',
    50 => 'gauche',
    51 => 'Pour ajouter une des images que vous avez fournies vous devez ins�rer un texte sp�cial dans votre article. Vous devez ins�rer [imageX], [imageX_right] ou [imageX_left] o&ugrave; X est le num�ro de l\'image que vous avez fournie.  REMARQUE: vous devez utiliser toutes les images fournies.  Si vous ne le faites pas vous ne pourrez pas enregistrer votre article.<BR><P><B>APERCU</B>: lors de l\'utilisation d\'images il est pr�f�rables de faire un brouillon plut�t que d\'utiliser la fonction d\'apercu.  Utilisez le bouton d\'apercu uniquement lorsqu\'il n\'y a pas d\'image.',
    52 => '',
    53 => 'n\'est pas utilis�e.  Vous devez ins�rer l\'image dans le texte de votre article avant de l\'enregistrer.',
    54 => 'Image fournie non utilis�e',
    55 => 'L\'erreur suivante est apparue lors de l\'enregistrement de votre article.  Veuillez corriger ces erreurs et r�essayer',
    56 => 'Montrer l\'icon',
    57 => 'Montrer l\'image originale',
    58 => 'Gestion des articles',
    59 => 'Option',
    60 => '',
    61 => 'Auto-archiv�',
    62 => 'Auto-effac�',
    63 => 'D�sactiver les commentaires',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Augmentez le contenu en r�visant la taille de l\'article',
    68 => 'R�duisez le contenu en r�visant la taille de l\'article',
    69 => 'Date de l\'article',
    70 => 'S�lectionnez une barre d\'outils',
    71 => 'Barre d\'outils de base',
    72 => 'Barre d\'outils normale',
    73 => 'Barre d\'outils avanc�e',
    74 => 'Barre d\'outils experte',
    75 => 'Toutes les options',
    76 => 'Options de publication',
    77 => 'L\'option Javascript est n�cessaire pour que cet �diteur fonctionne. Cette option peut-tre d�sactiv�e dans config.php',
    78 => 'Cliquez <a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">ici</a> pour utiliser l\'�diteur par d�faut',
    79 => 'Pr�vision',
    80 => 'Edition',
    81 => 'Options de publication',
    82 => 'Images',
    83 => 'Options d\'archive',
    84 => 'Permissions',
    85 => 'Montrez tout',
    86 => 'Edition avanc�e',
    87 => 'Statistiques',
    88 => 'Format Wiki-style',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'Vous pouvez toujours utiliser le "Preview" pour prolonger le d�lai de p�remption.',
    92 => 'You might also like',
    93 => '#',
    94 => 'Resized',
    95 => 'Original',
    96 => 'Upload | Replace',
    97 => 'No Image',
    'autotag_desc_story' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'autotag_desc_article' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Editeur de cat�gories',
    2 => 'Num�ro',
    3 => 'Nom',
    4 => 'Image',
    5 => '(Ne pas utiliser d\'espaces)',
    6 => 'Supprimer une cat�gorie supprimera tous les articles et blocks en relations avec celle-ci',
    7 => 'Veuillez renseigner le num�ro et le nom de la cat�gorie.',
    8 => 'Contr�leur de cat�gorie',
    9 => 'Cliquez sur une cat�gorie pour la modifier ou la supprimer.  Cliquez sur &laquo;Ajouter&raquo; pour cr�er une nouvelle cat�gorie. Vos droits d\'acc�s concernant toutes les cat�gories apparaissant entre parenth�ses.',
    10 => 'Ordre de tri',
    11 => 'Articles/Page',
    12 => 'Acc�s r�serv�',
    13 => "Vous ne pouvez pas �diter cette cat�gorie. Veuillez <a href=\"{$_CONF['site_admin_url']}/topic.php\">retourner � la page de contr�le des cat�gories</a>.",
    14 => 'M�thode de tri',
    15 => 'alphab�tique',
    16 => 'par d�faut:',
    17 => 'Nouvelle cat�gorie',
    18 => 'Accueil Admin',
    19 => 'Enregistrer',
    20 => 'Annuler',
    21 => 'Supprimer',
    22 => 'Par d�faut',
    23 => 'Faites de cette cat�gorie le choix par d�faut pour la cr�ation de nouveaux articles',
    24 => '(*)',
    25 => 'Archivez la cat�gorie',
    26 => 'Faites-en la cat�gorie par d�faut pour vos archives. Une seule cat�gorie est admise',
    27 => 'Ou alors t�l�chargez votre icon pour cette cat�gorie',
    28 => 'Maximum',
    29 => 'Erreur de t�l�chargement',
    30 => 'Articles dans la cat�gorie',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics' => 'Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics_disabled' => 'Else you must select at least one topic you have edit access for, to assign the item to (text is darker). ',
    'topic_control_no_topics' => 'Unfortunately you do not have edit access to any topics so none can be selected. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Article',
    53 => 'Image',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:',
    'topic_title' => 'Topic Title',
    'topic_title_desc' => 'Used as the page title for the topic. If empty the topic name will be used.',
    'move_topic_up' => 'Move topic up the sort order',
    'move_topic_down' => 'Move topic down in the sort order',
    'topics_edit_access_select' => 'You can only select topics you have Edit access to you (text is darker).',
    'topics_edit_access_listed' => 'Only topics with Edit access are listed.'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Edition des donn�es du membre',
    2 => 'ID',
    3 => 'Nom de connexion',
    4 => 'Nom complet',
    5 => 'Mot de passe',
    6 => 'Niveau de s�curit�',
    7 => 'Adresse email',
    8 => 'Page d\'accueil',
    9 => '(Ne pas utiliser d\'espaces)',
    10 => 'Veuillez renseigner le nom de connexion, le nom complet, le nom complet et l\'adresse email.',
    11 => 'Contr�leur des membres',
    12 => 'Cliquez sur un membre pour le modifier ou le supprimer.  Cliquez sur Ajouter pour cr�er un compte. Vous pouvez faire des recherches simple en entrant une partie du nom de connexion, du nom complet ou de l\'adresse email dans le formulaire ci-dessous.',
    13 => 'Niv. Sec.',
    14 => 'Date d\'enregistrement',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'Enregistrer',
    21 => 'Le nom de connexion est d�j� utilis�.',
    22 => 'Erreur',
    23 => 'Ajout par lot',
    24 => 'Importation par lot d\'utilisateurs',
    25 => 'Vous pouvez importer un lot d\'utilisateur dans le syst�me.  Les champ du fichier d\'import doivent tre s�par�s par une tabulation. Ils doivent appara�tre dans l\'ordre suivant: Nom complet, nom de connexion, adresse email.  Chaque utilisateur import� sera averti par email et aura un mot de passe auto-g�n�r�.  Il ne doit y avoir qu\'un seul utilisateur par ligne.  Ne pas respecter ces consignes peut entra�ner des d�gat qui ne seront r�parables que manuellement, alors redoublez de vigilance!',
    26 => '',
    27 => '',
    28 => 'Cocher la case pour supprimer la photo',
    29 => 'Chemin',
    30 => 'Importer',
    31 => 'Nouveaux membres',
    32 => 'Traitement termin�. %d membres ont �t� import�s et il y a %d erreurs',
    33 => 'envoyer',
    34 => 'Erreur: Vous devez pr�ciser un fichier � t�l�charger.',
    35 => 'Dernier acc�s',
    36 => '(jamais)',
    37 => 'UID',
    38 => 'Liste group�e',
    39 => 'Mot de passe (encore)',
    40 => 'Date d\'enregistrement',
    41 => 'Date du dernier acc�s',
    42 => 'Banni',
    43 => 'En attente d\'activation',
    44 => 'En attente d\'autorisation',
    45 => 'Activ�',
    46 => 'Statut du membre',
    'user_status_desc' => "An explanation of all possible user statuses: <ul>\n\n        <li><strong>Awaiting Activation</strong> - New account awaiting user to login. Email has been sent but not verified. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Awaiting Authorization</strong> - New account awaiting moderator approval in the User Submission Queue. When User Submission approved, user will be sent email with password. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Active</strong> - This is an Active account.</li>\n\n        <li><strong>Banned</strong> -  This Account is banned/disabled. Username is crossed out on the site for any content they have submitted, User cannot login, emails to account is disabled, and profile cannot be viewed by any user except Admins.</li>\n\n        <li><strong>Locked</strong> - This Account is locked. User cannot login, emails to account is disabled, but profile can still be viewed by all.</li>\n\n        <li><strong>New Email Required</strong> - Emails to account is disabled. When user logs in again they must submit new email address and verify before access to rest of the website (under this user account). Status stays the same until email is verified. If \"Require User Email\" config option true then any users who login (includes remote accounts) that do not have an email address will automatically switch to this status.</li>\n\n        <li><strong>New Password Required</strong> -  When the user logs in they must submit a new password before access to rest of website (under this user account). This is only for regular accounts and not remote accounts.</li>\n\n        </ul>\n\n    ",
    47 => '�ditez',
    48 => 'Montrez les groupes Admin',
    49 => 'Groupe Admin',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Jours en ligne',
    52 => '<br' . XHTML . '>Note: Les "jours en ligne", c\'est le total de jours entre la cr�ation du compte et le dernier acc�s.',
    53 => 'enregistr�',
    54 => 'Batch delete',
    55 => '�a ne fonctionnera seulement que si vous avez le code <code>$_CONF[\'lastlogin\'] = true;</code> dans config.php',
    56 => 'Pri�re de s�lectionner le type d\'utilisateur que vous d�sirez effacer et cliquez sur "Mise � jour de la liste". Ensuite, d�selectionnez les utilisateurs que vous ne d�sirez pas effacer et cliquez sur "Effacer". Merci de noter que si la liste s\'�tend sur plusieurs pages, vous n\'effacerez que les noms pr�sents sur la page actuelle. R�p�tez pour les autres pages.',
    57 => 'Membres fant�me',
    58 => 'Membres de courte dur�e',
    59 => 'Anciens utilisateurs',
    60 => 'Membres il y a plus de ',
    61 => ' mois, mais qui n\'ont jamais acc�d� au service.',
    62 => 'Membres il y a plus de ',
    63 => ' mois, qui ont ensuite acc�d� au syst�me dans les 24 heures, mais qui n\'ont jamais acc�d� au service par la suite.',
    64 => 'Membres qui n\'ont pas acc�d� au service depuis ',
    65 => ' mois.',
    66 => 'Mise � jour de la liste',
    67 => 'Mois depuis enregistrement',
    68 => 'Mois en ligne',
    69 => 'Mois hors-ligne',
    70 => 'n\'ont pu tre effac�s',
    71 => 'effac�s avec succ�s',
    72 => 'Aucun utilisateur s�lectionn�',
    73 => 'tes-vous certain de vouloir effacer TOUS ces utilisateurs ?',
    74 => 'Membres r�cents',
    75 => 'Membres lors des derniers ',
    76 => ' mois',
    77 => 'Email un rappel de connexion aux membres s�lectionn�s',
    78 => 'Envoyez un rappel',
    79 => 'Aucun membre s�lectinn�s pour les rappels',
    80 => 'Les rappels ont bien �t� envoy�s',
    81 => 'Message pour v�rifier votre compte sur %s',
    82 => "Vous n'avez pas acc�dez � votre compte sur le site {$_CONF['site_name']} depuis %s. Il sera d�sactiv� si vous ne vous connectez pas dans les prochains 30 jours.",
    83 => "Votre compte sur le site {$_CONF['site_name']} n'a jamais �t� utilis� depuis sa cr�ation et sera supprim� prochainement si vous ne l'utilisez pas.",
    84 => "Votre nom de login est : %s  pour le site : {$_CONF['site_url']}",
    85 => 'Si vous avez oubli� votre mot de passe, utilisez le lien suivant : %s',
    86 => 'Inclure',
    87 => 'Rappels',
    88 => 'Groupe par d�faut',
    89 => 'Cochez pour que les nouveaux membres fassent partie de ce groupe par d�faut',
    90 => 'Cochez pour placer aussi tous les anciens membres dans ce groupe',
    91 => 'Send password to user',
    92 => 'Only for new users or when changing password for existing user.',
    'convert_remote' => 'Check here to convert from remote to a local account',
    'convert_remote_desc' => 'When a remote account is converted to a local account, a password will be automatically generated. If the account does not have a confirmed email address, the account will be locked after it is converted since the user will have no way of retrieving the password. Once converted and if the account is active and has an email address the user will be emailed the password or they can request the password by using the forget password link from the Login page. For user accounts that do not have an active status and valid email you will have to manually notify the user of the account change and how to login.',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.',
    'USER_ACCOUNT_LOCKED' => 'Locked',
    'USER_ACCOUNT_NEW_EMAIL' => 'New Email Required',
    'USER_ACCOUNT_NEW_PASSWORD' => 'New Password Required'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => 'Valider',
    2 => 'Supprimer',
    3 => 'Modifier',
    4 => 'Profil',
    10 => 'Titre',
    11 => 'D�but',
    12 => 'URL',
    13 => 'Cat�gorie',
    14 => 'Date',
    15 => 'Sujet',
    16 => 'Membre',
    17 => 'Nom Complet',
    18 => 'email',
    34 => 'Commandes et Contr�les',
    35 => 'Soumissions d\'articles',
    36 => 'Soumission de liens',
    37 => 'Author',
    38 => 'Envoyer',
    39 => 'Il n\'y a aucune soumission � administrer pour le moment',
    40 => 'Soumissions des membres',
    41 => 'Soumission des commentaires',
    42 => 'Nom du membre',
    43 => 'Auto-publier les commentaires?',
    44 => 'Results of your moderation',
    45 => 'Approved %1$d items and deleted %2$d items of user submissions.',
    46 => 'User Profile Updated',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.',
    'max_invalid_login' => 'Max Invalid Logins Reached for User',
    'max_invalid_login_msg' => 'This user has reached the maximum number of invalid login attempts () within the specified time limit ( seconds). The last IP to make an invalid login attempt is %s. Either the real user has forgotten the password for their account, or someone else is attempting to guess the password for this user account.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "Envoyer un mail aux membres de {$_CONF['site_name']}",
    2 => 'De',
    3 => 'Adresse de r�ponse',
    4 => 'Sujet',
    5 => 'Message',
    6 => '�:',
    7 => 'Tous les membres',
    8 => 'Admin',
    9 => 'Options',
    10 => 'HTML',
    11 => 'Message urgent!',
    12 => 'Envoyer',
    13 => 'Effacer',
    14 => 'Ignorer les pr�f�rences des membres',
    15 => 'Erreur lors de l\'envoi d\'un message �: ',
    16 => 'Message envoy� avec succ�s �: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Envoyer un autre message</a>",
    18 => 'A',
    19 => 'Remarque: si vous voulez envoyer un message � tous les membres, utilisez le groupe Logged-in Users dans le champ A.',
    20 => "<successcount> messages ont �t� envoy�s avec succ�s et <failcount> n'ont pas pu tre envoy�s.  Vous trouverez le d�tail de chaque tentative ci-dessous.  Vous pouvez �galement <a href=\"{$_CONF['site_admin_url']}/mail.php\">envoyer un autre message</a> ou <a href=\"{$_CONF['site_admin_url']}/moderation.php\">revenir � la page d'administration</a>.",
    21 => '�checs',
    22 => 'Succ�s',
    23 => 'Pas d\'�checs',
    24 => 'Pas de succ�s',
    25 => '-- Choisir un groupe --',
    26 => 'Remplissez tous les champs et choisissez un groupe parmi la liste.',
    27 => 'The following template variables are available in <strong>Subject</strong> and <strong>Message</strong>: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'The address used to send this email is not monitored. Please do not reply to this email.',
    'email_footer_msg_content' => 'If content from the website is displayed in this email, there may be layout changes which result in formatting issues.',
    'ip_address_email' => 'IP address that initiated email:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'L\'installation de plugins peut endommager le syst�me.  Il est important de n\'installer que des plugins approuv�s par <a href=\'https://www.geeklog.net\' target=\'_blank\'>le syst�me</a> car nous les testons sur plusieurs syst�mes. Installer des plugins requiert l\'ex�cution de plusieurs commandes syst�mes qui peuvent poser des probl�mes de s�curit�, particuli�rement si vous utilisez des plugins de provenances inconnues. Vous tes averti des domages que peut causer l\'installation d\'un plugin. En d\'autres termes, vous installez des plugins � vos propres risques. Les instructions d\'installation des plugins sont incluses dans chaque plugin.',
    2 => 'Instructions d\'installation d\'un plugin',
    3 => 'Formulaire d\'installation d\'un plugin',
    4 => 'Fichier du plugin',
    5 => 'Liste des plugins',
    6 => 'Attention: plugin d�j� install�!',
    7 => 'Le plugin que vous essayez d\'installer existe d�j�.  Veuillez supprimer le plugin avant de le r�installer.',
    8 => 'Test de compatibilit� du plugin �chou�',
    9 => 'Ce plugin requiert une version plus r�cente du syst�me. Vous pouvez mettre � jour votre <a href=\'https://www.geeklog.net\'>syst�me</a> ou obtenir une autre version du plugin.',
    10 => '<br' . XHTML . '><b>Aucun plugin n\'est actuellement install�.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Cliquez sur le num�ro du plugin pour le modifier ou le supprimer. Pour en savoir d\'avantage sur les plugins, cliquez sur le nom du plugin et vous serez redirig� vers le site web du plugin. Pour installer ou mettre � jour un plugin veuillez vous r�f�rer � la documentation du plugin.',
    12 => 'Aucun nom de plugin n\'a �t� pass� � plugineditor()',
    13 => 'Editeur de plugin',
    14 => 'Nouveau plugin',
    'installed_plugins' => 'Installed Plugins',
    15 => 'Accueil Admin',
    16 => 'Nom du plugin',
    17 => 'Version du plugin',
    18 => 'Version de GL',
    19 => 'Activ�',
    20 => 'Oui',
    21 => 'Non',
    22 => 'Installer',
    23 => 'Enregistrer',
    24 => 'Annuler',
    25 => 'Supprimer',
    26 => 'Nom du plugin',
    27 => 'Site web du plugin',
    28 => 'Version du plugin',
    29 => 'Version de GL',
    30 => 'Supprimer le plugin ?',
    31 => 'Etes-vous s�r de vouloir supprimer ce plugin? Toutes les donn�es, fiches et structures utilis�s par ce plugin seront d�truites.  Si vous tes certain de vouloir supprimer le plugin, cliquez sur le bouton &laquo;Supprimer&raquo;.',
    32 => '<p><b>Erreur de format du lien automatique</b></p>',
    33 => 'Version du code',
    34 => 'Mise � jour',
    35 => 'Edition',
    36 => 'Code',
    37 => 'Donn�es',
    38 => 'Mettre � jour!',
    39 => 'Upload un plugin',
    40 => 'Vous pouvez uploader une archive d\'un plugin (.tar.gz, .tgz, .zip) directement ici :',
    41 => 'Upload',
    42 => 'Cliquer pour mettre � jour',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    'delete' => 'Delete',
    'delete_plugin' => 'Delete Plugin and all of its files?',
    'click_to_delete_msg' => 'Click to Delete this Plugin files',
    'really_delete_msg' => 'Really Delete %s Plugin files?',
    99 => 'Une erreur inconue s\'est produite',
    100 => 'Ok.',
    101 => 'Le fichier upload� exc�de la valeur upload_max_filesize du php.ini.',
    102 => 'Le fichier upload� exc�de la valeur MAX_FILE_SIZE sp�cifi�e dans le formulaire HTML.',
    103 => 'Le fichier n\'a �t� que partiellement upload�.',
    104 => 'Aucun fichier n\'a �t� upload�.',
    105 => '(erreur ind�finie)',
    106 => 'Un dossier temporaire est mamnquant.',
    107 => 'Impossible de copier le fichier sur le disque.',
    108 => 'L\'upload du fichier � �t� int�rrompu.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'cr�ez un flux',
    2 => 'sauvegardez',
    3 => 'effacez',
    4 => 'annulez',
    10 => 'Flux du contenu',
    11 => 'Nouveau flux',
    12 => 'Contr�les de l\'administration',
    13 => 'Cliquez sur le titre d\'un flux pour l\'effacer ou le modifier. Cliquez sur Ajouter pour en cr�er un nouveau.',
    14 => 'Titre',
    15 => 'Type',
    16 => 'Nom du fichier',
    17 => 'Format',
    18 => 'derni�re mise � jour',
    19 => 'Activ�',
    20 => 'Oui',
    21 => 'Non',
    22 => '<i>(pas de flux)</i>',
    23 => 'Toutes les cat�gories',
    24 => '�diteur de flux',
    25 => 'Titre du flux',
    26 => 'Limite',
    27 => 'Taille des entr�es',
    28 => '(0 = sans texte, 1 = plein texte, autre = limite du nombre de caract�res.)',
    29 => 'Description',
    30 => 'Mise � jour',
    31 => 'Jeu de caract�res',
    32 => 'Langue',
    33 => 'Contenu',
    34 => 'Entr�es',
    35 => 'Heures',
    36 => 'S�lectionnez le type de flux',
    37 => '',
    38 => 'Erreur : champs incomplets',
    39 => 'Merci d\'inscrire le titre du flux, sa description, et son nom de fichier.',
    40 => 'Merci d\.inscrire un nombre d\'entr�s ou un nombre d\'heures.',
    41 => 'Liens',
    42 => '',
    43 => 'Tout',
    44 => 'Rien',
    45 => 'Lien d\'ent�te dans le sujet',
    46 => 'Limite des r�sultats',
    47 => 'Recherche',
    48 => 'Edition',
    49 => 'Logo du flux',
    50 => "URL du site ({$_CONF['site_url']})",
    51 => 'Le nom de fichier choisi est pr�sentement utilis� par un autre flux. Merci de choisir un nom diff�rent.',
    52 => 'Erreur: nom de fichier existant',
    53 => 'All Frontpage Articles',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles',
    'num_articles' => '%s Article(s)'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => 'Language Overrides',
    'language_manager' => 'Language Manager',
    'new_language_msg' => 'To modify or delete a language item, click on that item\'s edit icon below. To create a new item, click on "Create New" above.',
    'language_editor' => 'Language Editor',
    'id' => 'ID',
    'language' => 'Language',
    'name' => 'Name',
    'var_name' => 'Var Name',
    'name_tip' => 'Required just for language arrays.',
    'var_name_tip' => 'Can be a regular variable or array. Do not include the dollar sign at the beginning of the variable/array name.',
    'value' => 'Value'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'URL routing',
    2 => 'Routing Manager',
    3 => 'ID',
    4 => 'method',
    5 => 'rule',
    6 => 'route',
    7 => 'priority',
    8 => 'Increase priority',
    9 => 'Decrease priority',
    10 => 'Edit routing',
    11 => 'To modify or delete a route, click on the route\'s edit icon below. To create a new route, click on "Create New" above.  When you use placeholders (@), you must define the same placeholders in a rule and its route.',
    12 => 'Bad request method',
    13 => 'Rule is a mandatory item.',
    14 => 'Route is a mandatory item.',
    15 => 'Placeholders (@) in a rule and those in a route must be the same.',
    16 => 'Route must not start with "/index.php/".',
    17 => 'Database error occurred.',
    18 => '<strong>To enable URL routing, you have to enable URL rewrite in the Configuration.</strong>',
    19 => '<strong>To enable URL routing, you have to enable URL routing in the Configuration.</strong>',
    20 => '<ul><li>Placeholders (@) must be the same both in a rule and its route.</li><li>A placeholder starts with "@", followed by an alphabet, optionally followed by any length of alphabet or digit.</li><li>Placeholders are case-sensitive.</li></ul>',
    21 => 'Status Code',
    22 => 'Enabled',
    23 => 'Yes',
    24 => 'No'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Votre mot de passe a �t� envoy� par email et devrait vous parvenir sous peu. Suivez les instructions incluses dans le message pour vous connecter � l'espace membre de {$_CONF['site_name']}",
    2 => "Merci de proposer un article � {$_CONF['site_name']}.  Il a �t� envoy� � notre �quipe qui en disposera. Votre article sera publi� s'il est retenu.",
    3 => '',
    4 => '',
    5 => 'Vos informations ont �t� mises � jour avec succ�s.',
    6 => 'Vos pr�f�rences d\'affichage ont �t� mises � jour avec succ�s.',
    7 => 'Vos pr�f�rences de commentaire ont �t� mises � jour avec succ�s.',
    8 => 'Vous avez �t� d�connect� avec succ�s.',
    9 => 'Votre article a �t� enregistr� avec succ�s.',
    10 => 'L\'article a �t� supprim� avec succ�s.',
    11 => 'Votre block a �t� enregistr� avec succ�s.',
    12 => 'Le block a �t� supprim� avec succ�s.',
    13 => 'Votre cat�gorie a �t� enregistr�e avec succ�s.',
    14 => 'La cat�gorie et tous ses articles ainsi que ses blocks ont �t� supprim�s avec succ�s.',
    15 => 'Votre commentaire � �t� soumis et sera publi� apr�s validation par un mod�rateur.',
    16 => 'Vous avez �t� d�sabonn�. Vous ne serez donc plus averti des nouvelles r�ponses.',
    17 => 'Your user account has been locked and access to it has been disabled. For more information please contact the Admin.',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Le nouveau membre a �t� enregistr� avec succ�s.',
    22 => 'L\'utilisateur a �t� supprim� avec succ�s.',
    23 => 'Your passwords must match, please try again. Passwords are case sensitive.',
    24 => 'Your emails must match, please try again.',
    25 => 'You have not entered a valid email address, please try again.',
    26 => 'That email address is already being used by an account, please try again.',
    27 => 'Message envoy� avec succ�s.',
    28 => 'Le plugin a �t� sauvegard� avec succ�s.',
    29 => 'D�sol�, vous n\'avez pas acc�s � cette page d\'administration. Pour information, toutes les tentatives pour acc�der aux fonctions non autoris�es sont enregistr�es.',
    30 => 'Acc�s r�serv�',
    31 => 'Sorry, This feature is not supported by the  database server this website is using.  Please note that all attempts to access unsupported features are logged.',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Message',
    41 => '',
    42 => '',
    43 => 'Account does not exist.',
    44 => 'Le plugin a �t� install� avec succ�s!',
    45 => 'Le plugin a �t� supprim� avec succ�s.',
    46 => 'Your username or email address was not found, please try again.',
    47 => 'Sorry you cannot currently request the password for your account. For more information please contact the Admin.',
    48 => "Merci d'avoir demand� un compte membre sur {$_CONF['site_name']}. La demande a �t� envoy�e � notre �quipe qui en disposera. Lorsque la demande sera accept�e, votre mot de passe vous sera envoy� par email � l'adresse que vous avez fournie.",
    49 => 'Votre groupe a �t� enregistr� avec succ�s.',
    50 => 'Le groupe a �t� supprim� avec succ�s.',
    51 => 'Ce nom de membre existe d�j�. Pri�re d\'en choisir un nouveau.',
    52 => 'L\'email fourni ne para�t pas �tre valide.',
    53 => 'Votre nouveau mot de passe � �t� accept�. Pri�re de l\'inscrire ci-dessous pour acc�der au site.',
    54 => 'Votre requte pour l\'obtention d\'un nouveau mot de passe est expir�e. Pri�re d\'essayer de nouveau ci-dessous.',
    55 => 'Un email qui vient de vous �tre envoy� devrait vous parvenir sous peu. Merci de suivre les instructions du message et de proc�der � l\'enregistrement de votre nouveau mot de passe.',
    56 => 'L\'adresse email fournie est d�j� utilis�e par un autre compte.',
    57 => 'Votre compte � �t� effac� avec succ�s.',
    58 => 'Votre flux a �t� enregistr� avec succ�s.',
    59 => 'Votre flux a �t� effac� avec succ�s.',
    60 => 'La mise � jour de ce plugin est un succ�s',
    61 => 'Plugin %s: coordonn�es de ce message inconnues',
    62 => 'Le commentaire du Trackback � �t� effac�.',
    63 => 'Une erreur est survenue et le commentaire du Trackback n\'� pas �t� effac�.',
    64 => 'Le commentaire du Trackback � �t� envoy�.',
    65 => 'Le directoire Weblog a bien �t� sauvegard�.',
    66 => 'Le directoire Weblog a bien �t� effac�.',
    67 => 'Le nouveau mot de passe semble diff�rent de celui confirm�!',
    68 => 'Vous avez correctement inscrit le mot de passe actuel.',
    69 => 'Votre compte � �t� bloqu�!',
    70 => 'Votre compte est en attente d\'activation',
    71 => 'Votre compte est en attente d\'activation, il doit tre approuv� par un admistrateur.',
    72 => 'Une erreur s\'est produite lors de l\'installation de ce plugin. Voyez error.log pour les d�tails.',
    73 => 'Une erreur s\'est produite lors de de la d�sinstallation de ce plugin. Voyez error.log pour les d�tails.',
    74 => 'Le Pingback � �t� envoy� avec succ�s.',
    75 => 'Les Trackbacks doivent tre envoy�s suivant une requte POST.',
    76 => 'D�sirez-vous vraiment effacer cet article ?',
    77 => 'ATTENTION:<br' . XHTML . '>Vous avez choisi UTF-8 comme encodage par d�faut, malgr� le fait que vos serveurs ne supportent pas un encodage multi-bit. Pri�re d\'installer les fonctions mbstring pour PHP ou choisissez une langue diff�rente.',
    78 => 'Pri�re de vous assurer que l\'adresse email et l\'email de confirmation soient identiques.',
    79 => 'La page que vous tentez d\'ouvrir r�f�re � une fonctionalit� d�sinstall�e de ce site.',
    80 => 'Le plugin qui a cr�� ce lien a �t� d�sinstall�. Merci de r�installer le plugin avant toute chose.',
    81 => 'Votre code d\'acc�s est erron�. Merci de r�essayer.',
    82 => 'ACC�S REFUS�. Merci d\'attendre quelques temps avant de r�essayer.',
    83 => 'Merci d\'utiliser votre mot de passe actuel si vous d�sirez changer votre profil.',
    84 => 'Merci d\'utiliser votre mot de passe actuel si vous d�sirez fermer votre compte.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'Il y a eu une erreur.',
    96 => '',
    97 => '',
    98 => 'Le plugin � bien �t� upload�.',
    99 => 'Le plugin existe d�j�.',
    100 => 'Le fichier du plugin que vous avez upload� n\'�st pas une archive compress�e au format GZip ou Zip.',
    101 => 'Il n\'y a pas de cat�gorie � laquelle vous puissiez acc�der. Vous avez besoin au moins d\'une cat�gorie pour pouvoir soumettre un article.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    121 => 'Saved a URL routing item.',
    122 => 'Could not save a URL routing item.',
    123 => 'Deleted a URL routing item.',
    130 => 'Your language item has been successfully deleted.',
    131 => 'Your language item has been successfully saved.',
    140 => 'Deleted comment(s).',
    141 => 'Failed to delete a comment.',
    142 => 'Approved comment(s).',
    143 => 'Banned user(s).',
    144 => 'Banned IP addresses with the Spamx plugin.',
    145 => 'Banned IP addresses with the Ban plugin.',
    150 => 'Successfully deleted all the files and directories used during the installation.',
    151 => 'Failed to delete some files and directories used during the installation.  Please remove them manually.',
    152 => 'All the files and directories used during the installation are left as they are.  It is dangerous to keep them on the server, so please don\'t forget to remove them manually.',
    153 => 'You last emailed an article %1$d seconds ago.  This site requires at least %2$d seconds between emailing articles.',
    160 => 'The plugin files was successfully deleted.',
    161 => 'The archive includes a file whose name includes an unsafe character.',
    400 => 'Tous les champs n�cessaires n\'ont pas pass�s la validation',
    401 => 'Saisir votre nom complet',
    500 => 'The Template Cache has been successfully cleared.',
    501 => 'A verification message has been sent to your email address. Please click on the link in the email to confirm your email address and update your account. If you log into your account again before you verify your email address you will be asked again for a email address.<br' . XHTML . '><br' . XHTML . '>Please note you have now been successfully logged out so you can complete this verification.',
    502 => 'Your request for a new email has expired. Please try again below.',
    503 => 'Your email has been successfully verified.',
    504 => 'Passwords must have a minimum of 8 characters and contain at least 1 number and 1 letter. Passwords are case sensitive.',
    505 => "Warning - The current theme {$_CONF['theme']} v{$_CONF['theme_gl_version']} is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}.",
    506 => "Warning - The current theme {$_CONF['theme']} (version not known) is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}."
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Acc�s',
    'ownerroot' => 'Propri�taire/Admin',
    'group' => 'Groupe',
    'readonly' => 'Lecture seule',
    'accessrights' => 'Droits d\'acc�s',
    'owner' => 'Propri�taire',
    'grantgrouplabel' => 'Autorisation au del� du groupe d\'�dition',
    'permmsg' => 'REMARQUE : Les membres sont tous les utilisateurs identifi�s et les anonymes sont tous les autres.',
    'securitygroups' => 'Groupe de s�curit�',
    'editrootmsg' => "Vous pouvez modifier tous les utilisateurs except�s les administrateurs. Toutes les tentatives de modifications d'un administrateur sont enregistr�es. Retournez sur la <a href=\"{$_CONF['site_admin_url']}/user.php\">page d'administration</a>.",
    'securitygroupsmsg' => 'S�lectionner les cases des groupes auxquels l\'utilisateur appartient',
    'groupeditor' => 'Editeur de groupe',
    'description' => 'Description',
    'name' => 'Nom',
    'rights' => 'Droits',
    'missingfields' => 'Champs manquants',
    'missingfieldsmsg' => 'Vous devez saisir un nom et une description',
    'groupmanager' => 'Administrateur de groupe',
    'newgroupmsg' => 'Pour modifier ou supprimer un groupe, cliquez sur le groupe ci-dessous. Pour cr�er un nouveu groupe, cliquez sur Nouveau Groupe. Les groupes natifs ne peuvent pas tre supprim�s car ils sont utilis�s par le syst�me.',
    'groupname' => 'Nom du groupe',
    'coregroup' => 'Groupe syst�me',
    'yes' => 'Oui',
    'no' => 'Non',
    'corerightsdescr' => "Ce groupe est un groupe syst�me de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas tre modifi�s.  La liste ci-dessous des droits d'acc�s du groupe n'est pas modifiable.",
    'groupmsg' => 'Les droits des groupes sont hi�rarchiques.  En ajoutant un groupe � un autre vous ajoutez tous les droits de ce groupe � l\'autre.  Lorsque c\'est possible, utilisez les groupes d�ja d�finis.  Si vous avez besoin de droits sp�cifiques, vous pouvez les choisir dans la liste ci-dessous.  Pour Ajouter un groupe � celui-ci cliquez sur la case du groupe � ajouter.',
    'coregroupmsg' => "Ce groupe est un groupe syst�me de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas tre modifi�s. La liste ci-dessous des groupes inclus de ce groupe n'est pas modifiable.",
    'rightsdescr' => 'Les droits suivants peuvent tre donn�s directement au groupe OU provenir d\'un groupe inclus. Les droits sans case � cocher proviennent de groupe inclus. Les droits qui ont des cases � cocher sont donn�s directement au groupe.',
    'lock' => 'Bloquer',
    'members' => 'Membres',
    'anonymous' => 'Anonymes',
    'permissions' => 'Permissions',
    'permissionskey' => 'R = lecture, E = modification, le droit de modification implique le droit de lecture',
    'edit' => 'Modifier',
    'none' => 'Rien',
    'accessdenied' => 'Acc�s r�serv�',
    'storydenialmsg' => "vous n'avez pas le droit de lire cette article. Peut-tre que vous n'tes pas membre de {$_CONF['site_name']}.  Vous pouvez <a href=\"{$_CONF['site_url']}/users.php?mode=new\">vous enregistrer</a> sur {$_CONF['site_name']} pour obtenir un compte membre!",
    'nogroupsforcoregroup' => 'Le groupe n\'inclue aucun autre groupe',
    'grouphasnorights' => 'Le groupe n\'a pas acc�s aux fonctions administratives',
    'newgroup' => 'Nouveau Groupe',
    'adminhome' => 'Accueil Admin',
    'save' => 'enregistrer',
    'cancel' => 'annuler',
    'delete' => 'supprimer',
    'canteditroot' => 'Vous avez essay� de modifier le groupe administrateur mais vous n\'en faites pas partie. Vous n\'avez pas acc�s � ce groupe. Veuillez contacter l\'administrateur si vous pensez que c\'est une erreur.',
    'listusers' => 'Liste des utilisateurs',
    'listthem' => 'liste',
    'usersingroup' => 'Utilisateurs dans le groupe "%s"',
    'usersingroupmsg' => 'A list of users that belong to the group. Users lists here may belong directly to the group or are inherited from another group that has been added to this group.',
    'usergroupadmin' => 'Administration du groupe des utilisateurs',
    'add' => 'Ajoutez',
    'remove' => 'Enlevez',
    'availmembers' => 'Membres disponibles',
    'groupmembers' => 'Membres du groupe',
    'inheritmembers' => 'Inherited Group Members',
    'canteditgroup' => 'Vous devez tre un membre de ce groupe pour l\'�diter.',
    'cantlistgroup' => 'Vous devez tre un membre de ce groupe pour en voir les autres membres.',
    'editgroupmsg' => 'Cliquez sur le nom des membres et sur <b>Ajouter</b> ou <b>Enlevez</b> pour modifier le membership du groupe. Si le membre est un membre du groupe, son nom appara�tra sur le c�t� droit seulement. Une fois le processus termin�, cliquez sur <b>enregister</b> pour mettre � jour et revenir au d�but.',
    'listgroupmsg' => 'Liste des membres actuels du groupe : <b>%s</b>',
    'search' => 'Recherche',
    'submit' => 'Soumettre',
    'limitresults' => 'Limite des resultats',
    'group_id' => 'Groupe ID',
    'plugin_access_denied_msg' => 'Tentative ill�gale d\'acc�s aux donn�es!  Toutes les tentatives sont prise en note.',
    'groupexists' => 'Nom de groupe d�j� existant',
    'groupexistsmsg' => 'Il y a d�j� un groupe portant ce nom. Merci d\'en choisir un autre.',
    'demo_mode_denied_msg' => 'This feature is currently disabled while the site is in Demo Mode.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'Database Administration',
    'last_ten_backups' => '10 dernieres sauvegardes',
    'site_db_backup' => "{$_CONF['site_name']} Database Backup",
    'create_backup' => 'Backup Database',
    'do_backup' => 'Faire une sauvegarde',
    'backup_successful' => 'Sauvegarde de la base de donn�e effectu�e avec succ�s',
    'backup_error' => 'Error performing database backup.',
    'db_explanation' => 'Cliquez sur le bouton ci-dessous pour effectuer une sauvegarde de votre syst�me',
    'backup_instructions' => 'To create a new backup of your site database, select the "Do Backup" button below. This will backup all current Geeklog tables. You can download a copy of the backup from the main Database Administration Screen.',
    'zero_size' => 'Sauvegarde �chou�e: la taille du fichier �tait de 0 octets.',
    'path_not_found' => "{$_CONF['backup_path']} n'existe pas ou n'est pas un r�pertoire.",
    'no_access' => "Erreur: le r�pertoire {$_CONF['backup_path']} n'est pas accessible.",
    'backup_file' => 'Fichier de sauvegarde',
    'size' => 'Taille',
    'bytes' => 'Octets',
    'total_number' => 'Nombre total de sauvegardes : %d',
    'download' => 'Cliquez pour t�l�charger ce fichier',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_myisam_menu' => 'Convert to MyISAM',
    'convert_myisam_title' => 'Convert to MyISAM tables',
    'convert_button' => 'Convert',
    'converting' => 'Converting',
    'no_innodb' => 'Your version of MySQL does not support InnoDB tables.',
    'no_myisam' => 'Your version of MySQL does not support MyISAM tables.',
    'innodb_instructions' => 'InnoDB tables can provide better performance on large databases. Please <a href="http://dev.mysql.com/doc/refman/5.7/en/converting-tables-to-innodb.html" target="_blank">read up</a> on the benefits and drawbacks of InnoDB tables before you perform a conversion.',
    'myisam_instructions' => 'MyISAM tables can provide better performance on smaller databases.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'already_converted_myisam' => 'It appears that all of the tables have already been converted to MyISAM.',
    'conversion_message' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'myisam_success' => 'Successfully converted tables to MyISAM.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimizing' => 'Optimizing',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_message' => 'Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.',
    'conversion_status' => 'Conversion Status',
    'optimization_status' => 'Optimization Status',
    'backup_status' => 'Backup Status',
    'backingup' => 'Performing Backup',
    'backup_title' => 'Backup the Geeklog Database',
    'backup_warning' => 'Note: The configuration is set to only backup database structures. No data will be backed up.',
    'latest_backup' => 'Latest Backup',
    'tables_to_backup' => 'Tables to Backup',
    'include' => 'Include',
    'exclude' => 'Exclude',
    'options' => 'Options',
    'struct_only' => 'Only Backup Table Structure (no data)',
    'max_files' => 'Maximum Backup Files to Keep',
    'disable_purge' => '("0" to disable purging.)',
    'use_gzip' => 'Use GZip if available',
    'configure' => 'Configure',
    'config_instructions' => 'Select any tables you wish to exclude from the backup. Other options can be found in the Geeklog Configuration under the Database tab.',
    'config_successful' => 'Tables to Backup list was saved successfully.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Home',
    2 => 'Contact',
    3 => 'Ecrire un article',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistiques du site',
    8 => 'Personnaliser',
    9 => 'Chercher',
    10 => 'Recherche',
    11 => 'Archives'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Erreur 404',
    2 => 'Le syst�me ne trouve pas <b>http://</b>.',
    3 => "<p>Le fichier que vous demandez n'existe pas. Allez � la <a href=\'{$_CONF['site_url']}\'>page principale</a> ou la <a href=\'{$_CONF['site_url']}/search.php\'>page de recherche</a> afin de retrouver ce que vous avez perdu.",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Vous devez vous connecter',
    2 => 'Vous devez vous identifier � l\'aide de l\'espace membre pour acc�der � cette partie du site.',
    3 => 'Accueil',
    4 => 'Nouveau membre'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'de',
    'tracked_on' => 'Pist� sur',
    'read_more' => '[lire la suite]',
    'intro_text' => 'Voici ce que les autres ont � dire de \'%s\':',
    'no_comments' => 'Aucun Trackback pour l\'instant.',
    'this_trackback_url' => 'URL de Trackback :',
    'num_comments' => '%d Trackbacks',
    'send_trackback' => 'Envoyez un ping',
    'preview' => 'Pr�-visualisez',
    'editor_title' => 'Envoyez un commentaire au sujet du Trackback',
    'trackback_url' => 'URL de Trackback',
    'entry_url' => 'URL de la soumission',
    'entry_title' => 'Titre de la soumission',
    'blog_name' => 'Nom du site',
    'excerpt' => 'Extrait',
    'truncate_warning' => 'Note: le site r�cepteur peut raccoucir votre extrait',
    'button_send' => 'Envoyez',
    'button_preview' => 'Pr�-visualisez',
    'send_error' => 'Erreur',
    'send_error_details' => 'Erreur dans l\'envoi du commentaire de ce Trackback :',
    'url_missing' => 'Pas d\'URL de soumission',
    'url_required' => 'Merci d\'inscrire un URL pour cette soumission.',
    'target_missing' => 'Pas d\'URL de Trackback',
    'target_required' => 'Merci d\'inscrire un URL pour ce Trackback',
    'error_socket' => 'N\'a pu acc�d� aux donn�es.',
    'error_response' => 'R�ponse incomprise.',
    'error_unspecified' => 'Erreur non sp�cifique.',
    'select_url' => 'S�lectionnez un URL pour ce Trackback',
    'not_found' => 'L\'URL de ce Trackback est inconnu',
    'autodetect_failed' => 'Le syst�me n\'a pu d�tecter l\'URL du Trackback que vous d�sirez commenter. Merci de l\'inscrire manuellement.',
    'trackback_explain' => 'Merci de s�lectionner l\'URL vers lequel vous souhaitez envoyer votre Trackback � partir des liens ci-dessous, ou alors inscrivez-le manuellement <a href="%s"> en cliquant ici</a> s\'il ne s\'y trouve pas.',
    'no_links_trackback' => 'Aucun lien trouv�. Vous ne pouvez commenter le Trackback li� � cette soumission.',
    'pingback' => 'Pingback',
    'pingback_results' => 'R�sultat des Pingbacks',
    'send_pings' => 'Envoyez un ping',
    'send_pings_for' => 'Envoyez un ping pour "%s"',
    'no_links_pingback' => 'Aucun lien trouv�. Vous ne pouvez envoyer un Pingback li� � cette soumission.',
    'pingback_success' => 'Pingback envoy�.',
    'no_pingback_url' => 'Aucun URL li� � ce Pingback n\'a �t� identifi�.',
    'resend' => 'Renvoi',
    'ping_all_explain' => 'Vous pouvez maintenant avertir les sites dont vous donn� un lien (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), ou avertir que votre site � �t� modifi� en lan�ant un ping aux r�pertoires de blog, ou encore envoyer un <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> au cas o&ugrave; vous ayez comment� les propos trouv�s sur un autre site.',
    'pingback_button' => 'Envoyez un Pingback',
    'pingback_short' => 'Envoyez un Pingback � tous les sites li�s � cette soumission.',
    'pingback_disabled' => '(Pingbacks d�sactiv�s)',
    'ping_button' => 'Envoyez un ping',
    'ping_short' => 'Envoyez un ping aux r�pertoires de blog.',
    'ping_disabled' => '(Pings d�sactiv�s)',
    'trackback_button' => 'Envoyez un Trackback',
    'trackback_short' => 'Envoyez un commentaire de Trackback.',
    'trackback_disabled' => '(Trackbacks d�sactiv�s)',
    'may_take_a_while' => 'Merci de noter que l\'envoi de pings et de Pingbacks peut prendre un certain temps.',
    'ping_results' => 'R�sultats des pings',
    'unknown_method' => 'M�thode de ping inconnue',
    'ping_success' => 'Ping envoy�.',
    'error_site_name' => 'Inscrire le nom du site.',
    'error_site_url' => 'Inscrire l\'URL du site.',
    'error_ping_url' => 'Inscrire un URL de ping valide.',
    'no_services' => 'Aucun r�pertoire de blog n\'a �t� configur�.',
    'services_headline' => 'R�pertoire de blog',
    'service_explain' => 'Cliquez sur l\'icone correspondant au r�pertoire de blog que vous souhaitez modifier ou effacer. Cliquez sur Ajouter pour param�trer un nouveau r�pertoire de blog.',
    'service' => 'Service',
    'ping_method' => 'M�thode de ping',
    'service_website' => 'Site web',
    'service_ping_url' => 'Je ping cet URL',
    'ping_standard' => 'Ping standard',
    'ping_extended' => 'Ping �tendu',
    'ping_unknown' => '(m�thode inconnue)',
    'edit_service' => '�ditez les r�pertoires de blog',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Pr�parez vos commentaires de Trackback pour <a href="%s">%s</a>.',
    'editor_intro_none' => 'Pr�parez vos commentaires de Trackback.',
    'trackback_note' => 'Si vous d�sirez envoyer un Trackback, voyez la liste des articles et cliquez sur "Envoyez un ping" correspondant � l\'article que vous souhaitez commenter. <a href="%s">Cliquez ici</a> pour envoyer un Trackback qui n\'est li� � aucun article.',
    'pingback_explain' => 'Inscrivez l\'URL � qui il faudra envoyer le Pingback. Le Pingback pointera en direction de la page d\'accueil de votre site.',
    'pingback_url' => 'URL du Pingback',
    'site_url' => 'URL du site',
    'pingback_note' => 'Si vous d�sirez envoyer un Pingback, consultez la liste des articles et cliquez sur "Envoyez un ping" correspondant � l\'article que vous souhaitez commenter. <a href="%s">Cliquez ici</a> pour envoyer un Pingback qui n\'est li� � aucun article.',
    'pbtarget_missing' => 'Aucun URL pour ce Pingback',
    'pbtarget_required' => 'Merci d\'inscrire un URL pour ce Pingback',
    'pb_error_details' => 'Une erreur est survenue dans l\'envoi de ce Pingback :',
    'delete_trackback' => 'Cliquez pour effacer ce Trackback: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Liste des articles',
    'title_year' => 'Liste des articles en %d',
    'title_month_year' => 'Liste des articles en %s %d',
    'nav_top' => 'Retour � la liste des articles',
    'no_articles' => 'Pas d\'articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog v�rification de la s�curit�',
    'results' => 'Resultats de la v�rification de la s�curit�',
    'okay' => 'Tout semble �tre en ordre.',
    'please_fix' => 'Merci de corriger les probl�mes ci-dessus avant d\'utiliser votre site!',
    'please_note' => 'Notez qu\'aucun site n\'est s�curis� � 100%. Ce script teste uniquement les probl�me �vidents.',
    'stay_informed' => 'Pour rester inform� des nouvelles versions de Geeklog et des possibles probl�mes de s�curit�, nous vous sugg�rons de vous abonner (petit trafic) � la %s mailing list et/ou utiliser l\'option %s de l\'interface d\'administration de temps en temps pour v�rifier les mises � jour disponibles.',
    'public_html' => '"public_html" ne devrait jamais faire partie de l\'URL de votre site.  Merci de lire le paragraphe a propos du public_html dans les %s et de changer votre param�trage avant de continuer.',
    'installation' => 'Instructions d\'installation',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your data directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n %i',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'heures',
    'days' => 'jours',
    'weeks' => 'semaines',
    'months' => 'mois',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'heure',
    'day' => 'jour',
    'week' => 'semaine',
    'month' => 'mois',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Janvier',
    2 => 'F�vrier',
    3 => 'Mars',
    4 => 'Avril',
    5 => 'Mai',
    6 => 'Juin',
    7 => 'Juillet',
    8 => 'Ao&ucirc;t',
    9 => 'Septembre',
    10 => 'Octobre',
    11 => 'Novembre',
    12 => 'D�cembre'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => 'Jan',
    2 => 'Feb',
    3 => 'Mar',
    4 => 'Apr',
    5 => 'May',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Aug',
    9 => 'Sep',
    10 => 'Oct',
    11 => 'Nov',
    12 => 'Decr'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Dimanche',
    2 => 'Lundi',
    3 => 'Mardi',
    4 => 'Mercredi',
    5 => 'Jeudi',
    6 => 'Vendredi',
    7 => 'Samedi'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => 'Sun',
    2 => 'Mon',
    3 => 'Tue',
    4 => 'Wed',
    5 => 'Thu',
    6 => 'Fri',
    7 => 'Sat'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Recherche',
    'limit_results' => 'Limite des r�sultats',
    'submit' => 'Soumettre',
    'edit' => 'Editer',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Menu administratif',
    'create_new' => 'Ajouter',
    'create_new_adv' => 'Nouveau (Avenc�)',
    'enabled' => 'Activer',
    'disabled' => 'Disabled',
    'title' => 'Titre',
    'page_title' => 'Titre de la page',
    'type' => 'Type',
    'topic' => 'Sujet',
    'info' => 'Info',
    'help_url' => 'URL d\'aide',
    'save' => 'Sauvegarder',
    'cancel' => 'Annuler',
    'install' => 'Install',
    'delete' => 'Effacer',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copier',
    'no_results' => '- Aucune entr�e -',
    'data_error' => 'Il y a eu erreur dans le traitement des donn�es. Merci d\'en v�rifier la source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'Vous avez jusque %s pour saisir vos informations. Pass� ce d�lais et pour des raisons de s�curit�, vous perdrez votre saisie.',
    'token_expired' => 'Le d�lais de s�curit� pour cette op�ratiton � expir�. Merci de vous identifier � nouveau pour continuer.',
    'reauth_msg' => 'Le d�lais de s�curit� pour cette op�ratiton � expir�. Si vous souhaitez poursuivre l\'op�ration, merci de vous identifier � nouveau ci-dessous. Cela permettra de conserver vos derni�res modifications.',
    'token_expired_remote_user' => 'The security token for this operation has expired. Since you are a remote user you cannot re-authenticate, so you have lost your changes.',
    'token_re_authentication_error' => 'There was an error after your account was re-authenticated. It is unclear if the operation you were performing was executed or not.',
    'authenticate' => 'Authenticate',
    'approve' => 'Approve',
    'device' => 'Device',
    'device_desc' => 'For what device do you want this item to display for?',
    'for_all' => 'All',
    'for_mobile' => 'For Mobile',
    'for_computer' => 'For Computer',
    'all' => 'All',
    'mobile' => 'Mobile',
    'computer' => 'Computer',
    'edit_access_only' => 'Edit Access Only'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Autoriser les commentaires',
    -1 => 'Interdire les commentaires',
    1 => 'Suspendre les commentaires'
);

$LANG_commentmodes = array(
    'flat' => 'A plat',
    'nested' => 'Nich�s',
    'threaded' => 'Regroup�s',
    'nocomment' => 'Non affich�s'
);

$LANG_cookiecodes = array(
    0 => 'Non',
    3600 => '1 heure',
    7200 => '2 heures',
    10800 => '3 heures',
    28800 => '8 heures',
    86400 => '1 jour',
    604800 => '1 semaine',
    2678400 => '1 mois'
);

$LANG_dateformats = array(
    0 => 'D�faut du syst�me'
);

$LANG_featurecodes = array(
    0 => 'Pas en vedette',
    1 => 'En vedette'
);

$LANG_frontpagecodes = array(
    0 => 'Afficher avec le sujet seulement',
    1 => 'Afficher en page d\'accueil'
);

$LANG_postmodes = array(
    'plaintext' => 'Texte seul',
    'html' => 'Format HTML'
);

$LANG_sortcodes = array(
    'ASC' => 'Anciens en premier',
    'DESC' => 'Nouveaux en premier'
);

$LANG_statuscodes = array(
    0 => 'Normal',
    1 => 'Refreshing',
    10 => 'Archive'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback activ�',
    -1 => 'Trackback d�sactiv�'
);

$LANG_structureddatatypes = array(
    'none' => 'None',
    'core-webpage' => 'WebPage',
    'core-article' => 'Article',
    'core-newsarticle' => 'NewsArticle',
    'core-blogposting' => 'BlogPosting'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => 'Structured Data Type',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - Adds a property to the structured data of the content that the autotag is embedded in.'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Accueil',
    'admin_home' => 'Administration du site',
    'sections' => 'Configuration',
    'restore' => 'Restaurer',
    'add_element' => 'Ajouter un �l�ment',
    'save_changes' => 'Sauvegarder les changements',
    'reset_form' => 'Remise � z�ro',
    'changes_made' => 'Les changements suivants ont �t� effectu�s',
    'title' => 'Panneau de Configuration',
    'disable' => 'Cliquer pour mettre hors de service',
    'enable' => 'Mettre en service',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Configuration de Geeklog'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'Chemin vers HTML',
    'site_url' => 'URL du site',
    'site_admin_url' => 'URL de l\'administration',
    'site_mail' => 'Email du site',
    'noreply_mail' => 'Email No-Reply',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'mail_charset' => 'Email Character Set',
    'site_name' => 'Nom du site',
    'site_slogan' => 'Slogan du site (optionnel)',
    'path_site_logo' => 'Site Logo',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Logs',
    'path_language' => 'Langages',
    'backup_path' => 'Backups',
    'path_data' => 'Datas',
    'path_images' => 'Images',
    'path_editors' => 'Advanced Editors',
    'mail_settings' => 'Mail ',
    'dbdump_filename_prefix' => 'Backup File Name Prefix',
    'dbdump_tables_only' => 'Only Backup Table Structure',
    'dbdump_gzip' => 'Use GZip if available',
    'dbdump_max_files' => 'Maximum Backup Files to Keep',
    'theme' => 'Th�me',
    'doctype' => 'DOCTYPE D�claration',
    'menu_elements' => 'El�ments de navigation',
    'path_themes' => 'Chemin vers les Th�mes',
    'cache_templates' => 'Cache Templates?',
    'cache_mobile' => 'Cache Mobile Devices Separately?',
    'cache_resource' => 'Combine, Minify and Cache CSS and JavaScript Files?',
    'disable_new_user_registration' => 'Mettre hors service les nouvelles inscriptions',
    'allow_user_themes' => 'Permettre aux utilisateurs de choisir le th�me',
    'allow_user_language' => 'Permettre aux utilisateurs de choisir la langue',
    'switchlang_homepage' => 'Switch Language Block Redirects to Homepage',
    'new_item_set_current_lang' => 'Add Current Language Id to New Item',
    'allow_user_photo' => 'Permettre aux utilisateurs d\'utiliser une photo',
    'allow_username_change' => 'Permettre aux utilisateurs de changer de login',
    'allow_account_delete' => 'Permettre aux utilisateurs de supprimer leur compte',
    'hide_author_exclusion' => 'Permettre aux utilisateur de cacher un auteur',
    'show_fullname' => 'Montrer le nom complet des membres',
    'show_servicename' => 'Montrer le nom du service',
    'require_user_email' => 'Require User Email',
    'custom_registration' => 'Permettre l\'enregistrement personnalis�',
    'user_login_method' => 'Autoriser la connexion',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'Enable OAuth Login Method GitHub',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'Actions Spam-X',
    'sort_admin' => 'Tri des liens',
    'language' => 'Langage',
    'locale' => 'Locale',
    'date' => 'Format de la date',
    'daytime' => 'Format Jour et heure',
    'shortdate' => 'Format date courte',
    'dateonly' => 'Format date uniquement',
    'timeonly' => 'Format heure uniquement',
    'week_start' => 'D�but de semaine',
    'hour_mode' => 'Mode des heures',
    'thousand_separator' => 'S�parateur des centaines',
    'decimal_separator' => 'S�parateur d�cimal',
    'decimal_count' => 'Nombre de d�cimal',
    'language_files' => 'Fichiers langage',
    'languages' => 'Langages',
    'timezone' => 'Fuseau horaire',
    'site_disabled_msg' => 'Message du site hors service ou URL',
    'rootdebug' => 'Root Debugging (toujours faux pour un site en production)',
    'cookie_session' => 'Nom du cookie Session',
    'cookie_name' => 'Nom du cookie Permanent',
    'cookie_password' => 'Nom du cookie Password',
    'cookie_theme' => 'Nom du cookie Theme',
    'cookie_language' => 'Nom du cookie Language',
    'cookie_tzid' => 'Nom du cookie Timezone',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Ajouter l\'IP au Cookies',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Enregistrer la derni�re connexion',
    'num_search_results' => 'Nombre de r�sultats des recherches',
    'loginrequired' => 'Connexion n�cessaire',
    'submitloginrequired' => 'Connexion n�cessaire pour les soumissions',
    'commentsloginrequired' => 'Connexion n�cessaire pour ajouter un commentaire',
    'statsloginrequired' => 'Connexion n�cessaire pour consulter les statistiques',
    'searchloginrequired' => 'Connexion n�cessaire pour effectuer une recherche',
    'profileloginrequired' => 'Connexion n�cessaire pour consulter un profil',
    'emailuserloginrequired' => 'Connexion n�cessaire pour exp�dier un email aux membres',
    'emailstoryloginrequired' => 'Connexion n�cessaire pour exp�dier un article par email',
    'directoryloginrequired' => 'Connexion n�cessaire pour consulter la liste des archives',
    'storysubmission' => 'Mise en attente des soumissions d\'articles',
    'usersubmission' => 'Mise en attente des soumission de membres',
    'listdraftstories' => 'Liste des articles brouillons',
    'notification' => 'Notifications',
    'postmode' => 'Mode de publication par d�fault',
    'speedlimit' => 'Limitation entre les publications',
    'skip_preview' => 'Donner la possibilit� d\'�viter la pr�visualisation',
    'advanced_editor' => 'Activer l\'editeur avanc�',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Activer l\'�diteur Wikitext',
    'remove_4byte_chars' => 'Remove 4-byte utf-8 characters?',
    'cron_schedule_interval' => 'Intervalle du Cron interne',
    'sortmethod' => 'Classement des cat�gories',
    'showstorycount' => 'Afficher le nombre d\'article dans chaque cat�gorie',
    'showsubmissioncount' => 'Afficher le nombre de soumissions dans chaque cat�gories',
    'hide_home_link' => 'Cacher le lien Accueil',
    'whosonline_threshold' => 'Intervalle pour le calcul du nombre de visiteurs en ligne',
    'whosonline_anonymous' => 'Cacher le nom des membres aux visiteurs anonymes',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Activer le r�sum� quotidien',
    'emailstorieslength' => 'Longueur des articles',
    'emailstoriesperdefault' => 'Activer le r�sum� quotidien par d�fault � tous les nouveaux membres',
    'allow_domains' => 'Autoriser automatiquement les domaines',
    'disallow_domains' => 'Interdire automatiquement les domaines',
    'newstoriesinterval' => 'Intervalle nouveaux articles',
    'newcommentsinterval' => 'Intervalle nouveaux commentaires',
    'newtrackbackinterval' => 'Intervalle nouveaux trackbacks',
    'hidenewstories' => 'Cacher les nouveaux articles',
    'hidenewcomments' => 'Cacher les nouveaux commentaires',
    'hidenewtrackbacks' => 'Cacher les nouveaux trackbacks',
    'hidenewplugins' => 'Cacher les nouvelles entr�es des plugins',
    'title_trim_length' => 'Ajuster la longueur des titres',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => 'Activer la function Trackback',
    'pingback_enabled' => 'Activer la function Pingback',
    'ping_enabled' => 'Activer la function Ping',
    'trackback_code' => 'Trackback - Param�tres par d�faut',
    'multiple_trackbacks' => 'Trackbacks multiples',
    'trackbackspeedlimit' => 'Intervalle minimum entre trackbacks',
    'check_trackback_link' => 'V�rification des trackbacks',
    'pingback_self' => 'Permettre des auto Pingback',
    'pingback_excerpt' => 'Cr�er des exception Pingback',
    'link_documentation' => 'Afficher un lien vers la documentation',
    'link_versionchecker' => 'Afficher un lien de v�rification de la version de geeklog',
    'maximagesperarticle' => 'Maximum d\'images par article',
    'limitnews' => 'Nombre d\'article(s) par page',
    'minnews' => 'Minimum d\'article(s) par page',
    'contributedbyline' => 'Afficher dans les articles le nom de l\'auteur',
    'hideviewscount' => 'Masquer le nombre de lectures',
    'hideemailicon' => 'Masquer le lien ou l\'icon Email',
    'hideprintericon' => 'Masquer le lien l\'icon Imprimer',
    'allow_page_breaks' => 'Permettre la multi-pagination',
    'page_break_comments' => 'O� afficher les commentaires des articles multi-pages',
    'article_image_align' => 'Placer l\'icon de la cat�gorie',
    'show_topic_icon' => 'Par d�faut afficher l\'icon de la cat�gorie',
    'structured_data_type_default' => 'Structured Data Type Default',
    'structured_data_article_topic' => 'Structured Data of Articles in Topics',
    'draft_flag' => 'Article enregist� en brouillon par d�faut',
    'frontpage' => 'Article publi� sur la page principale par d�faut',
    'hide_no_news_msg' => 'Masquer le message "Pas d\'article"',
    'hide_main_page_navigation' => 'Masque la navigation de la page principale',
    'onlyrootfeatures' => 'Uniquement le Root peut "Featur�"',
    'aftersave_story' => 'Apr�s la sauvegarde d\'un article',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'blocks_article_topic_list_repeat_after' => 'Article Topic List Blocks Location Repeat',
    'aftersave_user' => 'Apr�s la sauvegarde d\'un membre',
    'show_right_blocks' => 'Toujours afficher les blocks de gauche',
    'showfirstasfeatured' => 'Afficher le premier article "Featur�"',
    'template_comments' => 'Template Comments in Output?',
    'backend' => 'Activer les Flux',
    'rdf_file' => 'Chemin et fichier principal de syndication',
    'rdf_limit' => 'Limiter le nombre d\'articles du flux �',
    'rdf_storytext' => 'Longueur des articles du flux',
    'rdf_language' => 'Langue du flux',
    'syndication_max_headlines' => 'Maximum de titres pour un block portal',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Ann�e(s) du Copyright',
    'image_lib' => 'Librairie image',
    'path_to_mogrify' => 'Chemin vers Mogrify',
    'path_to_netpbm' => 'Chemin vers Netpbm',
    'debug_image_upload' => 'Debuggage au t�l�lchargement des images',
    'keep_unscaled_image' => 'Conserver l\'image non redimentionn�e',
    'allow_user_scaling' => 'Permettre aux membres de redimensionner',
    'jpeg_quality' => 'Qualit�e JPEG',
    'max_image_width' => 'Largeur maxi de l\'image',
    'max_image_height' => 'Hauteur maxi de l\'image',
    'max_image_size' => 'Taille maxi de l\'image',
    'max_topicicon_width' => 'Largeur maxi de l\'icon des cat�gories',
    'max_topicicon_height' => 'Hauteur maxi de l\'icon des cat�gories',
    'max_topicicon_size' => 'Taille maxi de l\'icon des cat�gories',
    'max_photo_width' => 'Largeur maxi des photos',
    'max_photo_height' => 'Hauteur maxi des photos',
    'max_photo_size' => 'Taille maxi des photos',
    'generate_user_icon' => 'Generate User Icon automatically?',
    'use_gravatar' => 'Utiliser Gravatar.com',
    'gravatar_rating' => 'Evaluation Gravatar permise',
    'gravatar_identicon' => 'Gravatar Identicon',
    'force_photo_width' => 'Imposer la largeur des photos',
    'default_photo' => 'Photo par d�faut',
    'commentspeedlimit' => 'Intervalle minimum entre les commentaires',
    'comment_limit' => 'Limiter le nombre de commentaires',
    'comment_mode' => 'Affichage des commentaires par d�faut',
    'comment_order' => 'Comment Order',
    'comment_code' => 'Valeur par d�faut pour les nouveaux articles',
    'comment_edit' => 'Permettre l\'�dition des commentaires',
    'comment_edittime' => 'Dur�e pendant laquelle un commentaire peut �tre �dit� (secondes)',
    'commentsubmission' => 'File d\'attente des soumissions des commentaires',
    'likes_enabled' => 'Likes Enabled',
    'likes_articles' => 'Article Likes',
    'likes_comments' => 'Comment Likes',
    'likes_speedlimit' => 'Likes Speed Limit',
    'likes_users_listed' => 'User Listed',
    'likes_block_cache_time' => 'Cache Time',
    'likes_block_include_time' => 'Include Time',
    'likes_block_max_items' => 'Max Items Listed',
    'likes_block_displayed_actions' => 'Displayed Actions',
    'likes_block_title_trim_length' => 'Title Trim Length',
    'likes_block_likes_new_line' => 'Likes on New Line',
    'likes_block_type' => 'Type',
    'likes_block_subtype' => 'Sub Type',
    'likes_block_enable' => 'Enabled',
    'likes_block_isleft' => 'Display Block on Left',
    'likes_block_order' => 'Block Order',
    'likes_block_topic_option' => 'Topic Options',
    'likes_block_topic' => 'Topic',
    'likes_block_group_id' => 'Group',
    'likes_block_permissions' => 'Permissions',
    'passwordspeedlimit' => 'Intervalle minimum entre les requ�te d\'un nouveau mot de passe',
    'login_attempts' => 'Nombre maximum de tentatives de connexions',
    'login_speedlimit' => 'Intervalle minimum entre tentavives de connexions echou�es',
    'invalidloginattempts' => 'Max. Invalid Login Attempts',
    'invalidloginmaxtime' => 'Invalid Login Max Time',
    'enable_twofactorauth' => 'Enable Two Factor Authentication?',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'HTML pour les membres',
    'admin_html' => 'HTML pour l\'administrateur',
    'advanced_html' => 'HTML additionnel pour l\'�diteur avanc�',
    'skip_html_filter_for_root' => 'Contourner le filtre HTML pour l\'administrateur principal (root)',
    'allowed_protocols' => 'Protocoles autoris�s',
    'disable_autolinks' => 'D�sactiver les Autolinks',
    'clickable_links' => 'Rendre les URLs cliquables',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Envoyer l\'output compr�ss�',
    'frame_options' => 'Protection contre "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'page_navigation_mobile_max_pages' => 'Max Pages for Navigation with Mobile Devices',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    '404_log' => 'Log 404 Errors',
    'censormode' => 'Mode censure',
    'censorreplace' => 'Texte de remplacement',
    'censorlist' => 'Liste des termes censur�s',
    'ip_lookup' => 'Recherche IP',
    'url_rewrite' => 'Activer la r��criture des URL',
    'url_routing' => 'Enable URL Routing',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Meta Description par d�faut',
    'meta_keywords' => 'Meta Keywords par d�faut',
    'default_permissions_block' => 'Permissions par d�faut des Blocks',
    'default_permissions_story' => 'Permissions par d�faut des articles',
    'default_permissions_topic' => 'Permissions par d�faut des cat�gories',
    'atom_max_stories' => 'Nombre maxi d\'articles dans les flux des Webservices',
    'disable_webservices' => 'D�sactiver les Webservices',
    'restrict_webservices' => 'Restreindre les Webservices',
    'article_comment_close_enabled' => 'Cl�turer automatiquement les commentaires (par d�faut)',
    'article_comment_close_days' => 'Nombre de jours pour clore les commenataires (par d�faut)',
    'comment_close_rec_stories' => 'Nombre des articles les plus r�cents pour lesquels activer les commentaires',
    'allow_reply_notifications' => 'Permettre les notifications de r�ponse aux commentaires',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Style de r�sultats',
    'search_limits' => 'Limites du nombre de pages',
    'search_show_num' => 'Montrer le nombre de r�sultats',
    'search_show_type' => 'Montrer le type de r�sultats',
    'search_show_sort' => 'Permettre aux utilisateurs de classer les r�sultats',
    'search_show_limit' => 'Montrer les limites',
    'search_separator' => 'S�parateur des groupes',
    'search_def_keytype' => 'M�thode de recherche par d�faut',
    'search_def_sort' => 'Ordre de recherche par d�faut',
    'search_use_topic' => 'Use Current Topic',
    'autotag_permissions_story' => '[article: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'autotag_permissions_block' => '[block: ] Permissions',
    'autotag_permissions_structureddata' => '[structureddata: ] Permissions',
    'autotag_permissions_likes_block' => '[likes_block: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions',
    'cookie_consent' => 'Enable Cookie Consent',
    'terms_of_use_link' => 'Terms of Use Link',
    'privacy_policy_link' => 'Privacy Policy Link',
    'about_cookies_link' => 'About Cookies Consent Link',
    'ip_anonymization' => 'IP Anonymization'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Articles et Trackbacks',
    'sg_theme' => 'Th�me',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Membres et contributions',
    'sg_images' => 'Images',
    'sg_locale' => 'Langages et Locale',
    'sg_misc' => 'Divers',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Chemins',
    'fs_theme' => 'Th�me',
    'fs_mail' => 'Mail',
    'fs_database_backup' => 'Database Backup',
    'fs_users' => 'Membres',
    'fs_misc' => 'Divers',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Langage',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Param�tres de connexion',
    'fs_search' => 'Recherche',
    'fs_user_submission' => 'Contribution des membres',
    'fs_submission' => 'Param�tres des contributions',
    'fs_topics_block' => 'Block des cat�gories',
    'fs_whosonline_block' => 'Block En ligne',
    'fs_daily_digest' => 'R�sum� quotidien',
    'fs_whatsnew_block' => 'Block Quoi de neuf',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Article',
    'fs_theme_advanced' => 'Param�tres avanc�s',
    'fs_syndication' => 'Syndication',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images dans les articles',
    'fs_topicicon' => 'Icons de cat�gorie',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Commentaires',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Article Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_database' => 'Database',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Article',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('Oui' => 1, 'Non' => 0),
    1 => array('Oui' => true, 'Non' => false),
    2 => array('Rejet�' => 0, 'Conserver le dernier' => 1, 'Permettre les posts multiples' => 2),
    3 => array('Trackback activ�' => 0, 'Trackback d�sactiv�' => -1),
    4 => array('Ne rien v�rifier' => 0, 'V�rifier l\'URL du site' => 1, 'V�rifier l\'URL compl�te' => 2, 'V�rifier l\'URL du site et l\'URL compl�te' => 3, 'Comparer l\'IP et l\'IP du site' => 4, 'V�ricier l\'IP et l\'URL du site' => 5, 'V�rifier l\'IP et l\'URL compl�te' => 6, 'V�rifier l\'IP, l\'UR compl�te et l\'URL du site' => 7),
    5 => array('Texte seul' => 'plaintext', 'Format HTML' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Derni�re page' => 'last', 'Premi�re page' => 'first', 'Toutes les pages' => 'all'),
    8 => array('Droite' => 'right', 'Gauche' => 'left'),
    9 => array('Retour � la page' => 'item', 'Liste articles' => 'list', 'Page d\'accueil' => 'home', 'Page administration' => 'admin'),
    10 => array('Aucune' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('A plat' => 'flat', 'Nich�s' => 'nested', 'Regroup�s' => 'threaded', 'Non affich�s' => 'nocomment'),
    12 => array('Pas d\'acc�s' => 0, 'Lecture seule' => 2, 'Lecture-Ecriture' => 3),
    13 => array('Contourner' => 0, 'Permettre avec limitation' => 1, 'Permettre, pas de limitation' => 2),
    14 => array('Dimanche' => 'Sun', 'Lundi' => 'Mon'),
    15 => array('Num�rique' => 'sortnum', 'Alphab�tique' => 'alpha'),
    16 => array('Connexion non requise' => 0, 'Uniquement la recherche avanc�e' => 1, 'Recherche simple + avanc�e' => 2),
    17 => array('Commentaires autoris�s' => 0, 'Commentaires non autoris�s' => -1),
    18 => array('Non autoris�' => 0, 'Autoris� (Exact Match)' => 1, 'Autoris� (Word Beginning)' => 2, 'Autoris� (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Phrase exacte' => 'phrase', 'Tous les mots' => 'all', 'Un de ces mots' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('D�sactiv�' => 0, 'Activ�' => 1, 'Activ� (Par d�faut pour la page principale seulement)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('Nouveaux articles' => 'article', 'Nouveaux commentaires' => 'comment', 'Nouveaux Trackbacks' => 'trackback', 'Nouveaux Pingbacks' => 'pingback', 'Nouveaux membres' => 'user', 'User Updates' => 'user_update'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Titre (asc)' => 'title|asc', 'Titre (desc)' => 'title|desc', 'Auteur (asc)' => 'uid|asc', 'Auteur (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC'),
    36 => array('False' => 'false', 'Frontpage only' => 'frontpage', 'Frontpage and Topics' => 'frontpage_topics'),
    37 => array('Disabled' => 0, 'Enabled (with "index.php")' => 1, 'Enabled (without "index.php")' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('None' => '', 'WebPage' => 'core-webpage', 'Article' => 'core-article', 'NewsArticle' => 'core-newsarticle', 'BlogPosting' => 'core-blogposting'),
    40 => array('False' => 0, 'Users and Anonymous' => 1, 'Users Only' => 2),
    41 => array('False' => 0, 'Likes and Dislikes' => 1, 'Likes Only' => 2),
    42 => array('None' => 0, 'Use individual Article Settings' => 1),
    43 => array('All' => 'all', 'Homepage Only' => 'homeonly', 'Select Topics' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('Likes and Dislikes' => 3, 'Likes Only' => 1, 'Dislikes Only' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'alphaNumericOrEmpty' => 'This field must be alpha numeric or empty',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'fileName' => 'This field must be a proper file name',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP',
    'config_setting_lang_array' => 'Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value',
    'config_setting_lang_array_element_req' => 'Requires at least one element. Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value'
);

