/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{property as n,customElement as m,state as w,query as b}from"lit/decorators.js";import{LitElement as P,nothing as u,html as d}from"lit";import I from"@typo3/core/ajax/ajax-request.js";import{AjaxResponse as g}from"@typo3/core/ajax/ajax-response.js";import E from"@typo3/backend/viewport.js";import{topLevelModuleImport as T}from"@typo3/backend/utility/top-level-module-import.js";import M,{Sizes as $}from"@typo3/backend/modal.js";import{SeverityEnum as y}from"@typo3/backend/enum/severity.js";var r=function(i,e,s,o){var a=arguments.length,t=a<3?e:o===null?o=Object.getOwnPropertyDescriptor(e,s):o,c;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")t=Reflect.decorate(i,e,s,o);else for(var h=i.length-1;h>=0;h--)(c=i[h])&&(t=(a<3?c(t):a>3?c(e,s,t):c(e,s))||t);return a>3&&t&&Object.defineProperty(e,s,t),t};class l extends P{}r([n({type:String})],l.prototype,"verifyActionUri",void 0),r([n({type:String})],l.prototype,"cancelUri",void 0),r([n({type:Boolean})],l.prototype,"isAjax",void 0),r([n({type:Boolean,attribute:"has-fatal-error"})],l.prototype,"hasFatalError",void 0),r([n({type:Boolean,attribute:"allow-install-tool-password"})],l.prototype,"allowInstallToolPassword",void 0),r([n({type:Object})],l.prototype,"labels",void 0);const v=async i=>{window.location!==window.parent.location&&T("@typo3/backend/security/element/sudo-mode.js");const s=top.document.createElement("typo3-backend-security-sudo-mode");return Object.assign(s,i),s.windowRef=window,top.document.body.append(s),new Promise((o,a)=>{s.addEventListener("typo3:sudo-mode:verified",()=>o()),s.addEventListener("typo3:sudo-mode:finished",()=>a())})};let f=class extends l{render(){return u}async firstUpdated(){if(window.location!==window.parent.location){try{await v(this.getPropertyValues())}catch{history.go(-1)}return}M.advanced({title:this.hasFatalError?this.labels.verificationFailed:this.labels.verifyWithUserPassword,severity:this.hasFatalError?y.error:y.notice,size:$.small,additionalCssClasses:["modal-sudo-mode-verification"],buttons:[this.hasFatalError?{text:this.labels.cancel,btnClass:"btn-default",trigger:()=>{top.location.href=this.cancelUri}}:{text:this.labels.verify,name:"verify",form:"verify-sudo-mode",btnClass:"btn-primary"}],content:d`<typo3-backend-security-sudo-mode-form .labels=${this.labels} .verifyActionUri=${this.verifyActionUri} .cancelUri=${this.cancelUri} .isAjax=${this.isAjax} .hasFatalError=${this.hasFatalError} .allowInstallToolPassword=${this.allowInstallToolPassword} .windowRef=${this.windowRef} @typo3:sudo-mode:verified=${()=>this.dispatchEvent(new Event("typo3:sudo-mode:verified"))}></typo3-backend-security-sudo-mode-form>`}).addEventListener("typo3-modal-hidden",()=>{this.dispatchEvent(new Event("typo3:sudo-mode:finished")),this.remove()})}getPropertyValues(){const e={},s=this.constructor;for(const o of s.elementProperties.keys())e[o]=this[o];return e}};f=r([m("typo3-backend-security-sudo-mode")],f);let p=class extends l{constructor(){super(...arguments),this.useInstallToolPassword=!1,this.errorMessage=null}createRenderRoot(){return this}render(){return this.hasFatalError?d`<div><div class="alert alert-danger">${this.labels.verificationExpired}</div></div>`:d`<div>${this.errorMessage?d`<div class="alert alert-danger" id=invalid-password>${this.labels[this.errorMessage]||this.errorMessage}</div>`:u}<p>${this.useInstallToolPassword?this.labels.sudoModeInstallToolPasswordExplanation:this.labels.sudoModeUserPasswordExplanation}</p><form method=post class=form id=verify-sudo-mode spellcheck=false @submit=${e=>this.verifyPassword(e)}>${this.useInstallToolPassword?u:d`<input hidden aria-hidden=true type=text autocomplete=username value=${TYPO3.configuration.username}>`}<div class=form-group><label class=form-label for=password>${this.labels.password}</label> <input required class=form-control id=password type=password name=password autofocus autocomplete=${this.useInstallToolPassword?"section-install current-password":"current-password"}></div></form>${this.allowInstallToolPassword?d`<div class=text-end><a href=# @click=${e=>this.toggleUseInstallToolPassword(e)}> ${this.useInstallToolPassword?this.labels.userPasswordMode:this.labels.installToolPasswordMode} </a></div>`:u}</div>`}updated(e){e.has("useInstallToolPassword")&&(this.closest("typo3-backend-modal").modalTitle=this.getModalTitle())}getModalTitle(){return this.hasFatalError?this.labels.verificationFailed:this.useInstallToolPassword?this.labels.verifyWithInstallToolPassword:this.labels.verifyWithUserPassword}async verifyPassword(e){e.preventDefault(),this.errorMessage=null;try{const o=await(await new I(this.verifyActionUri).post({password:this.passwordElement.value,useInstallToolPassword:this.useInstallToolPassword?1:0})).resolve("application/json");if(this.dispatchEvent(new Event("typo3:sudo-mode:verified")),this.closest("typo3-backend-modal").hideModal(),!this.isAjax&&o.redirect){const{uri:a}=o.redirect,t=this.windowRef??window;t.name==="list_frame"?E.ContentContainer.setUrl(a):t.location.assign(a)}}catch(s){if(s instanceof g){const o=await s.resolve("application/json");this.errorMessage=o.message}else throw s}}toggleUseInstallToolPassword(e){e.preventDefault(),this.useInstallToolPassword=!this.useInstallToolPassword}};r([w()],p.prototype,"useInstallToolPassword",void 0),r([w()],p.prototype,"errorMessage",void 0),r([b("#password")],p.prototype,"passwordElement",void 0),p=r([m("typo3-backend-security-sudo-mode-form")],p);export{f as SudoMode,p as SudoModeForm,v as initiateSudoModeModal};
