/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.impl.XsltApplyTemplatesImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltCallTemplateImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltElementImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltFunctionImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltParameterImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltStylesheetImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltTemplateImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltVariableImpl;
import org.intellij.lang.xpath.xslt.psi.impl.XsltWithParamImpl;
import org.jetbrains.annotations.Nullable;

class XsltElementFactoryImpl
extends XsltElementFactory {
    private static final Key<Pair<ASTNode, XsltElement>> WRAPPER = Key.create((String)"WRAPPER");

    XsltElementFactoryImpl() {
    }

    public XsltElement wrapElement(XmlTag target) {
        return this.wrapElement(target, XsltElement.class);
    }

    @Override
    public <T extends XsltElement> T wrapElement(XmlTag target, Class<T> clazz) {
        ASTNode nameNode;
        assert (target.isValid());
        Pair wrapper = (Pair)target.getUserData(WRAPPER);
        ASTNode tagNode = target.getNode();
        ASTNode aSTNode = nameNode = tagNode != null ? XmlChildRole.START_TAG_NAME_FINDER.findChild(tagNode) : null;
        if (wrapper != null && wrapper.getFirst() == nameNode && ((XsltElement)wrapper.second).isValid() && clazz.isAssignableFrom(((XsltElement)wrapper.second).getClass())) {
            return (T)((XsltElement)clazz.cast(wrapper.second));
        }
        assert (XsltSupport.isXsltTag(target)) : "Not an XSLT tag: {" + target.getNamespace() + "}" + target.getName();
        XsltElementImpl element = XsltSupport.isTemplate(target, false) ? new XsltTemplateImpl(target) : (XsltSupport.isVariable(target) ? new XsltVariableImpl(target) : (XsltSupport.isParam(target) ? new XsltParameterImpl(target) : (XsltSupport.isTemplateCall(target) ? new XsltCallTemplateImpl(target) : (XsltSupport.isApplyTemplates(target) ? new XsltApplyTemplatesImpl(target) : ("with-param".equals(target.getLocalName()) ? new XsltWithParamImpl(target) : (XsltSupport.isXsltRootTag(target) ? new XsltStylesheetImpl(target) : (XsltSupport.isFunction(target) ? new XsltFunctionImpl(target) : new DummyElementImpl(target))))))));
        if (!(element instanceof DummyElementImpl)) {
            target.putUserData(WRAPPER, (Object)Pair.create((Object)nameNode, (Object)element));
        }
        return (T)((XsltElement)clazz.cast(element));
    }

    private static class DummyElementImpl
    extends XsltElementImpl {
        DummyElementImpl(XmlTag target) {
            super(target);
        }

        @Nullable
        public String toString() {
            return "Unrecognized tag: " + this.getTag().getName();
        }
    }
}

