/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EscapeUtils {
    private static final char ESCAPE_CHAR = '\\';

    private EscapeUtils() {
    }

    @NotNull
    public static List<String> split(@NotNull String str, char delimiterChar) {
        if (str == null) {
            EscapeUtils.$$$reportNull$$$0(0);
        }
        Splitter splitter = new Splitter(str, delimiterChar);
        ArrayList out = Lists.newArrayList();
        while (splitter.hasNext()) {
            out.add(splitter.next());
        }
        ArrayList arrayList = out;
        if (arrayList == null) {
            EscapeUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String join(@NotNull Collection<String> list, char delimiterChar) {
        if (list == null) {
            EscapeUtils.$$$reportNull$$$0(2);
        }
        if (list.isEmpty()) {
            if ("" == null) {
                EscapeUtils.$$$reportNull$$$0(3);
            }
            return "";
        }
        int expectedSize = EscapeUtils.calcExpectedJoinedSize(list);
        StringBuilder out = new StringBuilder(expectedSize);
        boolean first = true;
        for (String s : list) {
            if (!first) {
                out.append(delimiterChar);
            }
            first = false;
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == delimiterChar || ch == '\\') {
                    out.append('\\');
                }
                out.append(ch);
            }
        }
        String string = out.toString();
        if (string == null) {
            EscapeUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static int calcExpectedJoinedSize(@NotNull Collection<String> list) {
        if (list == null) {
            EscapeUtils.$$$reportNull$$$0(5);
        }
        int size = list.size() - 1;
        for (String s : list) {
            size += s.length();
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/EscapeUtils";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/EscapeUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcExpectedJoinedSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Splitter {
        private final String myStr;
        private final char myDelimiterChar;
        private int myInd;
        private final StringBuilder myBuffer;
        private boolean myExtraEmptyString;

        Splitter(@NotNull String str, char delimiterChar) {
            if (str == null) {
                Splitter.$$$reportNull$$$0(0);
            }
            this.myBuffer = new StringBuilder();
            this.myExtraEmptyString = false;
            this.myStr = str;
            this.myDelimiterChar = delimiterChar;
            this.myInd = 0;
        }

        public boolean hasNext() {
            return this.myExtraEmptyString || this.myInd < this.myStr.length();
        }

        public String next() {
            if (this.myExtraEmptyString) {
                this.myExtraEmptyString = false;
                return "";
            }
            this.myBuffer.setLength(0);
            while (this.myInd < this.myStr.length()) {
                char ch = this.myStr.charAt(this.myInd);
                if (ch == this.myDelimiterChar) {
                    ++this.myInd;
                    this.myExtraEmptyString = this.myInd == this.myStr.length();
                    return this.myBuffer.toString();
                }
                if (ch == '\\') {
                    if (this.myInd + 1 >= this.myStr.length()) {
                        throw new RuntimeException("String ends with escape char: " + this.myStr);
                    }
                    char nextChar = this.myStr.charAt(this.myInd + 1);
                    if (nextChar == '\\' || nextChar == this.myDelimiterChar) {
                        this.myBuffer.append(nextChar);
                        this.myInd += 2;
                        continue;
                    }
                    throw new RuntimeException("Unexpected char is escaped '" + nextChar + "' in " + this.myStr);
                }
                this.myBuffer.append(ch);
                ++this.myInd;
            }
            return this.myBuffer.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/testFramework/util/EscapeUtils$Splitter", "<init>"));
        }
    }
}

