/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthorization;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GithubTokenCreator;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "createMaster", "Lorg/jetbrains/plugins/github/api/data/GithubAuthorization;", "noteSuffix", "", "safeCreate", "scopes", "", "note", "Companion", "intellij.vcs.github"})
public final class GithubTokenCreator {
    private final GithubServerPath server;
    private final GithubApiRequestExecutor executor;
    private final ProgressIndicator indicator;
    private static final List<String> MASTER_SCOPES;
    @NotNull
    public static final String DEFAULT_CLIENT_NAME = "Github Integration Plugin";
    public static final Companion Companion;

    @NotNull
    public final GithubAuthorization createMaster(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String noteSuffix) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)noteSuffix, (String)"noteSuffix");
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        return this.safeCreate(MASTER_SCOPES, stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" ").append(noteSuffix).append(" access token").toString());
    }

    /*
     * WARNING - void declaration
     */
    private final GithubAuthorization safeCreate(List<String> scopes, String note) throws IOException {
        try {
            return this.executor.execute(this.indicator, GithubApiRequests.Auth.create(this.server, scopes, note));
        }
        catch (GithubStatusCodeException e) {
            if (e.getError() != null) {
                GithubErrorMessage githubErrorMessage = e.getError();
                if (githubErrorMessage == null) {
                    Intrinsics.throwNpe();
                }
                if (githubErrorMessage.containsErrorCode("already_exists")) {
                    List<GithubAuthorization> current = this.executor.execute(this.indicator, GithubApiRequests.Auth.get(this.server));
                    int n = 1;
                    int n2 = 99;
                    while (n <= n2) {
                        Object v1;
                        String newNote;
                        void i;
                        block8: {
                            Iterable iterable;
                            newNote = note + "_" + (int)i;
                            Iterable iterable2 = iterable = (Iterable)current;
                            for (Object t : iterable2) {
                                GithubAuthorization authorization = (GithubAuthorization)t;
                                if (!StringsKt.equals((String)newNote, (String)authorization.getNote(), (boolean)true)) continue;
                                v1 = t;
                                break block8;
                            }
                            v1 = null;
                        }
                        if (v1 == null) {
                            return this.executor.execute(this.indicator, GithubApiRequests.Auth.create(this.server, scopes, newNote));
                        }
                        ++i;
                    }
                }
            }
            throw (Throwable)e;
        }
    }

    public GithubTokenCreator(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        this.server = server;
        this.executor = executor;
        this.indicator = indicator;
    }

    static {
        Companion = new Companion(null);
        MASTER_SCOPES = CollectionsKt.listOf((Object[])new String[]{"repo", "gist"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GithubTokenCreator$Companion;", "", "()V", "DEFAULT_CLIENT_NAME", "", "MASTER_SCOPES", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

