/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBinaryContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.status.Status;

public class SvnContentRevision
extends SvnBaseContentRevision
implements ByteBackedContentRevision {
    @NotNull
    private final Revision myRevision;
    private final boolean myUseBaseRevision;

    protected SvnContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision, boolean useBaseRevision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(2);
        }
        super(vcs, file);
        this.myRevision = revision;
        this.myUseBaseRevision = useBaseRevision;
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Status status) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(4);
        }
        if (status == null) {
            SvnContentRevision.$$$reportNull$$$0(5);
        }
        Revision revision = status.getRevision().isValid() ? status.getRevision() : status.getCommittedRevision();
        SvnContentRevision svnContentRevision = SvnContentRevision.createBaseRevision(vcs, file, revision);
        if (svnContentRevision == null) {
            SvnContentRevision.$$$reportNull$$$0(6);
        }
        return svnContentRevision;
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(7);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(8);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(9);
        }
        if (file.getFileType().isBinary()) {
            SvnBinaryContentRevision svnBinaryContentRevision = new SvnBinaryContentRevision(vcs, file, revision, true);
            if (svnBinaryContentRevision == null) {
                SvnContentRevision.$$$reportNull$$$0(10);
            }
            return svnBinaryContentRevision;
        }
        SvnContentRevision svnContentRevision = new SvnContentRevision(vcs, file, revision, true);
        if (svnContentRevision == null) {
            SvnContentRevision.$$$reportNull$$$0(11);
        }
        return svnContentRevision;
    }

    @NotNull
    public static SvnContentRevision createRemote(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(12);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(13);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(14);
        }
        if (file.getFileType().isBinary()) {
            SvnBinaryContentRevision svnBinaryContentRevision = new SvnBinaryContentRevision(vcs, file, revision, false);
            if (svnBinaryContentRevision == null) {
                SvnContentRevision.$$$reportNull$$$0(15);
            }
            return svnBinaryContentRevision;
        }
        SvnContentRevision svnContentRevision = new SvnContentRevision(vcs, file, revision, false);
        if (svnContentRevision == null) {
            SvnContentRevision.$$$reportNull$$$0(16);
        }
        return svnContentRevision;
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.myFile, null);
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        try {
            if (this.myUseBaseRevision) {
                return (byte[])ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsKey)this.myVcs.getKeyInstanceMethod(), (CurrentRevisionProvider)new CurrentRevisionProvider(){

                    public VcsRevisionNumber getCurrentRevision() {
                        return SvnContentRevision.this.getRevisionNumber();
                    }

                    public Pair<VcsRevisionNumber, byte[]> get() throws VcsException {
                        return Pair.create((Object)SvnContentRevision.this.getRevisionNumber(), (Object)SvnContentRevision.this.getUpToDateBinaryContent());
                    }
                }).getSecond();
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, () -> this.getUpToDateBinaryContent());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] getUpToDateBinaryContent() throws VcsException {
        File file = this.myFile.getIOFile();
        File lock = new File(file.getParentFile(), SvnUtil.PATH_TO_LOCK_FILE);
        if (lock.exists()) {
            throw new VcsException("Can not access file base revision contents: administrative area is locked");
        }
        return SvnUtil.getFileContents(this.myVcs, Target.on(file), this.myUseBaseRevision ? Revision.BASE : this.myRevision, Revision.UNDEFINED);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        SvnRevisionNumber svnRevisionNumber = new SvnRevisionNumber(this.myRevision);
        if (svnRevisionNumber == null) {
            SvnContentRevision.$$$reportNull$$$0(17);
        }
        return svnRevisionNumber;
    }

    @NonNls
    public String toString() {
        return this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnContentRevision";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseRevision";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemote";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBaseRevision";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

