/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.config.DefaultRepositoryUrlFilter;
import org.jetbrains.idea.svn.config.PatternsListener;
import org.jetbrains.idea.svn.config.RepositoryUrlsListener;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;

public class RepositoryUrlFilter
implements PatternsListener {
    private final RepositoryUrlsListener myListener;
    private final DefaultRepositoryUrlFilter myDefaultFilter;

    public RepositoryUrlFilter(RepositoryUrlsListener listener, SvnConfigureProxiesComponent component, RepositoryUrlsListener defaultGroupListener) {
        this.myListener = listener;
        this.myDefaultFilter = new DefaultRepositoryUrlFilter(component, defaultGroupListener);
    }

    @Override
    public void onChange(String patterns, String exceptions) {
        Collection<String> urls = SvnApplicationSettings.getInstance().getCheckoutURLs();
        ArrayList<String> result = new ArrayList<String>();
        for (String url : urls) {
            if (!IdeaSVNConfigFile.checkHostGroup(url, patterns, exceptions)) continue;
            result.add(url);
        }
        Collections.sort(result);
        this.myListener.onListChanged(result);
        this.myDefaultFilter.execute(urls);
    }
}

