/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;

public class ExportOptionsDialog
extends DialogWrapper
implements ActionListener {
    private final Url myURL;
    private final Project myProject;
    private final File myFile;
    private TextFieldWithBrowseButton myPathField;
    private DepthCombo myDepth;
    private JCheckBox myExternalsCheckbox;
    private JCheckBox myForceCheckbox;
    private JComboBox myEOLStyleBox;

    public ExportOptionsDialog(Project project, Url url, File target) {
        super(project, true);
        this.myURL = url;
        this.myProject = project;
        this.myFile = target;
        this.setTitle("SVN Export Options");
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.export.options";
    }

    public File getTarget() {
        return new File(this.myPathField.getText());
    }

    public Depth getDepth() {
        return this.myDepth.getDepth();
    }

    public boolean isForce() {
        return this.myForceCheckbox.isSelected();
    }

    public boolean isIgnoreExternals() {
        return !this.myExternalsCheckbox.isSelected();
    }

    public String getEOLStyle() {
        if (this.myEOLStyleBox.getSelectedIndex() == 0) {
            return null;
        }
        return (String)this.myEOLStyleBox.getSelectedItem();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel.add((Component)new JLabel("Export:"), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        JLabel urlLabel = new JLabel(this.myURL.toDecodedString());
        urlLabel.setFont(urlLabel.getFont().deriveFont(1));
        panel.add((Component)urlLabel, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        panel.add((Component)new JLabel("Destination:"), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.myPathField = new TextFieldWithBrowseButton((ActionListener)this);
        this.myPathField.setText(this.myFile.getAbsolutePath());
        this.myPathField.setEditable(false);
        panel.add((Component)this.myPathField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        JLabel depthLabel = new JLabel(SvnBundle.message("label.depth.text", new Object[0]));
        depthLabel.setToolTipText(SvnBundle.message("label.depth.description", new Object[0]));
        panel.add((Component)depthLabel, gc);
        ++gc.gridx;
        this.myDepth = new DepthCombo(false);
        panel.add((Component)this.myDepth, gc);
        depthLabel.setLabelFor(this.myDepth);
        gc.gridx = 0;
        ++gc.gridy;
        this.myForceCheckbox = new JCheckBox("Replace existing files");
        this.myForceCheckbox.setSelected(true);
        panel.add((Component)this.myForceCheckbox, gc);
        ++gc.gridy;
        this.myExternalsCheckbox = new JCheckBox("Include externals locations");
        this.myExternalsCheckbox.setSelected(true);
        panel.add((Component)this.myExternalsCheckbox, gc);
        ++gc.gridy;
        gc.gridwidth = 2;
        panel.add((Component)new JLabel("Override 'native' EOLs with:"), gc);
        gc.gridx += 2;
        gc.gridwidth = 1;
        this.myEOLStyleBox = new JComboBox<Object>(new Object[]{"None", "LF", "CRLF", "CR"});
        panel.add((Component)this.myEOLStyleBox, gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 15;
        gc.fill = 2;
        panel.add((Component)new JSeparator(), gc);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle("Export Directory");
        fcd.setDescription("Select directory to export from subversion");
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Component)this.getContentPane(), (Project)this.myProject, null);
        if (file == null) {
            return;
        }
        this.myPathField.setText(file.getPath().replace('/', File.separatorChar));
    }
}

