/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.dfs.DfsRefRename;
import org.eclipse.jgit.internal.storage.dfs.DfsRefUpdate;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

public abstract class DfsRefDatabase
extends RefDatabase {
    private final DfsRepository repository;
    private final AtomicReference<RefCache> cache;

    protected DfsRefDatabase(DfsRepository repository) {
        this.repository = repository;
        this.cache = new AtomicReference();
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    boolean exists() throws IOException {
        return 0 < this.read().size();
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        RefCache curr = this.read();
        Ref ref = curr.ids.get(name);
        return ref != null ? this.resolve(ref, 0, curr.ids) : null;
    }

    @Override
    public Ref getRef(String needle) throws IOException {
        RefCache curr = this.read();
        for (String prefix : SEARCH_PATH) {
            Ref ref = curr.ids.get(prefix + needle);
            if (ref == null) continue;
            ref = this.resolve(ref, 0, curr.ids);
            return ref;
        }
        return null;
    }

    @Override
    public List<Ref> getAdditionalRefs() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefCache curr = this.read();
        RefList packed = RefList.emptyList();
        RefList<Ref> loose = curr.ids;
        RefList.Builder<Ref> sym = new RefList.Builder<Ref>(curr.sym.size());
        for (int idx = 0; idx < curr.sym.size(); ++idx) {
            Ref ref = curr.sym.get(idx);
            String name = ref.getName();
            if ((ref = this.resolve(ref, 0, loose)) != null && ref.getObjectId() != null) {
                sym.add(ref);
                continue;
            }
            int toRemove = loose.find(name);
            if (0 > toRemove) continue;
            loose = loose.remove(toRemove);
        }
        return new RefMap(prefix, packed, loose, sym.toRefList());
    }

    private Ref resolve(Ref ref, int depth, RefList<Ref> loose) throws IOException {
        if (!ref.isSymbolic()) {
            return ref;
        }
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if ((dst = loose.get(dst.getName())) == null) {
            return ref;
        }
        if ((dst = this.resolve(dst, depth + 1, loose)) == null) {
            return null;
        }
        return new SymbolicRef(ref.getName(), dst);
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        Ref oldLeaf = ref.getLeaf();
        if (oldLeaf.isPeeled() || oldLeaf.getObjectId() == null) {
            return ref;
        }
        Ref newLeaf = this.doPeel(oldLeaf);
        RefCache cur = this.read();
        int idx = cur.ids.find(oldLeaf.getName());
        if (0 <= idx && cur.ids.get(idx) == oldLeaf) {
            RefList<Ref> newList = cur.ids.set(idx, newLeaf);
            this.cache.compareAndSet(cur, new RefCache(newList, cur));
            this.cachePeeledState(oldLeaf, newLeaf);
        }
        return DfsRefDatabase.recreate(ref, newLeaf);
    }

    Ref doPeel(Ref leaf) throws MissingObjectException, IOException {
        try (RevWalk rw = new RevWalk(this.repository);){
            RevObject obj = rw.parseAny(leaf.getObjectId());
            if (obj instanceof RevTag) {
                ObjectIdRef.PeeledTag peeledTag = new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj).copy());
                return peeledTag;
            }
            ObjectIdRef.PeeledNonTag peeledNonTag = new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId());
            return peeledNonTag;
        }
    }

    static Ref recreate(Ref old, Ref leaf) {
        if (old.isSymbolic()) {
            Ref dst = DfsRefDatabase.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    @Override
    public RefUpdate newUpdate(String refName, boolean detach) throws IOException {
        boolean detachingSymbolicRef = false;
        Ref ref = this.exactRef(refName);
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, refName, null);
        } else {
            detachingSymbolicRef = detach && ref.isSymbolic();
        }
        DfsRefUpdate update = new DfsRefUpdate(this, ref);
        if (detachingSymbolicRef) {
            update.setDetachingSymbolicRef();
        }
        return update;
    }

    @Override
    public RefRename newRename(String fromName, String toName) throws IOException {
        RefUpdate src = this.newUpdate(fromName, true);
        RefUpdate dst = this.newUpdate(toName, true);
        return new DfsRefRename(src, dst);
    }

    @Override
    public boolean isNameConflicting(String refName) throws IOException {
        RefList<Ref> all = this.read().ids;
        int lastSlash = refName.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = refName.substring(0, lastSlash);
            if (all.contains(needle)) {
                return true;
            }
            lastSlash = refName.lastIndexOf(47, lastSlash - 1);
        }
        String prefix = refName + '/';
        int idx = -(all.find(prefix) + 1);
        return idx < all.size() && all.get(idx).getName().startsWith(prefix);
    }

    @Override
    public void create() {
    }

    @Override
    public void refresh() {
        this.clearCache();
    }

    @Override
    public void close() {
        this.clearCache();
    }

    void clearCache() {
        this.cache.set(null);
    }

    void stored(Ref ref) {
        RefCache newCache;
        RefCache oldCache;
        do {
            if ((oldCache = this.cache.get()) != null) continue;
            return;
        } while (!this.cache.compareAndSet(oldCache, newCache = oldCache.put(ref)));
    }

    void removed(String refName) {
        RefCache newCache;
        RefCache oldCache;
        do {
            if ((oldCache = this.cache.get()) != null) continue;
            return;
        } while (!this.cache.compareAndSet(oldCache, newCache = oldCache.remove(refName)));
    }

    private RefCache read() throws IOException {
        RefCache c = this.cache.get();
        if (c == null) {
            c = this.scanAllRefs();
            this.cache.set(c);
        }
        return c;
    }

    protected abstract RefCache scanAllRefs() throws IOException;

    protected abstract boolean compareAndPut(Ref var1, Ref var2) throws IOException;

    protected abstract boolean compareAndRemove(Ref var1) throws IOException;

    protected void cachePeeledState(Ref oldLeaf, Ref newLeaf) {
        try {
            this.compareAndPut(oldLeaf, newLeaf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class RefCache {
        final RefList<Ref> ids;
        final RefList<Ref> sym;

        public RefCache(RefList<Ref> ids, RefList<Ref> sym) {
            this.ids = ids;
            this.sym = sym;
        }

        RefCache(RefList<Ref> ids, RefCache old) {
            this(ids, old.sym);
        }

        public int size() {
            return this.ids.size();
        }

        public Ref get(String name) {
            return this.ids.get(name);
        }

        public RefCache put(Ref ref) {
            RefList<Ref> newIds = this.ids.put(ref);
            RefList<Ref> newSym = this.sym;
            if (ref.isSymbolic()) {
                newSym = newSym.put(ref);
            } else {
                int p = newSym.find(ref.getName());
                if (0 <= p) {
                    newSym = newSym.remove(p);
                }
            }
            return new RefCache(newIds, newSym);
        }

        public RefCache remove(String refName) {
            RefList<Ref> newSym;
            RefList<Ref> newIds = this.ids;
            int p = newIds.find(refName);
            if (0 <= p) {
                newIds = newIds.remove(p);
            }
            if (0 <= (p = (newSym = this.sym).find(refName))) {
                newSym = newSym.remove(p);
            }
            return new RefCache(newIds, newSym);
        }
    }
}

