/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.actions.EntryDataGetter;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import icons.NodeJSIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MarkUnmarkAction
extends DumbAwareAction {
    public static final DataKey<V8HeapEntry> SELECTED_NODE = DataKey.create((String)"V8_SELECTED_NODE");
    public static final DataKey<Boolean> UNREACHABLE_NODE = DataKey.create((String)"V8_UNREACHABLE_NODE");
    public static final DataKey<Long> SELECTED_LINK = DataKey.create((String)"V8_SELECTED_LINK");
    public static final DataKey<Runnable> REVALIDATION = DataKey.create((String)"V8_REPAINT_REVALIDATE");
    @NonNls
    public static final String MARK = "Mark";
    @NonNls
    public static final String MARK_OBJECT_WITH_TEXT = "Mark object with text";
    private final V8HeapComponent myHeapComponent;
    private final ByteArrayWrapper myDigest;
    private TreeTable myTable;

    public MarkUnmarkAction(@NotNull Project project, @NotNull V8CachingReader reader) {
        if (project == null) {
            MarkUnmarkAction.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            MarkUnmarkAction.$$$reportNull$$$0(1);
        }
        super(MARK, MARK_OBJECT_WITH_TEXT, NodeJSIcons.MarkObject);
        this.myDigest = reader.getDigest();
        this.myHeapComponent = V8HeapComponent.getInstance(project);
    }

    public void setTable(TreeTable table) {
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkUnmarkAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        EntryDataGetter getter = new EntryDataGetter(e.getDataContext(), this.myTable);
        V8HeapEntry data = getter.getData();
        e.getPresentation().setEnabled(data != null && data.getId() != 0L && getter.getRunnable() != null && getter.getProject() != null);
        if (data != null && this.myHeapComponent.getMark(this.myDigest, data) != null) {
            e.getPresentation().setText("Remove Mark");
            e.getPresentation().setDescription("Remove mark from object");
            e.getPresentation().setIcon(NodeJSIcons.UnmarkObject);
        } else if (data != null) {
            e.getPresentation().setText(MARK);
            e.getPresentation().setDescription(MARK_OBJECT_WITH_TEXT);
            e.getPresentation().setIcon(NodeJSIcons.MarkObject);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkUnmarkAction.$$$reportNull$$$0(3);
        }
        EntryDataGetter getter = new EntryDataGetter(e.getDataContext(), this.myTable);
        V8HeapEntry entry = getter.getData();
        Runnable runnable = getter.getRunnable();
        Project project = getter.getProject();
        if (project == null) {
            return;
        }
        if (entry != null && runnable != null) {
            MarkUnmarkAction.markOrUnmark(entry, project, this.myHeapComponent, this.myDigest);
            runnable.run();
        }
    }

    public static void markOrUnmark(@NotNull V8HeapEntry entry, @NotNull Project project, @NotNull V8HeapComponent heapComponent, @NotNull ByteArrayWrapper digest) {
        if (entry == null) {
            MarkUnmarkAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            MarkUnmarkAction.$$$reportNull$$$0(5);
        }
        if (heapComponent == null) {
            MarkUnmarkAction.$$$reportNull$$$0(6);
        }
        if (digest == null) {
            MarkUnmarkAction.$$$reportNull$$$0(7);
        }
        if (!StringUtil.isEmptyOrSpaces((String)heapComponent.getMark(digest, entry))) {
            heapComponent.markOrUnmark(digest, entry, "");
        } else {
            String text = Messages.showInputDialog((Project)project, (String)("Mark node @" + entry.getSnapshotObjectId() + " with text: "), (String)"Mark Heap Object", (Icon)Messages.getQuestionIcon());
            if (!StringUtil.isEmptyOrSpaces((String)text)) {
                heapComponent.markOrUnmark(digest, entry, text);
            }
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("V8 Heap");
        if (window != null) {
            JComponent component = window.getComponent();
            component.revalidate();
            component.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/actions/MarkUnmarkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "markOrUnmark";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

