/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.wraptag;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseTagRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.wraptag.WrapTagDialog;
import com.sixrr.xrp.wraptag.WrapTagProcessor;

class WrapTagHandler
extends BaseTagRefactoringHandler {
    WrapTagHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.wrapTag";
    }

    @Override
    protected String getRefactoringName() {
        return "Wrap Tag";
    }

    @Override
    protected void handleTag(XmlTag tag, Project project) {
        WrapTagDialog dialog = new WrapTagDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String attributeName = dialog.getWrappingTagName();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            WrapTagProcessor processor = new WrapTagProcessor(tag, attributeName, context);
            processor.setPreviewUsages(previewUsages);
            processor.run();
        }, "Wrap Tag", null);
    }
}

