/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDelegatingMethodsUtil {
    @NotNull
    private static ResolveResult[] resolveCandidates(@NotNull JSCallExpression callExpression, @NotNull JSExpression methodExpression) {
        if (callExpression == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(1);
        }
        boolean isNewCall = callExpression instanceof JSNewExpression;
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] candidates = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (isNewCall) {
                if (candidates.length != 1) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(2);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                if (!candidates[0].isValidResult()) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(3);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                PsiElement classElement = candidates[0].getElement();
                if (!(classElement instanceof JSClass)) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(4);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                JSFunction constructor = ((JSClass)classElement).getConstructor();
                if (!(constructor instanceof TypeScriptFunction)) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(5);
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ResolveResult[] resolveResultArray = (ResolveResult[])TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)constructor).stream().filter(s -> s instanceof TypeScriptFunction && !((TypeScriptFunction)s).isOverloadImplementation()).map(c -> new JSResolveResult((PsiElement)c)).toArray(ResolveResult[]::new);
                if (resolveResultArray == null) {
                    TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(6);
                }
                return resolveResultArray;
            }
            if (candidates == null) {
                TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(7);
            }
            return candidates;
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiReference reference = methodExpression.getReference();
            if (reference == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(8);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiElement parentElement = reference.resolve();
            if (!(parentElement instanceof TypeScriptFunction)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(9);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)parentElement).stream().filter(s -> s instanceof TypeScriptFunction && !((TypeScriptFunction)s).isOverloadImplementation()).map(c -> new JSResolveResult((PsiElement)c)).toArray(ResolveResult[]::new);
            if (resolveResultArray == null) {
                TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(10);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(11);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static void processDelegationCandidates(@NotNull JSReferenceExpression location, @NotNull ProcessorDelegate processor, boolean allowSingleParameter) {
        PsiElement parent;
        if (location == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(13);
        }
        if (!((parent = location.getParent()) instanceof JSArgumentList)) {
            return;
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        if (arguments.length != 1 || arguments[0] != location) {
            return;
        }
        PsiElement call = parent.getParent();
        if (!(call instanceof JSCallExpression)) {
            return;
        }
        TypeScriptDelegatingMethodsUtil.processDelegationCandidates((JSCallExpression)call, processor, allowSingleParameter);
    }

    public static void processDelegationCandidates(@NotNull JSCallExpression call, @NotNull ProcessorDelegate processor, boolean allowSingleParameter) {
        JSExpression methodExpression;
        ResolveResult[] candidates;
        if (call == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(15);
        }
        if ((candidates = TypeScriptDelegatingMethodsUtil.resolveCandidates(call, methodExpression = call.getMethodExpression())).length == 0) {
            return;
        }
        JSFunction container = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)call, JSFunction.class);
        while (container != null) {
            JSParameterList parameterList = container.getParameterList();
            if (parameterList != null) {
                for (ResolveResult candidate : candidates) {
                    JSFunction candidateFunction;
                    JSParameterList candidateFunctionParameterList;
                    PsiElement candidateElement;
                    if (!candidate.isValidResult() || !((candidateElement = candidate.getElement()) instanceof JSFunction) || (candidateFunctionParameterList = (candidateFunction = (JSFunction)candidateElement).getParameterList()) == null || (!allowSingleParameter || candidateFunctionParameterList.getParameters().length < 1) && (allowSingleParameter || parameterList.getParameters().length <= 1 || candidateFunctionParameterList.getParameters().length <= 1)) continue;
                    processor.process(methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList);
                }
            }
            container = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)container, JSFunction.class);
        }
    }

    @Nullable
    public static JSFunction getMethodToTakeParametersFrom(@NotNull JSExpression methodExpression, @NotNull JSFunction container, @NotNull JSFunction candidateFunction, @NotNull JSParameterList parameterList, @NotNull JSParameterList candidateFunctionParameterList, @NotNull Ref<? super Boolean> invertedOrder, boolean incompleteMatch) {
        if (methodExpression == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(16);
        }
        if (container == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(17);
        }
        if (candidateFunction == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(18);
        }
        if (parameterList == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(19);
        }
        if (candidateFunctionParameterList == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(20);
        }
        if (invertedOrder == null) {
            TypeScriptDelegatingMethodsUtil.$$$reportNull$$$0(21);
        }
        if (methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSSuperExpression) {
            return candidateFunction;
        }
        HashMap requiredNames = ContainerUtil.newHashMap();
        JSParameterListElement[] parameters = parameterList.getParameters();
        JSParameterListElement[] callParams = candidateFunctionParameterList.getParameters();
        if (!incompleteMatch && callParams.length > parameters.length || incompleteMatch && (callParams.length - parameters.length > 2 || callParams.length < parameters.length)) {
            return null;
        }
        boolean checkNames = container.isConstructor();
        boolean sameTypes = true;
        JSGenericTypesEvaluator genericTypesEvaluator = JSGenericTypesEvaluator.getEvaluator((PsiElement)container);
        for (int i = 0; i < (incompleteMatch ? parameters.length : callParams.length); ++i) {
            JSParameterListElement callParam = callParams[i];
            JSParameterListElement parameter = parameters[i];
            JSType callParamType = genericTypesEvaluator.evaluateGenerics(callParam.getType(), methodExpression, (PsiElement)candidateFunction);
            requiredNames.put(callParam.getName(), callParamType);
            JSType parameterType = genericTypesEvaluator.evaluateGenerics(parameter.getType(), methodExpression, (PsiElement)candidateFunction);
            if (!(checkNames && !Comparing.equal((String)parameter.getName(), (String)callParam.getName()) || callParamType == null && parameterType != null || parameterType == null && callParamType != null) && (callParamType == null || callParamType.isEquivalentTo(parameterType, null, true))) continue;
            sameTypes = false;
        }
        if (sameTypes && (incompleteMatch && callParams.length - parameters.length <= 2 || !incompleteMatch && callParams.length == parameters.length)) {
            return candidateFunction;
        }
        invertedOrder.set((Object)true);
        for (JSParameterListElement parameter : parameters) {
            JSType type = (JSType)requiredNames.remove(parameter.getName());
            JSType parameterType = genericTypesEvaluator.evaluateGenerics(parameter.getType(), methodExpression, (PsiElement)container);
            if (type == null || type.isEquivalentTo(parameterType, null, true)) continue;
            return null;
        }
        return requiredNames.isEmpty() ? candidateFunction : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptDelegatingMethodsUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunctionParameterList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invertedOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptDelegatingMethodsUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveCandidates";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDelegationCandidates";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMethodToTakeParametersFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProcessorDelegate {
        public void process(@NotNull JSExpression var1, @NotNull JSFunction var2, @NotNull JSFunction var3, @NotNull JSParameterList var4, @NotNull JSParameterList var5);
    }
}

