/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DebugLogManagerKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bJ2\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bJ4\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bJ\b\u0010\u0014\u001a\u00020\u0006H\u0016J \u0010\u0015\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bJ,\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/DebugLogManager;", "Lcom/intellij/openapi/components/BaseComponent;", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "(Lcom/intellij/ide/util/PropertiesComponent;)V", "applyCategories", "", "categories", "", "Lkotlin/Pair;", "", "Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "level", "log4jLevel", "Lorg/apache/log4j/Level;", "clearCategories", "fromString", "kotlin.jvm.PlatformType", "text", "getSavedCategories", "initComponent", "saveCategories", "toString", "DebugLogLevel", "intellij.platform.ide.impl"})
public final class DebugLogManager
implements BaseComponent {
    private final PropertiesComponent properties;

    public void initComponent() {
        List categories = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.getSavedCategories(), (Iterable)this.fromString(System.getProperty("idea.log.debug.categories"), DebugLogLevel.DEBUG)), (Iterable)this.fromString(System.getProperty("idea.log.trace.categories"), DebugLogLevel.TRACE));
        this.applyCategories(categories);
    }

    @NotNull
    public final List<Pair<String, DebugLogLevel>> getSavedCategories() {
        return CollectionsKt.plus((Collection)this.fromString(this.properties.getValue("log.debug.categories"), DebugLogLevel.DEBUG), (Iterable)this.fromString(this.properties.getValue("log.trace.categories"), DebugLogLevel.TRACE));
    }

    public final void clearCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Iterable $receiver$iv = categories;
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            Logger logger = LogManager.getLogger((String)((String)it.getFirst()));
            if (logger == null) continue;
            logger.setLevel((Level)null);
        }
    }

    public final void applyCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.applyCategories(categories, DebugLogLevel.DEBUG, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        this.applyCategories(categories, DebugLogLevel.TRACE, level2);
    }

    private final void applyCategories(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level, Level log4jLevel) {
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = categories;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!((DebugLogLevel)((Object)it.getSecond()) == level)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = (String)it.getFirst();
            collection.add(string);
        }
        List filtered = (List)destination$iv$iv;
        $receiver$iv = filtered;
        for (Object element$iv : $receiver$iv) {
            String it2 = (String)element$iv;
            Logger logger = LogManager.getLogger((String)it2);
            if (logger == null) continue;
            logger.setLevel(log4jLevel);
        }
        if (!filtered.isEmpty()) {
            DebugLogManagerKt.access$getLOG$p().info("Set " + level.name() + " for the following categories: " + CollectionsKt.joinToString$default((Iterable)filtered, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    public final void saveCategories(@NotNull List<? extends Pair<String, ? extends DebugLogLevel>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        this.properties.setValue("log.debug.categories", this.toString(categories, DebugLogLevel.DEBUG), null);
        this.properties.setValue("log.trace.categories", this.toString(categories, DebugLogLevel.TRACE), null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, DebugLogLevel>> fromString(String text, DebugLogLevel level) {
        List list2;
        if (text != null) {
            void $receiver$iv$iv;
            String[] $receiver$iv;
            String[] stringArray = StringUtil.splitByLines((String)text, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"StringUtil.splitByLines(text, true)");
            String[] stringArray2 = $receiver$iv = stringArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var6_6 = $receiver$iv$iv;
            int n = ((void)var6_6).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = var6_6[i];
                Collection collection = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it, (Object)((Object)level));
                collection.add(pair);
            }
            list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final String toString(List<? extends Pair<String, ? extends DebugLogLevel>> categories, DebugLogLevel level) {
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)categories;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!((DebugLogLevel)((Object)it.getSecond()) == level)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = (String)it.getFirst();
            collection.add(string);
        }
        List filtered = (List)destination$iv$iv;
        Collection collection = filtered;
        return !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)filtered, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
    }

    public DebugLogManager(@NotNull PropertiesComponent properties) {
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        this.properties = properties;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/DebugLogManager$DebugLogLevel;", "", "(Ljava/lang/String;I)V", "DEBUG", "TRACE", "intellij.platform.ide.impl"})
    public static final class DebugLogLevel
    extends Enum<DebugLogLevel> {
        public static final /* enum */ DebugLogLevel DEBUG;
        public static final /* enum */ DebugLogLevel TRACE;
        private static final /* synthetic */ DebugLogLevel[] $VALUES;

        static {
            DebugLogLevel[] debugLogLevelArray = new DebugLogLevel[2];
            DebugLogLevel[] debugLogLevelArray2 = debugLogLevelArray;
            debugLogLevelArray[0] = DEBUG = new DebugLogLevel();
            debugLogLevelArray[1] = TRACE = new DebugLogLevel();
            $VALUES = debugLogLevelArray;
        }

        public static DebugLogLevel[] values() {
            return (DebugLogLevel[])$VALUES.clone();
        }

        public static DebugLogLevel valueOf(String string) {
            return Enum.valueOf(DebugLogLevel.class, string);
        }
    }
}

