/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationSelectionUtil {
    @NotNull
    public static String getDisplayText(@NotNull RunConfiguration configuration, @Nullable ExecutionTarget target2) {
        if (configuration == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(0);
        }
        String string = configuration.getType().getDisplayName() + " '" + configuration.getName() + "'" + (target2 != null && target2 != DefaultExecutionTarget.INSTANCE ? " | " + target2.getDisplayName() : "");
        if (string == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static ListPopup createPopup(final @NotNull Project project, final @NotNull RunManagerImpl runManager, final @NotNull List<? extends RunConfiguration> configurations, final @NotNull BiConsumer<? super List<RunConfiguration>, ? super ExecutionTarget> onSelected) {
        if (project == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(2);
        }
        if (runManager == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(3);
        }
        if (configurations == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(4);
        }
        if (onSelected == null) {
            ConfigurationSelectionUtil.$$$reportNull$$$0(5);
        }
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<RunConfiguration>(null, configurations){

            @Nullable
            public ListSeparator getSeparatorAbove(RunConfiguration value) {
                int i = configurations.indexOf(value);
                if (i < 1) {
                    return null;
                }
                RunConfiguration previous = (RunConfiguration)configurations.get(i - 1);
                return value.getType() != previous.getType() ? new ListSeparator() : null;
            }

            public Icon getIconFor(RunConfiguration value) {
                return value.getType().getIcon();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(RunConfiguration value) {
                String string = value.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public PopupStep<?> onChosen(final List<RunConfiguration> selectedConfigs, boolean finalChoice) {
                if (finalChoice) {
                    onSelected.accept(selectedConfigs, null);
                    return FINAL_CHOICE;
                }
                return new BaseListPopupStep<ExecutionTarget>(null, this.getTargets(selectedConfigs)){

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    public Icon getIconFor(ExecutionTarget value) {
                        return value.getIcon();
                    }

                    @NotNull
                    public String getTextFor(ExecutionTarget value) {
                        String string = value.getDisplayName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep onChosen(ExecutionTarget selectedTarget, boolean finalChoice) {
                        onSelected.accept(selectedConfigs, selectedTarget);
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/compound/ConfigurationSelectionUtil$1$1", "getTextFor"));
                    }
                };
            }

            @Override
            public boolean hasSubstep(List<RunConfiguration> selectedValues) {
                return !this.getTargets(selectedValues).isEmpty();
            }

            @NotNull
            public List<ExecutionTarget> getTargets(List<RunConfiguration> selectedValues) {
                LinkedHashSet intersection = new LinkedHashSet();
                for (int i = 0; i < selectedValues.size(); ++i) {
                    RunConfiguration config2 = selectedValues.get(i);
                    List targets = ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunnerAndConfigurationSettings)runManager.getSettings(config2));
                    if (i == 0) {
                        intersection.addAll(targets);
                        continue;
                    }
                    intersection.retainAll(targets);
                }
                ArrayList<ExecutionTarget> arrayList = new ArrayList<ExecutionTarget>(intersection);
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/execution/compound/ConfigurationSelectionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextFor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTargets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/compound/ConfigurationSelectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSelected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/compound/ConfigurationSelectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayText";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

