/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="MainMenuCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="statistics.main_menu.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class MainMenuCollector
implements PersistentStateComponent<State> {
    private static final String GROUP_ID = "statistics.actions.main.menu.v2";
    private static final String GENERATED_ON_RUNTIME_ITEM = "generated.on.runtime";
    private State myState = new State();
    private static final HashMap<String, String> ourBlackList = new HashMap();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            MainMenuCollector.$$$reportNull$$$0(0);
        }
    }

    public void record(@NotNull AnAction action) {
        if (action == null) {
            MainMenuCollector.$$$reportNull$$$0(1);
        }
        try {
            PluginType type = StatisticsUtilKt.getPluginType(action.getClass());
            if (!type.isDevelopedByJetBrains()) {
                return;
            }
            AWTEvent e = EventQueue.getCurrentEvent();
            String path = null;
            if (e instanceof ItemEvent) {
                path = this.getPathFromMenuItem(e, action);
            } else if (e instanceof MouseEvent) {
                path = this.getPathFromMenuSelectionManager(action);
            }
            if (!StringUtil.isEmpty((String)path)) {
                String key = ConvertUsagesUtil.escapeDescriptorName(path);
                FeatureUsageLogger.INSTANCE.log(GROUP_ID, key, FUSUsageContext.OS_CONTEXT.getData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Pair<Double, Double> findBucket(double value, double ... ranges) {
        if (ranges.length == 0) {
            throw new IllegalArgumentException("Constrains are empty");
        }
        if (value < ranges[0]) {
            return Pair.create(null, (Object)ranges[0]);
        }
        for (int i = 1; i < ranges.length; ++i) {
            if (ranges[i] <= ranges[i - 1]) {
                throw new IllegalArgumentException("Constrains are unsorted");
            }
            if (!(value < ranges[i])) continue;
            return Pair.create((Object)ranges[i - 1], (Object)ranges[i]);
        }
        return Pair.create((Object)ranges[ranges.length - 1], null);
    }

    protected static String findBucket(long value, Function<? super Long, String> valueConverter, long ... ranges) {
        double[] dRanges = new double[ranges.length];
        for (int i = 0; i < dRanges.length; ++i) {
            dRanges[i] = ranges[i];
        }
        return MainMenuCollector.findBucket((double)value, (? super Double d) -> (String)valueConverter.apply(d.longValue()), dRanges);
    }

    protected static String findBucket(double value, Function<? super Double, String> valueConverter, double ... ranges) {
        for (double range2 : ranges) {
            if (range2 != value) continue;
            return valueConverter.apply((Double)value);
        }
        Pair<Double, Double> bucket = MainMenuCollector.findBucket(value, ranges);
        if (bucket.first == null) {
            return "(*, " + valueConverter.apply((Double)bucket.second) + ")";
        }
        if (bucket.second == null) {
            return "(" + valueConverter.apply((Double)bucket.first) + ", *)";
        }
        return "(" + valueConverter.apply((Double)bucket.first) + ", " + valueConverter.apply((Double)bucket.second) + ")";
    }

    protected String getPathFromMenuSelectionManager(@NotNull AnAction action) {
        List<String> groups;
        if (action == null) {
            MainMenuCollector.$$$reportNull$$$0(2);
        }
        if ((groups = Arrays.stream(MenuSelectionManager.defaultManager().getSelectedPath()).filter(o -> o instanceof ActionMenu).map(o -> ((ActionMenu)((Object)((Object)o))).getText()).collect(Collectors.toList())).size() > 0) {
            String text = MainMenuCollector.getActionText(action);
            groups.add(text);
            return MainMenuCollector.convertMenuItemsToKey(groups);
        }
        return null;
    }

    private static String getActionText(@NotNull AnAction action) {
        String text;
        if (action == null) {
            MainMenuCollector.$$$reportNull$$$0(3);
        }
        if ((text = ourBlackList.get(action.getClass().getName())) != null) {
            return text;
        }
        String actionId = ActionManager.getInstance().getId(action);
        if (StringUtil.isEmpty((String)actionId)) {
            return GENERATED_ON_RUNTIME_ITEM;
        }
        return action.getTemplatePresentation().getText();
    }

    @NotNull
    private static String convertMenuItemsToKey(List<String> menuItems) {
        String string = StringUtil.join(menuItems, (String)" -> ");
        if (string == null) {
            MainMenuCollector.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getPathFromMenuItem(AWTEvent e, AnAction action) {
        Object src = e.getSource();
        ArrayList<String> items = new ArrayList<String>();
        while (src instanceof MenuItem) {
            items.add(0, ((MenuItem)src).getLabel());
            src = ((MenuItem)src).getParent();
        }
        if (items.size() > 1) {
            items.set(items.size() - 1, MainMenuCollector.getActionText(action));
        }
        String string = MainMenuCollector.convertMenuItemsToKey(items);
        if (string == null) {
            MainMenuCollector.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static MainMenuCollector getInstance() {
        return (MainMenuCollector)ServiceManager.getService(MainMenuCollector.class);
    }

    static {
        ourBlackList.put("com.intellij.ide.ReopenProjectAction", "Reopen Project");
        ourBlackList.put("com.intellij.openapi.wm.impl.ProjectWindowAction", "Switch Project");
        ourBlackList.put("com.intellij.tools.ToolAction", "External Tool");
        ourBlackList.put("com.intellij.ide.actionMacro.ActionMacroManager$InvokeMacroAction", "Invoke Macro");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/MainMenuCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/MainMenuCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMenuItemsToKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromMenuItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromMenuSelectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="path", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

