/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonLexer;
import com.intellij.json.JsonParser;
import com.intellij.json.psi.impl.JsonFileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JsonParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.WHITE_SPACE;
    public static final TokenSet STRING_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING, JsonElementTypes.DOUBLE_QUOTED_STRING});
    public static final IFileElementType FILE = new IFileElementType((Language)JsonLanguage.INSTANCE);
    public static final TokenSet JSON_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
    public static final TokenSet JSON_BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
    public static final TokenSet JSON_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.OBJECT, JsonElementTypes.ARRAY});
    public static final TokenSet JSON_BOOLEANS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
    public static final TokenSet JSON_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.STRING_LITERAL, JsonElementTypes.NUMBER_LITERAL, JsonElementTypes.NULL_LITERAL, JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_VALUES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSON_CONTAINERS, JSON_LITERALS});
    public static final TokenSet JSON_COMMENTARIES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT, JsonElementTypes.LINE_COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        JsonLexer jsonLexer = new JsonLexer();
        if (jsonLexer == null) {
            JsonParserDefinition.$$$reportNull$$$0(0);
        }
        return jsonLexer;
    }

    public PsiParser createParser(Project project) {
        return new JsonParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSON_COMMENTARIES;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = STRING_LITERALS;
        if (tokenSet == null) {
            JsonParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        PsiElement psiElement = JsonElementTypes.Factory.createElement(astNode);
        if (psiElement == null) {
            JsonParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new JsonFileImpl(fileViewProvider, JsonLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode astNode, ASTNode astNode2) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/json/JsonParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

