/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface SweepProcessor<T> {
    public boolean process(int var1, @NotNull T var2, boolean var3, @NotNull Collection<T> var4);

    public static <T extends Segment> boolean sweep(@NotNull Generator<? extends T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        PriorityQueue<Segment> ends;
        if (generator == null) {
            SweepProcessor.$$$reportNull$$$0(0);
        }
        if (sweepProcessor == null) {
            SweepProcessor.$$$reportNull$$$0(1);
        }
        if (!generator.generateInStartOffsetOrder(arg_0 -> SweepProcessor.lambda$sweep$0(ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset)), sweepProcessor, arg_0))) {
            return false;
        }
        while (!ends.isEmpty()) {
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (sweepProcessor.process(prevEnd, previous, false, ends)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$sweep$0(Queue ends, @NotNull SweepProcessor sweepProcessor, Segment marker) {
        Segment previous;
        int prevEnd;
        if (sweepProcessor == null) {
            SweepProcessor.$$$reportNull$$$0(2);
        }
        int start2 = marker.getStartOffset();
        while (!ends.isEmpty() && (prevEnd = (previous = (Segment)ends.peek()).getEndOffset()) <= start2) {
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            ends.remove();
        }
        if (!sweepProcessor.process(start2, marker, true, ends)) {
            return false;
        }
        ends.offer(marker);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sweepProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/SweepProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sweep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$sweep$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<T> var1);
    }
}

