/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.agent.RemoteAgent;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.remoteServer.agent.impl.RemoteAgentReflectiveThreadProxyFactory;
import com.intellij.util.Base64;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoteAgentManagerImpl
extends RemoteAgentManager {
    private final RemoteAgentClassLoaderCache myClassLoaderCache = new RemoteAgentClassLoaderCache();

    public <T extends RemoteAgent> T createAgent(RemoteAgentProxyFactory agentProxyFactory, List<File> instanceLibraries, List<Class<?>> commonJarClasses, String specificsRuntimeModuleName, String specificsBuildJarPath, Class<T> agentInterface, String agentClassName, Class<?> pluginClass) throws Exception {
        RemoteAgentManager.Builder builder2 = this.createAgentBuilder(agentProxyFactory, agentInterface, pluginClass).withRtDependencies(commonJarClasses).withInstanceLibraries(instanceLibraries).withModuleDependency(specificsRuntimeModuleName, specificsBuildJarPath);
        return (T)builder2.buildAgent(agentClassName);
    }

    public <T extends RemoteAgent> RemoteAgentManager.Builder<T> createAgentBuilder(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
        if (agentProxyFactory == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(0);
        }
        if (agentInterface == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(1);
        }
        if (pluginClass == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(2);
        }
        return new AgentBuilderImpl<T>(agentProxyFactory, agentInterface, pluginClass);
    }

    public RemoteAgentProxyFactory createReflectiveThreadProxyFactory(ClassLoader callerClassLoader) {
        return new RemoteAgentReflectiveThreadProxyFactory(this.myClassLoaderCache, callerClassLoader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "agentProxyFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "agentInterface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pluginClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl";
        objectArray[2] = "createAgentBuilder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AgentBuilderImpl<T extends RemoteAgent>
    extends RemoteAgentManager.Builder<T> {
        private final List<Class<?>> myRtClasses;
        private final List<File> myInstanceLibraries;
        private final List<File> myModuleDependencies;
        private final RemoteAgentProxyFactory myAgentProxyFactory;
        private final Class<T> myAgentInterface;
        private final String myAllPluginsRoot;
        private final boolean myRunningFromSources;

        AgentBuilderImpl(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
            if (agentProxyFactory == null) {
                AgentBuilderImpl.$$$reportNull$$$0(0);
            }
            if (agentInterface == null) {
                AgentBuilderImpl.$$$reportNull$$$0(1);
            }
            if (pluginClass == null) {
                AgentBuilderImpl.$$$reportNull$$$0(2);
            }
            this.myRtClasses = new ArrayList();
            this.myInstanceLibraries = new ArrayList<File>();
            this.myModuleDependencies = new ArrayList<File>();
            this.myAgentProxyFactory = agentProxyFactory;
            this.myAgentInterface = agentInterface;
            File plugin = new File(PathUtil.getJarPathForClass(pluginClass));
            this.myAllPluginsRoot = plugin.getParent();
            this.myRunningFromSources = plugin.isDirectory();
        }

        public T buildAgent(@NotNull String agentClassName) throws Exception {
            if (agentClassName == null) {
                AgentBuilderImpl.$$$reportNull$$$0(3);
            }
            List<File> libraries = this.listLibraryFiles();
            return (T)((RemoteAgent)this.myAgentProxyFactory.createProxy(libraries, this.myAgentInterface, agentClassName));
        }

        @NotNull
        private List<File> listLibraryFiles() {
            ArrayList<File> result2 = new ArrayList<File>(this.myInstanceLibraries);
            ArrayList allRtClasses = new ArrayList(this.myRtClasses);
            allRtClasses.add(RemoteAgent.class);
            allRtClasses.add(Base64.class);
            allRtClasses.add(this.myAgentInterface);
            for (Class clazz : allRtClasses) {
                result2.add(new File(PathUtil.getJarPathForClass((Class)clazz)));
            }
            result2.addAll(this.myModuleDependencies);
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                AgentBuilderImpl.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        public RemoteAgentManager.Builder<T> withRtDependency(@NotNull Class<?> rtClass) {
            if (rtClass == null) {
                AgentBuilderImpl.$$$reportNull$$$0(5);
            }
            this.myRtClasses.add(rtClass);
            return this;
        }

        public RemoteAgentManager.Builder<T> withInstanceLibraries(@NotNull List<File> libraries) {
            if (libraries == null) {
                AgentBuilderImpl.$$$reportNull$$$0(6);
            }
            this.myInstanceLibraries.addAll(libraries);
            return this;
        }

        public RemoteAgentManager.Builder<T> withModuleDependency(@NotNull String runtimeModuleName, @NotNull String buildPathToJar) {
            if (runtimeModuleName == null) {
                AgentBuilderImpl.$$$reportNull$$$0(7);
            }
            if (buildPathToJar == null) {
                AgentBuilderImpl.$$$reportNull$$$0(8);
            }
            if (this.myRunningFromSources) {
                File specificsModule = new File(this.myAllPluginsRoot, runtimeModuleName);
                this.myModuleDependencies.add(specificsModule);
            } else {
                File specificsDir = new File(this.myAllPluginsRoot, FileUtil.toSystemDependentName((String)buildPathToJar));
                this.myModuleDependencies.add(specificsDir);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentProxyFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentInterface";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentClassName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl$AgentBuilderImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rtClass";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraries";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtimeModuleName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildPathToJar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl$AgentBuilderImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listLibraryFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildAgent";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRtDependency";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withInstanceLibraries";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withModuleDependency";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

