/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.List;
import java.util.Random;
import org.jetbrains.jetCheck.BoundedIntDistribution;

public interface IntDistribution {
    public int generateInt(Random var1);

    public boolean isValidValue(int var1);

    public int getMin();

    public int getMax();

    public static IntDistribution uniform(int min, int max) {
        return new BoundedIntDistribution(min, max, r -> {
            int i;
            if (min == max) {
                return min;
            }
            int range = max - min + 1;
            if (range > 0) {
                return r.nextInt(range) + min;
            }
            while ((i = r.nextInt()) < min || i > max) {
            }
            return i;
        });
    }

    public static IntDistribution geometric(int mean) {
        double p = 1.0 / (double)(mean + 1);
        return new BoundedIntDistribution(0, Integer.MAX_VALUE, random -> {
            double u = random.nextDouble();
            return (int)(Math.log(u) / Math.log(1.0 - p));
        });
    }

    public static IntDistribution frequencyDistribution(List<Integer> weights) {
        if (weights.isEmpty()) {
            throw new IllegalArgumentException("No alternatives to choose from");
        }
        int sum = weights.stream().reduce(0, (a, b) -> a + b);
        return new BoundedIntDistribution(0, weights.size() - 1, r -> {
            int value = r.nextInt(sum);
            for (int i = 0; i < weights.size(); ++i) {
                if ((value -= ((Integer)weights.get(i)).intValue()) >= 0) continue;
                return i;
            }
            throw new IllegalArgumentException();
        });
    }
}

