/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.ui.FormUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CvsRootFieldByFieldConfigurationPanel {
    private JComboBox myMethods;
    private JTextField myUser;
    private JTextField myHost;
    private JTextField myPort;
    private JTextField myRepository;
    private JPanel myPanel;

    public CvsRootFieldByFieldConfigurationPanel() {
        this.$$$setupUI$$$();
    }

    public void updateFrom(CvsRootData config) {
        this.myMethods.removeAllItems();
        for (CvsMethod method : CvsMethod.AVAILABLE_METHODS) {
            this.myMethods.addItem(method);
        }
        this.myMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CvsMethod cvsMethod = (CvsMethod)CvsRootFieldByFieldConfigurationPanel.this.myMethods.getSelectedItem();
                CvsRootFieldByFieldConfigurationPanel.this.myUser.setEnabled(cvsMethod.hasUserValue());
                CvsRootFieldByFieldConfigurationPanel.this.myHost.setEnabled(cvsMethod.hasHostValue());
                CvsRootFieldByFieldConfigurationPanel.this.myPort.setEnabled(cvsMethod.hasPortValue());
            }
        });
        CvsMethod method = config.METHOD;
        this.myMethods.setSelectedItem(method);
        this.myUser.setText(config.USER);
        this.myHost.setText(config.HOST);
        if (config.PORT > 0) {
            this.myPort.setText(String.valueOf(config.PORT));
        }
        this.myRepository.setText(config.REPOSITORY);
    }

    public String getSettings() {
        int port = FormUtils.getPositiveIntFieldValue(this.myPort, true, true, 65535);
        CvsMethod cvsMethod = (CvsMethod)this.myMethods.getSelectedItem();
        String user = FormUtils.getFieldValue(this.myUser, cvsMethod.hasUserValue());
        String host = FormUtils.getFieldValue(this.myHost, cvsMethod.hasHostValue());
        String repository = FormUtils.getFieldValue(this.myRepository, true);
        return CvsRootConfiguration.createStringRepresentationOn(cvsMethod, user, host, port, repository);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMethods;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myMethods = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.method"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.user"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUser = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.host"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHost = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.repository"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myRepository = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.port"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPort = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

