/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsImport;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public class ImportDetails {
    private final File myBaseImportDirectory;
    private final String myVendor;
    private final String myReleaseTag;
    private final String myLogMessage;
    private final String myModuleName;
    private final CvsEnvironment myEnvironment;
    private final Collection<? extends FileExtension> myWrappers;
    private final IIgnoreFileFilter myIgnoreFileFilter;

    public ImportDetails(@NotNull File baseImportDirectory, String vendor, String releaseTag, String logMessage, String moduleName, CvsEnvironment env, Collection<? extends FileExtension> wrappers, IIgnoreFileFilter ignoreFileFilter) {
        if (baseImportDirectory == null) {
            ImportDetails.$$$reportNull$$$0(0);
        }
        this.myBaseImportDirectory = baseImportDirectory;
        this.myVendor = vendor;
        this.myReleaseTag = releaseTag;
        this.myLogMessage = logMessage;
        this.myModuleName = moduleName;
        this.myEnvironment = env;
        this.myWrappers = wrappers;
        this.myIgnoreFileFilter = ignoreFileFilter;
    }

    public void prepareCommand(ImportCommand result) {
        result.setVendorTag(this.myVendor);
        result.setReleaseTag(this.myReleaseTag);
        result.setModule(this.getModulePath());
        result.setLogMessage(this.myLogMessage);
        for (FileExtension fileExtension : this.myWrappers) {
            result.addWrapper("*." + fileExtension.getExtension(), fileExtension.getKeywordSubstitution().getSubstitution());
        }
    }

    public int getTotalFilesInSourceDirectory() {
        return CvsOperation.calculateFilesIn(this.myBaseImportDirectory);
    }

    private String getModulePath() {
        String relativePath = FileUtil.getRelativePath((File)this.myBaseImportDirectory.getAbsoluteFile().getParentFile(), (File)this.myBaseImportDirectory.getAbsoluteFile());
        return this.replaceBaseImportDirectoryNameToModuleNameIn(relativePath);
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    private String replaceBaseImportDirectoryNameToModuleNameIn(String relativePath) {
        return this.myModuleName + relativePath.substring(this.myBaseImportDirectory.getName().length());
    }

    public File getBaseImportDirectory() {
        return this.myBaseImportDirectory;
    }

    public CvsRootProvider getCvsRoot() {
        return CvsRootProvider.createOn(this.myBaseImportDirectory, this.myEnvironment);
    }

    public IIgnoreFileFilter getIgnoreFileFilter() {
        return this.myIgnoreFileFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseImportDirectory", "com/intellij/cvsSupport2/cvsoperations/cvsImport/ImportDetails", "<init>"));
    }
}

