/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public PhpHighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        PsiElement parent = this.myTarget.getParent();
        if (!(parent instanceof PhpReturn) && !(parent instanceof PhpThrow)) {
            return;
        }
        Function f = (Function)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, Function.class);
        if (f == null) {
            return;
        }
        f.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
            }

            public void visitPhpMethod(Method method) {
            }

            public void visitPhpFunction(Function function) {
            }

            public void visitPhpThrow(PhpThrow throwStatement) {
                PhpHighlightExitPointsHandler.this.myWriteUsages.add(throwStatement.getTextRange());
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                PhpHighlightExitPointsHandler.this.myReadUsages.add(returnStatement.getTextRange());
            }
        });
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }
}

