/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ComposerPackagistUtil {
    private static final Logger LOG = Logger.getInstance(ComposerPackagistUtil.class);
    @NonNls
    private static final String PACKAGIST_URL = "https://packagist.org/";
    @NonNls
    private static final String PATH_OF_PACKAGE_NAMES_LIST = "packages/list.json";
    @NonNls
    private static final String PATH_OF_PACKAGE_DESCRIPTION = "packages/";

    private ComposerPackagistUtil() {
    }

    public static List<String> getPackageNames() throws IOException {
        return (List)ComposerPackagistUtil.loadJSON(PATH_OF_PACKAGE_NAMES_LIST, reader -> ComposerPackagistUtil.parsePackageNames(reader));
    }

    private static List<String> parsePackageNames(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            ComposerPackagistUtil.$$$reportNull$$$0(0);
        }
        JsonParser parser = new JsonParser();
        try {
            JsonElement element = parser.parse(reader);
            if (!(element instanceof JsonObject)) {
                throw new JsonSyntaxException("Parsed element is not an object.");
            }
            JsonObject object = (JsonObject)element;
            JsonElement packageNames = object.get("packageNames");
            if (packageNames == null) {
                throw new JsonSyntaxException("No packageNames found");
            }
            if (!(packageNames instanceof JsonArray)) {
                throw new JsonSyntaxException("packageNames is not an array");
            }
            JsonArray packageNamesArray = (JsonArray)packageNames;
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement jsonElement : packageNamesArray) {
                result.add(jsonElement.getAsString());
            }
            return result;
        }
        catch (JsonIOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.load.package.names", new Object[0]));
        }
        catch (JsonSyntaxException e) {
            LOG.warn("Failed to parse package names.\n", (Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.names", new Object[0]));
        }
    }

    private static <T> T loadJSON(@NonNls String path, final @NotNull ThrowableConvertor<Reader, T, IOException> convertor) throws IOException {
        if (convertor == null) {
            ComposerPackagistUtil.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Do not use network from AWT thread.");
        }
        String location = PACKAGIST_URL + path;
        try {
            return (T)HttpRequests.request((String)(PACKAGIST_URL + path)).connect(new HttpRequests.RequestProcessor<T>(){

                public T process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return convertor.convert((Object)request.getReader());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/php/composer/addDependency/ComposerPackagistUtil$1", "process"));
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(PhpBundle.message("framework.composer.failed.to.connect.to.0.1.please.check.your.internet.connection", location, e.getMessage()));
        }
    }

    @NotNull
    public static ComposerPackage getPackage(String name) throws IOException {
        ComposerPackage composerPackage = (ComposerPackage)ComposerPackagistUtil.loadJSON(PATH_OF_PACKAGE_DESCRIPTION + StringUtil.toLowerCase((String)name) + ".json", reader -> ComposerPackagistUtil.parsePackageDescriptionJSON(name, reader));
        if (composerPackage == null) {
            ComposerPackagistUtil.$$$reportNull$$$0(2);
        }
        return composerPackage;
    }

    @NotNull
    public static ComposerPackage parsePackageDescriptionJSON(String name, @NotNull Reader json) throws IOException {
        ComposerPackage composerPackage;
        block16: {
            if (json == null) {
                ComposerPackagistUtil.$$$reportNull$$$0(3);
            }
            JsonParser parser = new JsonParser();
            try {
                Set<String> versions;
                JsonElement element = parser.parse(json);
                if (!(element instanceof JsonObject)) {
                    throw new JsonSyntaxException("Parsed element is not an object.");
                }
                JsonObject object = (JsonObject)element;
                JsonElement aPackage = object.get("package");
                if (aPackage == null) {
                    throw new JsonSyntaxException("No package found");
                }
                if (!(aPackage instanceof JsonObject)) {
                    throw new JsonSyntaxException("package is not an object");
                }
                JsonObject packageObject = (JsonObject)aPackage;
                JsonElement nameElement = packageObject.get("name");
                if (nameElement == null) {
                    throw new JsonSyntaxException("No name found");
                }
                String nameText = nameElement.getAsString();
                JsonElement descriptionElement = packageObject.get("description");
                if (descriptionElement == null) {
                    throw new JsonSyntaxException("No description found");
                }
                String descriptionText = descriptionElement instanceof JsonNull ? PhpBundle.message("framework.composer.no.description.available", new Object[0]) : descriptionElement.getAsString();
                JsonElement versionsElement = packageObject.get("versions");
                if (versionsElement == null) {
                    versions = Collections.emptySet();
                } else if (versionsElement instanceof JsonArray) {
                    JsonArray versionsArray = (JsonArray)versionsElement;
                    versions = new HashSet();
                    for (JsonElement jsonElement : versionsArray) {
                        versions.add(jsonElement.getAsString());
                    }
                } else if (versionsElement instanceof JsonObject) {
                    JsonObject versionsObject = (JsonObject)versionsElement;
                    versions = new HashSet();
                    for (Map.Entry entry : versionsObject.entrySet()) {
                        versions.add((String)entry.getKey());
                        ComposerPackagistUtil.addAliasesToVersions((JsonElement)entry.getValue(), versions);
                    }
                } else {
                    throw new JsonSyntaxException("versions is not an object nor array");
                }
                if ((composerPackage = new ComposerPackage(nameText, new ArrayList<String>(versions), descriptionText)) != null) break block16;
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Failed to parse package description for " + name + ". Text:\n" + json);
                LOG.warn((Throwable)e);
                throw new IOException(PhpBundle.message("framework.composer.failed.to.parse.package.description", new Object[0]));
            }
            ComposerPackagistUtil.$$$reportNull$$$0(4);
        }
        return composerPackage;
    }

    private static void addAliasesToVersions(JsonElement value, Set<String> versions) {
        if (!(value instanceof JsonObject)) {
            return;
        }
        JsonElement extraElement = ((JsonObject)value).get("extra");
        if (!(extraElement instanceof JsonObject)) {
            return;
        }
        JsonElement branchAliasElement = ((JsonObject)extraElement).get("branch-alias");
        if (!(branchAliasElement instanceof JsonObject)) {
            return;
        }
        for (Map.Entry entry : ((JsonObject)branchAliasElement).entrySet()) {
            JsonElement aliasElement = (JsonElement)entry.getValue();
            if (!(aliasElement instanceof JsonPrimitive)) continue;
            versions.add(aliasElement.getAsString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/addDependency/ComposerPackagistUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/addDependency/ComposerPackagistUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageDescriptionJSON";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadJSON";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageDescriptionJSON";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

