/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PhpOptionalBeforeRequiredParametersInspection
extends PhpInspection {
    public static final String MESSAGE = PhpBundle.message("inspection.optional.before.required", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpOptionalBeforeRequiredParametersInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpOptionalBeforeRequiredParametersInspection.process(function, holder);
            }

            public void visitPhpClass(PhpClass clazz) {
                for (Method it : clazz.getOwnMethods()) {
                    PhpOptionalBeforeRequiredParametersInspection.process((Function)it, holder);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpOptionalBeforeRequiredParametersInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void process(Function function, ProblemsHolder holder) {
        Parameter[] parameters = function.getParameters();
        if (parameters.length == 0) {
            return;
        }
        int lastRequired = ContainerUtil.lastIndexOf(Arrays.asList(parameters), p -> !p.isOptional() && !p.isVariadic());
        for (int i = 0; i < lastRequired; ++i) {
            if (!parameters[i].isOptional()) continue;
            holder.registerProblem((PsiElement)parameters[i], MESSAGE, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpOptionalBeforeRequiredParametersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpOptionalBeforeRequiredParametersInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

