/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.codeGeneration;

import com.intellij.internal.statistic.service.fus.collectors.FUSProjectUsageTrigger;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.phpunit.statistics.PhpNewTestDescriptorUsageCollector;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewTestAction
extends PhpNewBaseAction {
    public PhpNewTestAction() {
        this(PhpBundle.message("actions.new.test.class.action.name", new Object[0]), PhpBundle.message("actions.new.test.class.action.description", new Object[0]), PhpIcons.PHP_TEST_FILE);
    }

    protected PhpNewTestAction(@NotNull String actionName, @NotNull String description, @NotNull Icon icon) {
        if (actionName == null) {
            PhpNewTestAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            PhpNewTestAction.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            PhpNewTestAction.$$$reportNull$$$0(2);
        }
        super(actionName, description, icon);
    }

    @Override
    @Nullable
    protected PhpNewTestDialog getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            PhpNewTestAction.$$$reportNull$$$0(4);
        }
        PhpNamedElement targetElement = PhpNewTestAction.getTargetElement(file, editor);
        PhpNewTestDialog dialog = new PhpNewTestDialog(project, directory, file, this.getDefaultTestCreateInfo(project), targetElement);
        if (!dialog.showAndGet()) {
            return null;
        }
        this.reportStatistics(project, dialog, targetElement);
        return dialog;
    }

    private void reportStatistics(@NotNull Project project, @NotNull PhpNewTestDialog dataProvider, @Nullable PhpNamedElement targetElement) {
        PsiFile targetFile;
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(5);
        }
        if (dataProvider == null) {
            PhpNewTestAction.$$$reportNull$$$0(6);
        }
        PhpNewTestAction.reportAction(project, PhpNewTestAction.getTargetElementStatus(targetElement));
        PhpNewTestAction.reportAction(project, PhpNewTestAction.getSourceElementStatus(targetElement));
        String testMethodsStatus = dataProvider.getSelectedClassMembers().isEmpty() ? ".without.selected.methods" : "";
        String name = UsageDescriptorKeyValidator.ensureProperKey((String)dataProvider.getSelectedTestCreateInfo().getName());
        PhpNewTestAction.reportAction(project, "with.framework." + name + testMethodsStatus);
        if (dataProvider.isLibraryChanged()) {
            PhpNewTestAction.reportAction(project, "library.changed.from." + this.getTemplatePresentation().getText());
        }
        PsiFile psiFile = targetFile = targetElement != null ? targetElement.getContainingFile() : null;
        if (targetFile != null && dataProvider.isInheritedMembersOptionSelected() && dataProvider.getSelectedClassMembers().stream().anyMatch(m -> m.getContainingFile() != targetFile)) {
            PhpNewTestAction.reportAction(project, "with.inherited.member.selected");
        }
    }

    @NotNull
    private static String getSourceElementStatus(@Nullable PhpNamedElement element) {
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (containingClass == null) {
            if ("source.empty" == null) {
                PhpNewTestAction.$$$reportNull$$$0(7);
            }
            return "source.empty";
        }
        if (containingClass.isInterface()) {
            if ("source.interface" == null) {
                PhpNewTestAction.$$$reportNull$$$0(8);
            }
            return "source.interface";
        }
        if (containingClass.isTrait()) {
            if ("source.trait" == null) {
                PhpNewTestAction.$$$reportNull$$$0(9);
            }
            return "source.trait";
        }
        if ("source.class" == null) {
            PhpNewTestAction.$$$reportNull$$$0(10);
        }
        return "source.class";
    }

    @NotNull
    private static String getTargetElementStatus(@Nullable PhpNamedElement element) {
        if (element instanceof PhpClass) {
            if ("from.class" == null) {
                PhpNewTestAction.$$$reportNull$$$0(11);
            }
            return "from.class";
        }
        if (element instanceof Method) {
            if ("from.method" == null) {
                PhpNewTestAction.$$$reportNull$$$0(12);
            }
            return "from.method";
        }
        if ("without.target.element" == null) {
            PhpNewTestAction.$$$reportNull$$$0(13);
        }
        return "without.target.element";
    }

    private static void reportAction(@NotNull Project project, @NotNull String descriptorSuffix) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(14);
        }
        if (descriptorSuffix == null) {
            PhpNewTestAction.$$$reportNull$$$0(15);
        }
        FUSProjectUsageTrigger.getInstance((Project)project).trigger(PhpNewTestDescriptorUsageCollector.class, descriptorSuffix);
    }

    @Nullable
    private static PhpNamedElement getTargetElement(@Nullable PsiFile file, @Nullable Editor editor) {
        PsiElement targetElement = editor != null && file != null ? TestFinderHelper.findSourceElement((PsiElement)PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset())) : null;
        return (PhpNamedElement)ObjectUtils.tryCast(targetElement, PhpNamedElement.class);
    }

    @Nullable
    protected PhpTestCreateInfo getDefaultTestCreateInfo(@NotNull Project project) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull PhpCreateFileFromTemplateDataProvider dataProvider) {
        PsiFile createdTestClassFile;
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(17);
        }
        if (dataProvider == null) {
            PhpNewTestAction.$$$reportNull$$$0(18);
        }
        if ((createdTestClassFile = super.createFile(project, dataProvider)) != null && dataProvider instanceof PhpNewTestDialog) {
            PhpNewTestAction.addTestMethods(project, (PhpNewTestDialog)dataProvider, createdTestClassFile);
        }
        return createdTestClassFile;
    }

    @Override
    @Nullable
    protected PhpCreateFileFromTemplateDataProvider getDataProvider(@NotNull Project project, @NotNull PsiDirectory directory, @Nullable PsiFile file) {
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(19);
        }
        if (directory == null) {
            PhpNewTestAction.$$$reportNull$$$0(20);
        }
        return null;
    }

    private static void addTestMethods(@NotNull Project project, @NotNull PhpNewTestDialog dataProvider, @NotNull PsiFile file) {
        Set<PhpClassMember> members;
        if (project == null) {
            PhpNewTestAction.$$$reportNull$$$0(21);
        }
        if (dataProvider == null) {
            PhpNewTestAction.$$$reportNull$$$0(22);
        }
        if (file == null) {
            PhpNewTestAction.$$$reportNull$$$0(23);
        }
        if ((members = dataProvider.getSelectedClassMembers()).isEmpty()) {
            return;
        }
        PhpClass testClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)file, PhpClass.class);
        if (testClass == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (dataProvider == null) {
                PhpNewTestAction.$$$reportNull$$$0(25);
            }
            if (project == null) {
                PhpNewTestAction.$$$reportNull$$$0(26);
            }
            PhpTestCreateInfo testCreateInfo = dataProvider.getSelectedTestCreateInfo();
            for (PhpClassMember member : members) {
                Method testMethod = PhpPsiElementFactory.createMethod(project, testCreateInfo.getTestMethodText(project, dataProvider.getTargetClassFqn(), member.getName()));
                PhpCodeEditUtil.insertClassMemberWithPhpDoc(testClass, (PsiElement)testMethod, testMethod.getDocComment());
            }
        });
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        PsiFile data;
        PhpClass aClass;
        if (e == null) {
            PhpNewTestAction.$$$reportNull$$$0(24);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isVisible() && (aClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)PhpNewTestAction.getTargetElement(data = this.getFile(e.getDataContext()), (Editor)e.getDataContext().getData(CommonDataKeys.EDITOR)), PhpClass.class, (boolean)false)) != null) {
            String name = aClass.getName();
            PhpTestCreateInfo defaultTestCreateInfo = this.getDefaultTestCreateInfo(aClass.getProject());
            if (defaultTestCreateInfo != null) {
                presentation.setText(defaultTestCreateInfo.getDefaultTestName(name));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestAction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorSuffix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceElementStatus";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElementStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportStatistics";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestCreateInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTestMethods";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTestMethods$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

